/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.network;

import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.shared.network.AuthorizationPacket;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import org.apache.log4j.Category;

public abstract class ClientAuthenticator
implements MSConstants {
    protected int id;
    protected String host;
    protected String name;
    private static Category log = Category.getInstance(ClientAuthenticator.class);

    public ClientAuthenticator(String host, String name) {
        this.host = host;
        this.name = name;
        this.initAuthenticator();
    }

    public boolean connect() {
        try {
            AuthorizationPacket authPack;
            AuthorizationPacket packet = new AuthorizationPacket(this.name, 0);
            log.debug((Object)("Client " + this.name + " is sending authorization request to server"));
            this.sendAuthRequest(packet);
            do {
                if ((authPack = this.receiveAuthResponse()).getType() != 4) continue;
                this.id = authPack.getId();
                log.info((Object)("Client " + this.name + " has received ID " + this.id + " from the server: " + this.host));
                this.initCommunicator(this.id);
                return true;
            } while (authPack.getType() != 5);
            log.info((Object)("Client " + this.name + " has been rejected by the server"));
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Error while trying to connect to server", (Throwable)e);
            return false;
        }
    }

    public abstract void sendAuthRequest(AuthorizationPacket var1);

    public abstract AuthorizationPacket receiveAuthResponse();

    public abstract void initAuthenticator();

    public abstract void initCommunicator(int var1);

    public abstract boolean reconnect();

    public abstract ClientCommunicator getCommunicator();

    public abstract void close();

    public int getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }
}

