/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.client.interfaces.util.webbrowser.Browser;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class WebCampaignGUI
extends ClientGUI {
    private JScrollPane scrollPane;
    private JScrollPane questionScroller;
    private JPanel titlePanel = new JPanel();
    private JPanel inputPanel;
    private JPanel questionPanel;
    private JPanel webPanel;
    private JPanel numClicksPanel;
    private JPanel timeElapsedPanel;
    private JLabel titleLabel = new JLabel();
    private JLabel questionLabel;
    private JLabel numClicksLabel;
    private JLabel timeElapsedLabel;
    private JLabel timeLeftLabel;
    private JTextArea inputText;
    private JButton submitButton;
    private JButton createBrowserButton;
    private Browser browser;
    private String libPath;
    long time;
    long timeLeft;
    private boolean checkClicks;
    private String commandLine;
    private int width;
    private int height;
    private int browserHeight;
    private boolean singlePlayerTest;
    Timer timer;
    private boolean constructedLayout;
    public static Category log = Category.getInstance(WebCampaignGUI.class);

    public WebCampaignGUI() {
        this.inputPanel = new JPanel();
        this.questionPanel = new JPanel();
        this.webPanel = new JPanel();
        this.inputText = new JTextArea();
        this.submitButton = new JButton();
        this.questionLabel = new JLabel();
        this.questionScroller = new JScrollPane();
        this.timeElapsedPanel = new JPanel();
        this.numClicksPanel = new JPanel();
        this.timeLeftLabel = new JLabel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                WebCampaignGUI.this.exitForm(evt);
            }
        });
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.width = screenSize.width;
        this.height = screenSize.height;
        this.titleLabel.setText("Loading");
        this.titleLabel.setForeground(Color.black);
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setHorizontalAlignment(0);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.setMaximumSize(new Dimension(20000, 60));
        JPanel panel1 = new JPanel();
        panel1.setMaximumSize(new Dimension(20000, 50));
        JLabel directions1 = new JLabel("Answer the following question by searching the web");
        directions1.setFont(new Font("Book Antiqua", 0, 16));
        panel1.add(directions1);
        this.questionLabel.setFont(new Font("Book Antiqua", 1, 16));
        this.questionScroller.setMaximumSize(new Dimension(20000, 60));
        this.questionScroller.setViewportView(this.questionPanel);
        this.questionPanel.add(this.questionLabel);
        this.getContentPane().add(this.questionScroller);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 3));
        JLabel directions2 = new JLabel("Enter your response here, then click the submit button");
        directions2.setFont(new Font("Book Antiqua", 0, 16));
        directions2.setHorizontalAlignment(0);
        this.createBrowserButton = new JButton("Open New Browser");
        this.createBrowserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebCampaignGUI.this.browser.closeBrowser();
                WebCampaignGUI.this.browser.startBrowser(0, 0, WebCampaignGUI.this.width, WebCampaignGUI.this.browserHeight, WebCampaignGUI.this.singlePlayerTest);
            }
        });
        this.createBrowserButton.setEnabled(false);
        JPanel createBrowserPanel = new JPanel();
        createBrowserPanel.add(this.createBrowserButton);
        JPanel smallInfoPanel = new JPanel();
        this.timeElapsedPanel.setLayout(new GridLayout(0, 1));
        this.numClicksLabel = new JLabel("Number of Clicks: 0");
        this.numClicksLabel.setHorizontalAlignment(0);
        this.timeElapsedLabel = new JLabel("Time (Seconds) Elapsed: " + this.time);
        this.timeElapsedLabel.setHorizontalAlignment(0);
        this.timeLeftLabel = new JLabel("Time (Seconds) Remaining: " + this.time);
        this.timeLeftLabel.setHorizontalAlignment(0);
        panel2.add(this.numClicksPanel);
        panel2.add(directions2);
        panel2.add(this.timeElapsedPanel);
        panel2.setMinimumSize(new Dimension(800, 50));
        this.getContentPane().add(panel2);
        this.inputPanel.setMinimumSize(new Dimension(800, 50));
        this.inputPanel.setPreferredSize(new Dimension(800, 50));
        this.inputPanel.add(createBrowserPanel);
        this.inputText.setPreferredSize(new Dimension(650, 30));
        this.inputText.setMinimumSize(new Dimension(650, 30));
        this.inputPanel.add(this.inputText);
        this.submitButton.setText("Submit Response");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebCampaignGUI.this.sendResponse(false);
            }
        });
        this.inputPanel.add(this.submitButton);
        this.getContentPane().add(this.inputPanel);
        this.pack();
        this.centerOnScreen();
    }

    private void sendResponse(boolean timeExpired) {
        this.submitButton.setEnabled(false);
        this.createBrowserButton.setEnabled(false);
        this.timer.cancel();
        this.checkClicks = false;
        this.browser.closeBrowser();
        Information info = new Information();
        if (!timeExpired) {
            info.addInfo("response", this.inputText.getText());
            info.addInfo("numClicks", "" + this.browser.getNumClicks());
            info.addInfo("time", "" + this.time);
            info.addInfo("responseType", "normal");
            JOptionPane.showMessageDialog(null, "<html>Thank you for your answer, please click OK to proceed.</html>", "Round Complete", 0);
        } else {
            info.addInfo("responseType", "expired");
            JOptionPane.showMessageDialog(null, "<html>You have run out of time to complete this state. Press the OK<br>button to proceed to the next state. Thank you!</html>", "Round Complete", 0);
        }
        this.send(info);
        this.browser.resetNumClicks();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void close() {
    }

    protected void constructLayout(Information info, ClientData clientData) {
        try {
            log.debug((Object)"Constructing layout...");
            this.submitButton.setEnabled(false);
            this.checkClicks = false;
            this.titleLabel.setText(clientData.getName());
            final boolean debugInfo = (Boolean)info.getInfo("debug");
            this.singlePlayerTest = info.getBooleanInfo("singlePlayerTest");
            this.commandLine = (String)info.getInfo("commandLine");
            this.libPath = (String)info.getInfo("libPath");
            log.debug((Object)"Retrieved information from server request to construct layout");
            this.time = 0L;
            this.timeElapsedLabel.setText("Time (Seconds) Elapsed: " + this.time);
            if (this.browser == null) {
                this.browser = new Browser(this.libPath);
            }
            this.browser.setCommandLine(this.commandLine);
            log.debug((Object)"Created initial browser in client layout construction");
            this.inputText.setText("");
            Runnable doUpdate = new Runnable(){

                public void run() {
                    log.debug((Object)"Running GUI construction swing code");
                    WebCampaignGUI.this.numClicksPanel.removeAll();
                    WebCampaignGUI.this.timeElapsedPanel.removeAll();
                    if (debugInfo) {
                        WebCampaignGUI.this.numClicksPanel.add(WebCampaignGUI.this.numClicksLabel);
                        WebCampaignGUI.this.timeElapsedPanel.add(WebCampaignGUI.this.timeElapsedLabel);
                    }
                    WebCampaignGUI.this.timeElapsedPanel.add(WebCampaignGUI.this.timeLeftLabel);
                    WebCampaignGUI.this.questionLabel.setText("Initializing");
                    WebCampaignGUI.this.pack();
                    int guiHeight = (int)Math.floor(WebCampaignGUI.this.height / 4);
                    int guiY = (int)Math.floor(3 * WebCampaignGUI.this.height / 4);
                    WebCampaignGUI.this.setLocation(0, guiY);
                    WebCampaignGUI.this.setSize(WebCampaignGUI.this.width, guiHeight);
                    WebCampaignGUI.this.validate();
                    WebCampaignGUI.this.repaint();
                    log.debug((Object)"Finished GUI construction swing code");
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
            this.createBrowserButton.setEnabled(true);
            this.browserHeight = (int)Math.floor(3 * this.height / 4);
            log.debug((Object)"Finished constructing layout -- telling waiting threads to proceed");
            this.notifyEndConstruction();
            this.repaint();
        }
        catch (Exception e) {
            log.error((Object)"Failed to construct layout in webcampaign", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void constructWaitingLayout(Information info) {
        this.validate();
        this.repaint();
    }

    public void initialize() {
        this.constructedLayout = false;
        this.setVisible(true);
    }

    private synchronized void notifyEndConstruction() {
        this.constructedLayout = true;
        this.notifyAll();
    }

    private synchronized void waitForConstruction() {
        try {
            log.debug((Object)"Waiting for GUI construction to finish before processing message");
            while (!this.constructedLayout) {
                this.wait();
            }
            log.debug((Object)"Proceeding with message processing -- GUI construction finished");
        }
        catch (Exception e) {
            log.error((Object)"Error while waiting for GUI construction to finish", (Throwable)e);
        }
    }

    public void respond(Object obj) {
        try {
            log.debug((Object)"Received a WebCampaign asynchronous message");
            this.waitForConstruction();
            this.checkClicks = false;
            Information info = (Information)obj;
            final String query = (String)info.getInfo("query");
            String homepage = (String)info.getInfo("homepage");
            String finishedMessage = (String)info.getInfo("finishedMessage");
            String resetTimer = (String)info.getInfo("newState");
            log.debug((Object)"Retrieved infromation from WebCampaign asynchronous message");
            if (finishedMessage != null) {
                log.debug((Object)"Displaying the finish message...");
                JOptionPane.showMessageDialog(null, finishedMessage, "Complete", 0);
                this.submitButton.setEnabled(false);
                this.questionLabel.setText(finishedMessage);
                log.debug((Object)"Displayed the finish message");
                return;
            }
            if (resetTimer != null && resetTimer.equals("true")) {
                log.debug((Object)"Resetting the WebCampaign client timer");
                this.timeLeft = (Long)info.getInfo("time");
            }
            this.time = 0L;
            this.timeElapsedLabel.setText("Time (Seconds) Elapsed: " + this.time);
            if (this.browser == null) {
                log.debug((Object)"Instantiating a new browser for the current question...");
                this.browser = new Browser(this.libPath);
                log.debug((Object)"Instantiated new browser");
            }
            this.browser.setHomePage(homepage);
            log.debug((Object)("Set browser homepage to " + homepage));
            this.inputText.setText("");
            Runnable doUpdate = new Runnable(){

                public void run() {
                    log.debug((Object)"Performing GUI swing operations to display next question");
                    WebCampaignGUI.this.questionLabel.setText(query);
                    WebCampaignGUI.this.pack();
                    int guiHeight = (int)Math.floor(WebCampaignGUI.this.height / 4);
                    int guiY = (int)Math.floor(3 * WebCampaignGUI.this.height / 4);
                    WebCampaignGUI.this.setLocation(0, guiY);
                    WebCampaignGUI.this.setSize(WebCampaignGUI.this.width, guiHeight);
                    WebCampaignGUI.this.validate();
                    WebCampaignGUI.this.repaint();
                    log.debug((Object)"Finished the GUI swing operations");
                }
            };
            SwingUtilities.invokeLater(doUpdate);
            Runnable clicker = new Runnable(){

                public void run() {
                    try {
                        log.debug((Object)"Started the click-counting process");
                        while (WebCampaignGUI.this.checkClicks) {
                            Thread.sleep(1000L);
                            WebCampaignGUI.this.numClicksLabel.setText("Number of Clicks: " + WebCampaignGUI.this.browser.updateNumClicks());
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Failure while checking for number of clicks", (Throwable)e);
                    }
                }
            };
            Thread clickThread = new Thread(clicker);
            log.debug((Object)"Finished creating the click counter thread");
            this.browserHeight = (int)Math.floor(3 * this.height / 4);
            this.browser.resetNumClicks();
            log.info((Object)("Homepage is: " + homepage + " for partner number: " + this.partnerNum));
            if (!this.browser.startBrowser(0, 0, this.width, this.browserHeight, this.singlePlayerTest)) {
                log.warn((Object)"Data was corrupt -- asking server for a resend");
                Information resend = new Information();
                resend.addInfo("responseType", "resend");
                this.send(resend);
                log.debug((Object)"Send request for a resend to server");
                return;
            }
            this.checkClicks = true;
            clickThread.start();
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                public void run() {
                    ++WebCampaignGUI.this.time;
                    --WebCampaignGUI.this.timeLeft;
                    WebCampaignGUI.this.timeElapsedLabel.setText("Time (Seconds) Elapsed: " + WebCampaignGUI.this.time);
                    WebCampaignGUI.this.timeLeftLabel.setText("Time (Seconds) Remaining: " + WebCampaignGUI.this.timeLeft);
                    if (WebCampaignGUI.this.timeLeft == 0L) {
                        WebCampaignGUI.this.sendResponse(true);
                    }
                }
            };
            this.timer.schedule(task, 1000L, 1000L);
            this.submitButton.setEnabled(true);
            this.createBrowserButton.setEnabled(true);
            this.repaint();
            log.debug((Object)"Finished processing WebCampaign asynchronous message");
        }
        catch (Exception e) {
            log.error((Object)"Error when responding to a server message", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void testingProcedures() {
    }

    public void reauthenticate() {
        Information resend = new Information();
        resend.addInfo("responseType", "resend");
        this.send(resend);
    }
}

