/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;

public class OfferConfirmDialog
extends JDialog {
    private static final String timeMsg = "Time left to react: ";
    private long timeLeft = 15000L;
    private Timer timer;
    private int decision;
    private JButton acceptButton;
    private JLabel offerPromptLabel;
    private JButton rejectButton;
    private JLabel timeLabel;

    public OfferConfirmDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.timer = new Timer(1000, new SimpleTimerListener());
        this.timer.start();
    }

    private void initComponents() {
        this.timeLabel = new JLabel();
        this.offerPromptLabel = new JLabel();
        this.acceptButton = new JButton();
        this.rejectButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.timeLabel.setFont(new Font("Tahoma", 1, 12));
        this.timeLabel.setHorizontalAlignment(4);
        this.timeLabel.setText(timeMsg);
        this.timeLabel.setHorizontalTextPosition(4);
        this.offerPromptLabel.setFont(new Font("Tahoma", 1, 18));
        this.offerPromptLabel.setHorizontalAlignment(0);
        this.offerPromptLabel.setText("Offer received");
        this.offerPromptLabel.setHorizontalTextPosition(0);
        this.acceptButton.setFont(new Font("Tahoma", 1, 14));
        this.acceptButton.setText("Accept");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OfferConfirmDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        this.rejectButton.setFont(new Font("Tahoma", 1, 14));
        this.rejectButton.setText("Reject");
        this.rejectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OfferConfirmDialog.this.rejectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.timeLabel, -1, 369, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.offerPromptLabel, -1, 369, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.acceptButton).addGap(36, 36, 36).addComponent(this.rejectButton).addGap(113, 113, 113)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.timeLabel, -2, 24, -2).addGap(18, 18, 18).addComponent(this.offerPromptLabel, -2, 110, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acceptButton).addComponent(this.rejectButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.acceptOffer();
        this.cleanup();
    }

    private void rejectButtonActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.rejectOffer();
        this.cleanup();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                OfferConfirmDialog dialog = new OfferConfirmDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void timeUpdated() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (OfferConfirmDialog.this.timeLeft > 0L) {
                    OfferConfirmDialog.this.updateTimeDisplay((int)OfferConfirmDialog.this.timeLeft / 1000, true);
                } else {
                    OfferConfirmDialog.this.updateTimeDisplay((int)OfferConfirmDialog.this.timeLeft / 1000, false);
                }
            }
        });
    }

    private void updateTimeDisplay(int timeLeft, boolean warning) {
        if (timeLeft > 10 || !warning) {
            this.timeLabel.setText(timeMsg + timeLeft + " sec");
        } else {
            this.timeLabel.setText("<html>Time left to react:  <font color=\"red\"><b>" + timeLeft + "</b></font> sec</html>");
        }
    }

    protected void rejectOffer() {
        this.decision = 1;
    }

    private void acceptOffer() {
        this.decision = 0;
    }

    protected void cleanup() {
        this.setVisible(false);
        this.dispose();
    }

    private class SimpleTimerListener
    implements ActionListener {
        private SimpleTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OfferConfirmDialog.this.timeLeft = OfferConfirmDialog.this.timeLeft - 1000L;
            if (OfferConfirmDialog.this.timeLeft <= 0L) {
                OfferConfirmDialog.this.timer.stop();
                OfferConfirmDialog.this.rejectOffer();
                OfferConfirmDialog.this.cleanup();
            }
            OfferConfirmDialog.this.timeUpdated();
        }
    }
}

