/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.client.interfaces.QuestionDialog;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.data.Question;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InformationGUI
extends ClientGUI {
    private Vector questions;
    private Timer timer;
    private int time;
    private int tbTime;
    private static int NO_FEEDBACK = 0;
    private static int YES_FEEDBACK = 1;
    private static int WTP_FEEDBACK = 2;
    private static int FIXED_CHOICE_FEEDBACK = 3;
    private static int ABSOLUTE_PREDICTION = 0;
    private static int RELATIVE_PREDICTION = 1;
    private static int ABSOLUTE_FEEDBACK = 0;
    private static int RELATIVE_FEEDBACK = 1;
    private static int PROB_PREDICTION = 0;
    private static int BINARY_PREDICTION = 1;
    private static int PS_SEQUENCE = 0;
    private static int SP_SEQUENCE = 1;
    private static int YES_FREE_INFO = 0;
    private static int NO_FREE_INFO = 1;
    private static int CHOOSE_FREE_INFO = 2;
    private static int TASK_REQUEST = 0;
    private static int PREDICTION_REQUEST = 1;
    private static int FEEDBACK_PURCHASE_REQUEST = 2;
    private static int FREE_INFO_REQUEST = 3;
    private JPanel questionPanel;
    private JPanel answerPanel;
    private JPanel buttonPanel;
    private JLabel questionLabel;
    private JLabel timeLabel;
    private JButton submitButton;
    private JButton acceptButton;
    private JButton submitOfferButton;
    private JRadioButton[] activeButtons;
    public static Logger log = Logger.getLogger(InformationGUI.class);

    protected void constructLayout(Information info, ClientData clientData) {
        this.setTitle("Experiment Client " + clientData.getId());
        int type = info.getIntInfo("type");
        if (type == TASK_REQUEST) {
            this.questions = (Vector)info.getInfo("questions");
            Question tieBreaker = (Question)info.getInfo("tieBreaker");
            int time = info.getIntInfo("time");
            int tieBreakerTime = info.getIntInfo("tieBreakerTime");
            Runnable doUpdate = new Runnable(){

                public void run() {
                    InformationGUI.this.getContentPane().removeAll();
                }
            };
            try {
                SwingUtilities.invokeAndWait(doUpdate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            QuestionDialog qd = new QuestionDialog(this, true, false, time){

                protected void initSpecifics() {
                    this.getContentPane().remove(this.getSubmitPanel());
                }

                protected String getCloseError() {
                    return "Please wait for the time to expire.";
                }
            };
            qd.addQuestions(this.questions);
            qd.display();
            Vector answers = qd.getQuestions();
            this.addInfo("answers", answers);
            QuestionDialog tieQd = new QuestionDialog(this, true, false, tieBreakerTime);
            tieQd.setPreferredSize(this.relativeSize(0.6f, 0.6f));
            tieQd.addQuestion(tieBreaker);
            this.tbTime = 0;
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                public void run() {
                    InformationGUI.this.tbTime++;
                }
            };
            timer.schedule(task, 1000L, 1000L);
            tieQd.display();
            timer.cancel();
            Vector tieBreakAnswer = tieQd.getQuestions();
            this.addInfo("tbAnswer", tieBreakAnswer.get(0));
            this.addIntInfo("tbTime", this.tbTime);
            this.makeMove();
        } else if (type == PREDICTION_REQUEST) {
            int predictionType = info.getIntInfo("predictionType");
            int predictionMethod = info.getIntInfo("predictionMethod");
            int threshold = info.getIntInfo("threshold");
            boolean revisionStage = info.getBooleanInfo("revisionStage");
            boolean receivedFeedback = info.getBooleanInfo("receivedFeedback");
            int feedbackMethod = info.getIntInfo("feedbackMethod");
            String feedback = null;
            if (receivedFeedback) {
                feedback = info.getStringInfo("feedback");
            }
            if (predictionMethod == BINARY_PREDICTION) {
                String positiveChoice = info.getStringInfo("positiveChoice");
                String negativeChoice = info.getStringInfo("negativeChoice");
                float choicePayoff = info.getFloatInfo("choicePayoff");
                if (!revisionStage || receivedFeedback) {
                    this.constructPredictionLayout(predictionType, predictionMethod, threshold, choicePayoff, positiveChoice, negativeChoice, feedback, clientData);
                } else if (feedbackMethod == WTP_FEEDBACK) {
                    JOptionPane.showMessageDialog(null, "<html><center>This period's price was greater than your max price.<br>You will not receive a signal this period</center></html>");
                    this.makeMove();
                } else if (feedbackMethod != NO_FEEDBACK) {
                    JOptionPane.showMessageDialog(null, "You did not receive any feedback for this period");
                    this.makeMove();
                } else {
                    this.makeMove();
                }
            } else if (!revisionStage || receivedFeedback) {
                this.constructPredictionLayout(predictionType, predictionMethod, threshold, feedback, clientData);
            } else if (feedbackMethod == WTP_FEEDBACK) {
                JOptionPane.showMessageDialog(null, "<html><center>This period's price was greater than your max price.<br>You will not receive a signal this period.</center></html>");
                this.makeMove();
            } else if (feedbackMethod != NO_FEEDBACK) {
                JOptionPane.showMessageDialog(null, "You did not receive any feedback for this period");
                this.makeMove();
            } else {
                this.makeMove();
            }
        } else if (type == FEEDBACK_PURCHASE_REQUEST) {
            int feedbackMethod = info.getIntInfo("feedbackMethod");
            int numSignals = info.getIntInfo("numSignals");
            if (feedbackMethod == FIXED_CHOICE_FEEDBACK) {
                int price = info.getIntInfo("priceChoiceFeedback");
                this.constructFixedChoiceFeedbackLayout(numSignals, price, clientData);
            }
            if (feedbackMethod == WTP_FEEDBACK) {
                int maxPrice = info.getIntInfo("maxFeedbackPrice");
                this.constructWTPFeedbackLayout(numSignals, maxPrice, clientData);
            }
        } else if (type == FREE_INFO_REQUEST) {
            int feedbackType = info.getIntInfo("feedbackType");
            int threshold = info.getIntInfo("threshold");
            String actual = info.getStringInfo("actual");
            this.constructFreeInfoLayout(feedbackType, threshold, actual, clientData);
        }
    }

    private void constructFreeInfoLayout(int feedbackType, int threshold, String actual, ClientData clientData) {
        final int ft = feedbackType;
        final int thresh = threshold;
        final String ac = actual;
        final ClientData cdata = clientData;
        Runnable doUpdate = new Runnable(){

            public void run() {
                InformationGUI.this.getContentPane().removeAll();
                InformationGUI.this.getContentPane().setLayout(new BoxLayout(InformationGUI.this.getContentPane(), 1));
                JPanel titlePanel = InformationGUI.this.getTitlePanel(cdata);
                InformationGUI.this.getContentPane().add(titlePanel);
                final JLabel instLabel = new JLabel();
                JPanel instPanel = new JPanel();
                if (ft == RELATIVE_FEEDBACK) {
                    instLabel.setText("<html><center>You have the option of learning whether you were actually in the top " + thresh + "% or bottom " + (100 - thresh) + "% at no cost<br>(but you cannot revise your estimates).</center></html>");
                } else if (ft == ABSOLUTE_FEEDBACK) {
                    instLabel.setText("<html><center>You have the option of learning whether or not you actually answered at least " + thresh + " questions correctly<br>(but you cannot revise your estimates).</center></html>");
                }
                instPanel.add(instLabel);
                InformationGUI.this.getContentPane().add(instPanel);
                JPanel yesPanel = new JPanel();
                final JButton yesButton = new JButton("Show my performance");
                final JButton noButton = new JButton("Directly proceed to the next round");
                yesButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        instLabel.setText("Please Wait");
                        InformationGUI.this.addBooleanInfo("receivedInfo", true);
                        yesButton.setEnabled(false);
                        noButton.setEnabled(false);
                        JOptionPane.showMessageDialog(null, "Your True Performance: " + ac, "Your Performance", 1);
                        InformationGUI.this.makeMove();
                    }
                });
                yesPanel.add(yesButton);
                InformationGUI.this.getContentPane().add(yesPanel);
                JPanel noPanel = new JPanel();
                noButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        instLabel.setText("Please Wait");
                        noButton.setEnabled(false);
                        yesButton.setEnabled(false);
                        InformationGUI.this.addBooleanInfo("receivedInfo", false);
                        InformationGUI.this.makeMove();
                    }
                });
                noPanel.add(noButton);
                InformationGUI.this.getContentPane().add(noPanel);
                InformationGUI.this.minPack();
                InformationGUI.this.centerOnScreen();
                InformationGUI.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void constructPredictionLayout(int predictionType, int predictionMethod, int threshold, String feedback, ClientData clientData) {
        final String fb = feedback;
        final int thresh = threshold;
        final int ptype = predictionType;
        final ClientData cdata = clientData;
        final int pmeth = predictionMethod;
        Runnable doUpdate = new Runnable(){

            public void run() {
                InformationGUI.this.getContentPane().removeAll();
                InformationGUI.this.getContentPane().setLayout(new BoxLayout(InformationGUI.this.getContentPane(), 1));
                JPanel titlePanel = InformationGUI.this.getTitlePanel(cdata);
                InformationGUI.this.getContentPane().add(titlePanel);
                boolean secondTime = false;
                if (fb != null) {
                    secondTime = true;
                }
                final ProbPanel probPanel = InformationGUI.this.getProbVectorPanel(ptype, pmeth, thresh, 0.0f, secondTime);
                InformationGUI.this.getContentPane().add(probPanel);
                JPanel posPanel = new JPanel();
                final JButton posButton = new JButton("Submit");
                posPanel.add(posButton);
                posButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (probPanel.validateFields()) {
                            posButton.setEnabled(false);
                            InformationGUI.this.addIntInfo("probAffirmative", probPanel.getPositive());
                            InformationGUI.this.makeMove();
                        }
                    }
                });
                InformationGUI.this.getContentPane().add(posPanel);
                InformationGUI.this.minPack();
                InformationGUI.this.centerOnScreen();
                InformationGUI.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void constructPredictionLayout(int predictionType, int predictionMethod, int threshold, float choicePayoff, String positiveChoice, String negativeChoice, String feedback, ClientData clientData) {
        final String positive = positiveChoice;
        final String negative = negativeChoice;
        final String fb = feedback;
        final int thresh = threshold;
        final int ptype = predictionType;
        final int pmeth = predictionMethod;
        final ClientData cdata = clientData;
        final float cp = choicePayoff;
        Runnable doUpdate = new Runnable(){

            public void run() {
                InformationGUI.this.getContentPane().removeAll();
                InformationGUI.this.getContentPane().setLayout(new BoxLayout(InformationGUI.this.getContentPane(), 1));
                JPanel titlePanel = InformationGUI.this.getTitlePanel(cdata);
                InformationGUI.this.getContentPane().add(titlePanel);
                boolean secondTime = false;
                if (fb != null) {
                    secondTime = true;
                }
                final ProbPanel probPanel = InformationGUI.this.getProbVectorPanel(ptype, pmeth, thresh, cp, secondTime);
                InformationGUI.this.getContentPane().add(probPanel);
                JPanel posPanel = new JPanel();
                final JButton posButton = new JButton(positive);
                posPanel.add(posButton);
                JPanel negPanel = new JPanel();
                final JButton negButton = new JButton(negative);
                negPanel.add(negButton);
                posButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (probPanel.validateFields()) {
                            posButton.setEnabled(false);
                            negButton.setEnabled(false);
                            InformationGUI.this.addIntInfo("probAffirmative", probPanel.getPositive());
                            InformationGUI.this.addIntInfo("choice", 0);
                            InformationGUI.this.makeMove();
                        }
                    }
                });
                InformationGUI.this.getContentPane().add(posPanel);
                negButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (probPanel.validateFields()) {
                            posButton.setEnabled(false);
                            negButton.setEnabled(false);
                            InformationGUI.this.addIntInfo("probAffirmative", probPanel.getPositive());
                            InformationGUI.this.addIntInfo("choice", 1);
                            InformationGUI.this.makeMove();
                        }
                    }
                });
                InformationGUI.this.getContentPane().add(negPanel);
                InformationGUI.this.minPack();
                InformationGUI.this.centerOnScreen();
                InformationGUI.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private JPanel getTitlePanel(ClientData clientData) {
        String name = clientData.getName();
        String subjId = "(Subject ID: " + clientData.getId() + ")";
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(name + " " + subjId);
        titleLabel.setFont(new Font("Arial", 1, 18));
        titlePanel.add(titleLabel);
        return titlePanel;
    }

    private int checkSplit(String value) {
        int intValue = Integer.parseInt(value);
        if (intValue > 100 || intValue < 0) {
            return -1;
        }
        return intValue;
    }

    private void AmountKeyTyped(KeyEvent evt, JTextField positive, JTextField negative) {
        try {
            String value = positive.getText();
            int intValue = this.checkSplit(value);
            int partnerValue = 0;
            if (intValue < 0) {
                throw new Exception();
            }
            partnerValue = 100 - intValue;
            negative.setText("" + partnerValue);
        }
        catch (Exception e) {
            negative.setText("N/A");
        }
    }

    private ProbPanel getProbVectorPanel(int predictionType, int predictionMethod, int threshold, float choicePayoff, boolean secondTime) {
        final JTextField positive = new JTextField(5);
        positive.setFont(new Font("Arial", 1, 16));
        final JTextField negative = new JTextField(5);
        negative.setFont(new Font("Arial", 1, 16));
        positive.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                InformationGUI.this.AmountKeyTyped(evt, positive, negative);
            }
        });
        negative.setEditable(false);
        ProbPanel probPanel = new ProbPanel(positive, negative);
        probPanel.setLayout(new BoxLayout(probPanel, 1));
        JPanel instPanel = new JPanel();
        JLabel instLabel = new JLabel();
        if (secondTime) {
            instLabel.setText("Please enter your estimates again:");
        } else if (predictionMethod == PROB_PREDICTION) {
            instLabel.setText("How well do you think you did? Please enter your estimates below:");
        } else {
            instLabel.setText("<html><center>How well do you think you did? Please enter your estimates below and choose one option.<br><br><font color=red>If your choice is accurate, you get " + choicePayoff + " points, 0 otherwise.</font></center></html>");
        }
        instLabel.setForeground(Color.black);
        instPanel.add(instLabel);
        probPanel.add(instPanel);
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new GridLayout(3, 2));
        JPanel p11 = new JPanel();
        JLabel l11 = new JLabel("<html><b><font color=#003366>Statement</b></font></html>");
        p11.add(l11);
        entryPanel.add(p11);
        JPanel p12 = new JPanel();
        JLabel l12 = new JLabel("<html><b><font color=#003366>Percent Chance</b></font></html>");
        p12.add(l12);
        entryPanel.add(p12);
        JPanel p21 = new JPanel();
        JLabel l21 = new JLabel();
        if (predictionType == RELATIVE_PREDICTION) {
            l21.setText("I am in the TOP " + threshold + " percent of the distribution");
        } else if (predictionType == ABSOLUTE_PREDICTION) {
            l21.setText("I answered " + threshold + " questions correctly");
        }
        l21.setForeground(Color.black);
        p21.add(l21);
        entryPanel.add(p21);
        JPanel p22 = new JPanel();
        p22.add(positive);
        entryPanel.add(p22);
        JPanel p31 = new JPanel();
        JLabel l31 = new JLabel();
        if (predictionType == RELATIVE_PREDICTION) {
            l31.setText("I am in the BOTTOM " + (100 - threshold) + " percent of the distribution");
        } else if (predictionType == ABSOLUTE_PREDICTION) {
            l31.setText("I answered less than " + threshold + " questions correctly");
        }
        l31.setForeground(Color.black);
        p31.add(l31);
        entryPanel.add(p31);
        JPanel p33 = new JPanel();
        p33.add(negative);
        entryPanel.add(p33);
        probPanel.add(entryPanel);
        return probPanel;
    }

    private void constructFixedChoiceFeedbackLayout(int numSignals, int price, ClientData clientData) {
        final int ns = numSignals;
        final int p = price;
        final String name = clientData.getName();
        final String subjId = "(Subject ID: " + clientData.getId() + ")";
        Runnable doUpdate = new Runnable(){

            public void run() {
                InformationGUI.this.getContentPane().removeAll();
                InformationGUI.this.getContentPane().setLayout(new BoxLayout(InformationGUI.this.getContentPane(), 1));
                JPanel titlePanel = new JPanel();
                JLabel titleLabel = new JLabel(name + " " + subjId);
                titleLabel.setFont(new Font("Arial", 1, 18));
                titlePanel.add(titleLabel);
                InformationGUI.this.getContentPane().add(titlePanel);
                JPanel instPanel = new JPanel();
                final JLabel instLabel = new JLabel();
                if (ns == 1) {
                    instLabel.setText("<html><center>You have the option of seeing a signal about your performance from an information source,<br>at a cost of " + p + " points.<br><br>Please decide if you would like to buy a signal:</center></html>");
                }
                if (ns == 2) {
                    instLabel.setText("<html><center>You have the option of seeing a signal about your performance from one of two information sources,<br>at a cost of " + p + " points.<br><br>Please select which information source, if any, you would like to buy a signal from:</center></html>");
                }
                instLabel.setForeground(Color.black);
                instPanel.add(instLabel);
                InformationGUI.this.getContentPane().add(instPanel);
                JPanel panel1 = new JPanel();
                final JButton signalOne = new JButton();
                if (ns == 1) {
                    signalOne.setText("Receive a signal");
                } else {
                    signalOne.setText("Receive a signal from Source 1");
                }
                panel1.add(signalOne);
                InformationGUI.this.getContentPane().add(panel1);
                JPanel panel2 = new JPanel();
                final JButton signalTwo = new JButton();
                signalTwo.setText("Receive a signal from Source 2");
                panel2.add(signalTwo);
                if (ns == 2) {
                    InformationGUI.this.getContentPane().add(panel2);
                }
                JPanel panel3 = new JPanel();
                final JButton noSignal = new JButton();
                noSignal.setText("No Signal");
                panel3.add(noSignal);
                InformationGUI.this.getContentPane().add(panel3);
                signalOne.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        signalOne.setEnabled(false);
                        signalTwo.setEnabled(false);
                        noSignal.setEnabled(false);
                        instLabel.setText("Please Wait");
                        InformationGUI.this.addIntInfo("signalChosen", 1);
                        InformationGUI.this.makeMove();
                    }
                });
                signalTwo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        signalOne.setEnabled(false);
                        signalTwo.setEnabled(false);
                        noSignal.setEnabled(false);
                        instLabel.setText("Please Wait");
                        InformationGUI.this.addIntInfo("signalChosen", 2);
                        InformationGUI.this.makeMove();
                    }
                });
                noSignal.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        signalOne.setEnabled(false);
                        signalTwo.setEnabled(false);
                        noSignal.setEnabled(false);
                        instLabel.setText("Please Wait");
                        InformationGUI.this.addIntInfo("signalChosen", -1);
                        InformationGUI.this.makeMove();
                    }
                });
                InformationGUI.this.minPack();
                InformationGUI.this.centerOnScreen();
                InformationGUI.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void constructWTPFeedbackLayout(int numSignals, int maxPrice, ClientData clientData) {
        final int ns = numSignals;
        int mp = maxPrice;
        final String name = clientData.getName();
        final String subjId = "(Subject ID: " + clientData.getId() + ")";
        Runnable doUpdate = new Runnable(){

            public void run() {
                InformationGUI.this.getContentPane().removeAll();
                InformationGUI.this.getContentPane().setLayout(new BoxLayout(InformationGUI.this.getContentPane(), 1));
                JPanel titlePanel = new JPanel();
                JLabel titleLabel = new JLabel(name + " " + subjId);
                titleLabel.setFont(new Font("Arial", 1, 18));
                titlePanel.add(titleLabel);
                InformationGUI.this.getContentPane().add(titlePanel);
                JPanel instPanel = new JPanel();
                final JLabel instLabel = new JLabel();
                if (ns == 1) {
                    instLabel.setText("<html><center>Please enter the maximum amount you are willing to pay<br>for a signal from the information source:</center></html>");
                }
                if (ns == 2) {
                    instLabel.setText("<html><center>Please enter the maximum amount you are willing to pay for a signal from each information source:</center></html>");
                }
                instLabel.setForeground(Color.black);
                instPanel.add(instLabel);
                InformationGUI.this.getContentPane().add(instPanel);
                final JTextField singleSignalText = new JTextField(5);
                final JTextField signalOneText = new JTextField(5);
                final JTextField signalTwoText = new JTextField(5);
                JPanel wtpPanel = new JPanel();
                if (ns == 1) {
                    wtpPanel.setLayout(new GridLayout(1, 2));
                    JPanel panel = new JPanel();
                    JLabel label = new JLabel("Enter Amount:");
                    panel.add(label);
                    JPanel textPanel = new JPanel();
                    textPanel.add(singleSignalText);
                    wtpPanel.add(panel);
                    wtpPanel.add(textPanel);
                }
                if (ns == 2) {
                    wtpPanel.setLayout(new GridLayout(2, 2));
                    JPanel panel1 = new JPanel();
                    JLabel label1 = new JLabel("First Information Source:");
                    panel1.add(label1);
                    JPanel textPanel1 = new JPanel();
                    textPanel1.add(signalOneText);
                    JPanel panel2 = new JPanel();
                    JLabel label2 = new JLabel("Second Information Source:");
                    panel2.add(label2);
                    JPanel textPanel2 = new JPanel();
                    textPanel2.add(signalTwoText);
                    wtpPanel.add(panel1);
                    wtpPanel.add(textPanel1);
                    wtpPanel.add(panel2);
                    wtpPanel.add(textPanel2);
                }
                InformationGUI.this.getContentPane().add(wtpPanel);
                JPanel submitPanel = new JPanel();
                final JButton submitButton = new JButton("Submit");
                submitButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (ns == 1) {
                            String txt = singleSignalText.getText();
                            try {
                                if (txt == null || txt.length() < 1) {
                                    throw new Exception();
                                }
                                int wtp = Integer.parseInt(txt);
                                InformationGUI.this.addIntInfo("wtp-1", wtp);
                                InformationGUI.this.makeMove();
                                submitButton.setEnabled(false);
                                singleSignalText.setEnabled(false);
                                instLabel.setText("Please Wait");
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, "You must enter a willing to pay price.", "Incomplete", 0);
                                return;
                            }
                        }
                        if (ns == 2) {
                            String txt1 = signalOneText.getText();
                            String txt2 = signalTwoText.getText();
                            try {
                                if (txt1 == null || txt2 == null || txt1.length() < 1 || txt2.length() < 1) {
                                    throw new Exception();
                                }
                                int wtp1 = Integer.parseInt(txt1);
                                int wtp2 = Integer.parseInt(txt2);
                                InformationGUI.this.addIntInfo("wtp-1", wtp1);
                                InformationGUI.this.addIntInfo("wtp-2", wtp2);
                                InformationGUI.this.makeMove();
                                submitButton.setEnabled(false);
                                signalOneText.setEnabled(false);
                                signalTwoText.setEnabled(false);
                                instLabel.setText("Please Wait");
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(null, "You must enter a valid integer for each willing to pay price.", "Incomplete", 0);
                                return;
                            }
                        }
                    }
                });
                submitPanel.add(submitButton);
                InformationGUI.this.getContentPane().add(submitPanel);
                InformationGUI.this.minPack();
                InformationGUI.this.centerOnScreen();
                InformationGUI.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void initialize() {
    }

    public void close() {
    }

    public void reauthenticate() {
    }

    public void respond(Object obj) {
    }

    public void testingProcedures() {
    }

    protected void constructWaitingLayout(Information info) {
    }

    class ProbPanel
    extends JPanel {
        private JTextField positiveField;
        private JTextField negativeField;

        public ProbPanel(JTextField positiveField, JTextField negativeField) {
            this.positiveField = positiveField;
            this.negativeField = negativeField;
        }

        public boolean validateFields() {
            try {
                int positive = Integer.parseInt(this.positiveField.getText());
                int negative = Integer.parseInt(this.negativeField.getText());
                if (positive < 0 || negative < 0) {
                    JOptionPane.showMessageDialog(this, "Both percentages must be positive", "Negative Error", 0);
                    return false;
                }
                if (positive + negative != 100) {
                    JOptionPane.showMessageDialog(this, "The percentages must add to 100", "Summation Error", 0);
                    return false;
                }
                this.positiveField.setEnabled(false);
                this.negativeField.setEnabled(false);
                return true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "You must enter a valid number for each probability field", "Invalid", 0);
                return false;
            }
        }

        public int getPositive() {
            return Integer.parseInt(this.positiveField.getText());
        }

        public int getNegative() {
            return Integer.parseInt(this.negativeField.getText());
        }
    }
}

