/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class DictatorGUI
extends ClientGUI {
    private JPanel TitlePanel;
    private JLabel DictatorLabel;
    private JPanel ChoicePanel;
    private JPanel HistoryPanel;
    private JTextField[] partnerTextFields;
    private JLabel selfAmount;
    private JLabel[] partnerAmounts;
    private JButton acceptButton;
    private JButton SubmitButton;
    private int maxOffer;
    private Information info;
    private static int SPLITTER_PLAYER = 0;
    private static Category log = Category.getInstance(DictatorGUI.class);

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.DictatorLabel = new JLabel();
        this.ChoicePanel = new JPanel();
        this.HistoryPanel = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DictatorGUI.this.exitForm(evt);
            }
        });
        this.DictatorLabel.setText("Dictator Game");
        this.DictatorLabel.setForeground(Color.darkGray);
        this.DictatorLabel.setFont(new Font("Dialog", 1, 18));
        this.TitlePanel.add(this.DictatorLabel);
        this.getContentPane().add(this.TitlePanel);
        this.ChoicePanel.setLayout(new BoxLayout(this.ChoicePanel, 1));
        this.getContentPane().add(this.ChoicePanel);
        this.HistoryPanel.setLayout(new GridLayout(1, 2));
        this.getContentPane().add(this.HistoryPanel);
        this.pack();
    }

    private void exitForm(WindowEvent evt) {
        this.exit();
    }

    public static void main(String[] args) {
        new DictatorGUI().setVisible(true);
    }

    public void initPanels() {
        this.getContentPane().remove(this.HistoryPanel);
        this.getContentPane().add(this.clientHistory);
        this.getContentPane().add(this.clientMessages);
        this.ChoicePanel.add(this.clientStatus);
        this.clientHistory.setPreferredSize(new Dimension(500, 320));
        this.clientHistory.setMinimumSize(new Dimension(500, 320));
        this.pack();
    }

    public void initialize() {
        this.initComponents();
        this.initPanels();
        this.centerOnScreen();
        this.setVisible(true);
    }

    protected void constructLayout(Information info, ClientData clientData) {
        try {
            this.info = info;
            final ClientData cdata = clientData;
            final ClientData splitterData = null;
            final Vector pdata = null;
            this.maxOffer = (Integer)info.getInfo("maxOffer");
            Runnable doUpdate = new Runnable(){

                public void run() {
                    DictatorGUI.this.ChoicePanel.removeAll();
                    DictatorGUI.this.DictatorLabel.setText(DictatorGUI.this.parseString(cdata.getName() + " (Subject ID: %id%)"));
                    DictatorGUI.this.setTitle(DictatorGUI.this.parseString("Subject ID: %id%"));
                    if (DictatorGUI.this.partnerNum == SPLITTER_PLAYER) {
                        DictatorGUI.this.constructSplitterLayout(pdata);
                    } else {
                        DictatorGUI.this.constructAcceptorLayout(splitterData);
                    }
                    DictatorGUI.this.pack();
                    DictatorGUI.this.centerOnScreen();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to construct the Dictator layout for partner " + this.partnerNum + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    private void constructSplitterLayout(Vector partnerData) {
        int partner;
        this.ChoicePanel.setLayout(new GridLayout(5, 1));
        JLabel instructions = new JLabel();
        instructions.setHorizontalAlignment(0);
        instructions.setForeground(Color.black);
        instructions.setFont(new Font("Dialog", 1, 16));
        instructions.setText("Enter your proposal to split " + this.maxOffer);
        this.ChoicePanel.add(instructions);
        JLabel instructionLabel = new JLabel("Amount you wish to give to each of your partners");
        instructionLabel.setFont(new Font("Arial Black", 0, 15));
        instructionLabel.setForeground(Color.black);
        instructionLabel.setHorizontalAlignment(0);
        this.ChoicePanel.add(instructionLabel);
        JPanel textEntryPanel = new JPanel();
        textEntryPanel.setLayout(new GridLayout(2, this.groupSize, 4, 2));
        textEntryPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.partnerTextFields = new JTextField[this.groupSize - 1];
        for (partner = 0; partner < this.groupSize - 1; ++partner) {
            this.partnerTextFields[partner] = new JTextField();
            this.partnerTextFields[partner].addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    DictatorGUI.this.AmountKeyTyped(evt);
                }
            });
            this.partnerTextFields[partner].setPreferredSize(new Dimension(50, 20));
            textEntryPanel.add(this.partnerTextFields[partner]);
        }
        for (partner = 0; partner < this.groupSize - 1; ++partner) {
            JLabel partnerLabel = new JLabel(" Subject " + (((ClientData)partnerData.get(partner)).getId() + 1) + " ");
            partnerLabel.setForeground(Color.black);
            partnerLabel.setFont(new Font("Arial Black", 0, 13));
            partnerLabel.setHorizontalAlignment(0);
            textEntryPanel.add(partnerLabel);
        }
        JScrollPane textEntryScrollPane = new JScrollPane(textEntryPanel);
        textEntryScrollPane.setVerticalScrollBarPolicy(21);
        JPanel centerPanel = new JPanel();
        centerPanel.add(textEntryScrollPane);
        this.ChoicePanel.add(centerPanel);
        JPanel amountsPanel = new JPanel();
        amountsPanel.setLayout(new GridLayout(1, 2));
        JLabel selfAmountLabel = new JLabel("Your Amount: ");
        selfAmountLabel.setForeground(Color.black);
        selfAmountLabel.setFont(new Font("Arial Black", 0, 13));
        selfAmountLabel.setHorizontalAlignment(4);
        amountsPanel.add(selfAmountLabel);
        this.selfAmount = new JLabel("0");
        this.selfAmount.setFont(new Font("Arial Black", 0, 15));
        this.selfAmount.setForeground(Color.blue);
        this.selfAmount.setHorizontalAlignment(2);
        amountsPanel.add(this.selfAmount);
        this.ChoicePanel.add(amountsPanel);
        JPanel buttonPanel = new JPanel();
        this.SubmitButton = new JButton("Submit");
        this.SubmitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DictatorGUI.this.splitSubmitAction(evt);
            }
        });
        buttonPanel.add(this.SubmitButton);
        this.ChoicePanel.add(buttonPanel);
    }

    private void constructAcceptorLayout(ClientData splitterData) {
        this.ChoicePanel.setLayout(new GridLayout(3, 1));
        JPanel labelHolder = new JPanel();
        JLabel instructions = new JLabel("Your dictator (Subject " + (splitterData.getId() + 1) + ") split " + this.maxOffer + ".");
        instructions.setForeground(Color.black);
        instructions.setFont(new Font("Dialog", 1, 17));
        instructions.setHorizontalAlignment(0);
        labelHolder.add(instructions);
        this.ChoicePanel.add(labelHolder);
        JPanel buttonPanel = new JPanel();
        this.acceptButton = new JButton("OK");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DictatorGUI.this.AcceptAction(evt);
            }
        });
        buttonPanel.add(this.acceptButton);
        this.ChoicePanel.add(buttonPanel);
    }

    private void AcceptAction(ActionEvent evt) {
        this.addInfo("move", new Integer(1));
        this.makeMove();
        this.acceptButton.setEnabled(false);
    }

    protected void constructWaitingLayout(Information info) {
        Runnable doUpdate = new Runnable(){

            public void run() {
                DictatorGUI.this.ChoicePanel.removeAll();
                DictatorGUI.this.ChoicePanel.setLayout(new FlowLayout());
                DictatorGUI.this.ChoicePanel.add(DictatorGUI.this.clientStatus);
                DictatorGUI.this.pack();
                DictatorGUI.this.centerOnScreen();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void splitSubmitAction(ActionEvent evt) {
        try {
            int sum = this.getSum();
            if (this.dataIsValid() && sum <= this.maxOffer) {
                this.addInfo(new Integer(SPLITTER_PLAYER), new Integer(this.maxOffer - sum));
                for (int partner = 1; partner < this.groupSize; ++partner) {
                    this.addInfo(new Integer(partner), new Integer(this.partnerTextFields[partner - 1].getText()));
                    this.partnerTextFields[partner - 1].setEnabled(false);
                }
            } else {
                throw new Exception();
            }
            this.makeMove();
            ((JButton)evt.getSource()).setEnabled(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Please input an integer in the given range", "Invalid Number", 0);
        }
    }

    private int checkSplit(String value) {
        int intValue = Integer.parseInt(value);
        if (intValue > this.maxOffer || intValue < 0) {
            return -1;
        }
        return intValue;
    }

    private boolean dataIsValid() {
        for (int partner = 0; partner < this.groupSize - 1; ++partner) {
            if (this.checkSplit(this.partnerTextFields[partner].getText()) >= 0) continue;
            return false;
        }
        return true;
    }

    private int getSum() {
        int sum = 0;
        for (int partner = 0; partner < this.groupSize - 1; ++partner) {
            sum += Integer.parseInt(this.partnerTextFields[partner].getText());
        }
        return sum;
    }

    private void AmountKeyTyped(KeyEvent evt) {
        JTextField textField = (JTextField)evt.getSource();
        try {
            int intValue = this.checkSplit(textField.getText());
            int sum = this.getSum();
            if (intValue < 0 || sum > this.maxOffer) {
                throw new Exception();
            }
            this.selfAmount.setText("" + (this.maxOffer - sum));
        }
        catch (Exception e) {
            this.selfAmount.setText("N/A");
        }
    }

    public void testingProcedures() {
        if (this.partnerNum == SPLITTER_PLAYER) {
            this.addInfo("move", new Integer(this.rand.nextInt(this.maxOffer)));
        } else {
            this.addInfo("move", new Integer(1));
        }
    }

    public void respond(Object obj) {
    }

    public void close() {
        int i;
        EventListener[] list;
        if (this.SubmitButton != null && (list = this.SubmitButton.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.SubmitButton.removeActionListener((ActionListener)list[i]);
            }
        }
        if (this.acceptButton != null && (list = this.acceptButton.getListeners(ActionListener.class)) != null) {
            for (i = 0; i < list.length; ++i) {
                this.acceptButton.removeActionListener((ActionListener)list[i]);
            }
        }
        for (i = 0; i < this.groupSize; ++i) {
            if (this.partnerTextFields[i] == null || (list = this.partnerTextFields[i].getListeners(KeyAdapter.class)) == null) continue;
            for (int j = 0; j < list.length; ++j) {
                this.partnerTextFields[i].removeKeyListener((KeyAdapter)list[j]);
            }
        }
    }

    public void reauthenticate() {
    }
}

