/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Category;

public class CompetitionGUI
extends ClientGUI {
    private JLabel bidPromptLabel;
    private JSlider bidSlider;
    private JLabel displayLabel;
    private JPanel displayPanel;
    private JPanel imagePanel;
    private JLabel lightbulbLabel;
    private JPanel lightbulbPanel;
    private JLabel matchMetaLabel;
    private JPanel metaPanel;
    private JButton stopButton;
    private JLabel subjMetaLabel;
    private JButton submitButton;
    private JPanel submitButtonPanel;
    private JPanel submitPanel;
    private JLabel thermometerLabel;
    private JPanel thermometerPanel;
    private JProgressBar thermometerProgressBar;
    private JLabel timeLabel;
    public static Category log = Category.getInstance(CompetitionGUI.class);
    private String imgLink;
    private String metaLabelText;
    private String itemLabelText;
    private String bidPromptText;
    private String bidButtonText;
    private boolean showHistory;
    private boolean showImage;
    private int endBid;
    private int auction;
    private String type;
    private int bid;
    private boolean firstRound = true;
    private int majorTickSpacing;
    private int minorTickSpacing;
    private JLabel[] lightbulbs;
    private String roundLabelText = "Rounds Elapsed";
    private String bidLabelText = "Your Bid";
    private String biddersLabelText = "Remaining Bidders";
    private String thermometerLabelText = "Price";
    private boolean showRemaining = true;
    private boolean bidding = true;
    private int startBid;
    private int lastBid;
    private int currentLightbulbs;
    private int thermDisplayType;
    private final int LINEAR = 0;
    private final int SQRT = 1;
    private int timeLimit;
    private int timeRemaining;
    private Timer roundTimer;
    private Timer countdownTimer;
    private Action countdownAction;

    public CompetitionGUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.metaPanel = new JPanel();
        this.matchMetaLabel = new JLabel();
        this.subjMetaLabel = new JLabel();
        this.displayPanel = new JPanel();
        this.lightbulbPanel = new JPanel();
        this.lightbulbLabel = new JLabel();
        this.imagePanel = new JPanel();
        this.displayLabel = new JLabel();
        this.thermometerPanel = new JPanel();
        this.timeLabel = new JLabel();
        this.thermometerProgressBar = new JProgressBar();
        this.thermometerLabel = new JLabel();
        this.submitPanel = new JPanel();
        this.bidPromptLabel = new JLabel();
        this.bidSlider = new JSlider();
        this.submitButtonPanel = new JPanel();
        this.submitButton = new JButton();
        this.stopButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.metaPanel.setLayout(new GridBagLayout());
        this.matchMetaLabel.setFont(new Font("Tahoma", 1, 16));
        this.matchMetaLabel.setHorizontalAlignment(2);
        this.matchMetaLabel.setText("Match Information");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.metaPanel.add((Component)this.matchMetaLabel, gridBagConstraints);
        this.subjMetaLabel.setFont(new Font("Tahoma", 1, 16));
        this.subjMetaLabel.setHorizontalAlignment(4);
        this.subjMetaLabel.setText("Subject Information");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.metaPanel.add((Component)this.subjMetaLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.metaPanel, gridBagConstraints);
        this.displayPanel.setLayout(new GridBagLayout());
        this.lightbulbLabel.setText("Remaining Bidders");
        this.lightbulbPanel.add(this.lightbulbLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.displayPanel.add((Component)this.lightbulbPanel, gridBagConstraints);
        this.imagePanel.setMinimumSize(new Dimension(400, 300));
        this.imagePanel.setPreferredSize(new Dimension(400, 300));
        this.imagePanel.setLayout(new GridBagLayout());
        this.displayLabel.setHorizontalAlignment(0);
        this.displayLabel.setIcon(new ImageIcon(this.getClass().getResource("/edu/caltech/ssel/projects/multistage/client/interfaces/images/wait.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.imagePanel.add((Component)this.displayLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        this.displayPanel.add((Component)this.imagePanel, gridBagConstraints);
        this.thermometerPanel.setLayout(new GridBagLayout());
        this.timeLabel.setFont(new Font("Tahoma", 0, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.thermometerPanel.add((Component)this.timeLabel, gridBagConstraints);
        this.thermometerProgressBar.setForeground(new Color(255, 96, 96));
        this.thermometerProgressBar.setOrientation(1);
        this.thermometerProgressBar.setString("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        this.thermometerPanel.add((Component)this.thermometerProgressBar, gridBagConstraints);
        this.thermometerLabel.setFont(new Font("Tahoma", 0, 14));
        this.thermometerLabel.setText("Price");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.thermometerPanel.add((Component)this.thermometerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.7;
        this.displayPanel.add((Component)this.thermometerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        this.getContentPane().add((Component)this.displayPanel, gridBagConstraints);
        this.bidPromptLabel.setFont(new Font("Tahoma", 1, 14));
        this.bidPromptLabel.setHorizontalAlignment(4);
        this.bidPromptLabel.setText("Your Bid?");
        this.bidSlider.setMajorTickSpacing(10);
        this.bidSlider.setMaximum(40);
        this.bidSlider.setMinorTickSpacing(2);
        this.bidSlider.setPaintLabels(true);
        this.bidSlider.setPaintTicks(true);
        this.bidSlider.setSnapToTicks(true);
        this.bidSlider.setValue(0);
        this.bidSlider.setEnabled(false);
        this.bidSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CompetitionGUI.this.bidSliderStateChanged(evt);
            }
        });
        this.submitButton.setFont(new Font("Tahoma", 1, 12));
        this.submitButton.setText("Submit");
        this.submitButton.setEnabled(false);
        this.submitButton.setMultiClickThreshhold(250L);
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompetitionGUI.this.submitButtonActionPerformed(evt);
            }
        });
        this.submitButtonPanel.add(this.submitButton);
        this.stopButton.setFont(new Font("Tahoma", 1, 12));
        this.stopButton.setText("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.setMultiClickThreshhold(500L);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CompetitionGUI.this.stopButtonActionPerformed(evt);
            }
        });
        this.submitButtonPanel.add(this.stopButton);
        GroupLayout submitPanelLayout = new GroupLayout(this.submitPanel);
        this.submitPanel.setLayout(submitPanelLayout);
        submitPanelLayout.setHorizontalGroup(submitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitPanelLayout.createSequentialGroup().addGroup(submitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, submitPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.bidPromptLabel, -1, 431, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.submitButtonPanel, -2, 118, -2).addGap(23, 23, 23)).addGroup(submitPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bidSlider, -1, 592, Short.MAX_VALUE))).addContainerGap()));
        submitPanelLayout.setVerticalGroup(submitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bidSlider, -2, 45, -2).addGroup(submitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButtonPanel, -2, 61, -2)).addGroup(submitPanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.bidPromptLabel, -2, 28, -2))).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.getContentPane().add((Component)this.submitPanel, gridBagConstraints);
        this.pack();
    }

    private void bidSliderStateChanged(ChangeEvent evt) {
        if (this.auction != 3) {
            final int bidFinal = this.bid = this.bidSlider.getValue();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    log.debug((Object)"bidSliderStateChanged - thread started");
                    String bidPromptDisplay = CompetitionGUI.this.bidPromptText.replaceFirst("%num%", bidFinal + "");
                    CompetitionGUI.this.bidPromptLabel.setText(bidPromptDisplay);
                    log.debug((Object)"bidSliderStateChanged - thread finished");
                }
            });
        }
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        log.debug((Object)"submitButtonActionPerformed");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                log.debug((Object)"submitButtonActionPerformed - thread started");
                CompetitionGUI.this.bidSlider.setEnabled(false);
                CompetitionGUI.this.submitButton.setEnabled(false);
                CompetitionGUI.this.stopButton.setEnabled(false);
                log.debug((Object)"submitButtonActionPerformed - thread finished");
            }
        });
        this.addIntInfo("bid", this.bid);
        if (this.auction == 3) {
            this.addBooleanInfo("stillIn", true);
            this.lastBid = this.bid;
            if (this.timeLimit > 0) {
                this.roundTimer.stop();
            }
        }
        this.makeMove();
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        log.debug((Object)"stopButtonActionPerformed");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                log.debug((Object)"stopButtonActionPerformed - thread started");
                CompetitionGUI.this.bidSlider.setEnabled(false);
                CompetitionGUI.this.submitButton.setEnabled(false);
                CompetitionGUI.this.stopButton.setEnabled(false);
                log.debug((Object)"stopButtonActionPerformed - thread finished");
            }
        });
        this.bidding = false;
        this.addIntInfo("bid", this.lastBid);
        this.addBooleanInfo("stillIn", false);
        if (this.timeLimit > 0) {
            this.roundTimer.stop();
        }
        this.makeMove();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                log.debug((Object)"main - thread started");
                new CompetitionGUI().setVisible(true);
                log.debug((Object)"main - thread started");
            }
        });
    }

    public void initialize() {
        try {
            log.debug((Object)"initialize() try block started");
            log.debug((Object)"--initialize() try block: setLayout");
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            log.debug((Object)"--initialize() try block add(metaPanel)");
            this.getContentPane().add(this.metaPanel);
            log.debug((Object)"--initialize() try block add(displayPanel)");
            this.getContentPane().add(this.displayPanel);
            log.debug((Object)"--initialize() try block add(submitPanel)");
            this.getContentPane().add(this.submitPanel);
            log.debug((Object)"--initialize() try block add(clientHistory)");
            this.getContentPane().add(this.clientHistory);
            log.debug((Object)"--initialize() try block pack()");
            this.pack();
            log.debug((Object)"--initialize() try block setVisible");
            this.setVisible(true);
            log.debug((Object)"--initialize() try block centerOnScreen");
            this.centerOnScreen();
            log.debug((Object)"initialiaze() try block finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void constructLayout(Information info, ClientData clientData) {
        if (this.firstRound) {
            log.debug((Object)"constructLayout() firstRound==true start");
            this.firstRound = false;
            this.type = info.getStringInfo("type");
            this.auction = info.getIntInfo("auction");
            this.endBid = info.getIntInfo("endBid");
            this.showHistory = info.getBooleanInfo("showHistory");
            this.showImage = info.getBooleanInfo("showImage");
            this.imgLink = info.getStringInfo("imgLink");
            this.metaLabelText = info.getStringInfo("metaLabelText");
            this.itemLabelText = info.getStringInfo("itemLabelText");
            this.bidButtonText = info.getStringInfo("bidButtonText");
            this.bidPromptText = info.getStringInfo("bidPromptText");
            final int id = clientData.getId();
            if (this.auction == 3) {
                this.startBid = info.getIntInfo("startBid");
                this.bid = info.getIntInfo("bid");
                this.lastBid = this.startBid;
                this.currentLightbulbs = info.getIntInfo("remainingBidders");
                this.showRemaining = info.getBooleanInfo("showRemaining");
                this.biddersLabelText = info.getStringInfo("biddersLabelText");
                this.thermometerLabelText = info.getStringInfo("thermometerLabelText");
                this.timeLimit = 1000 * info.getIntInfo("timeLimit");
                this.lightbulbs = new JLabel[this.currentLightbulbs];
                String thermDisplay = info.getStringInfo("thermometerDisplayType");
                this.thermDisplayType = thermDisplay != null && thermDisplay.equals("squareroot") ? 1 : 0;
                if (this.timeLimit > 0) {
                    AbstractAction timeAction = this.makeTimer();
                    this.roundTimer = new Timer(this.timeLimit, timeAction);
                    this.timeRemaining = this.timeLimit;
                    this.countdownAction = this.makeCountdown();
                    this.countdownTimer = new Timer(1000, this.countdownAction);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        log.debug((Object)"constructLayout() thread constructEnglish start");
                        CompetitionGUI.this.constructEnglish(id);
                        log.debug((Object)"constructLayout() thread constructEnglish finished");
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        log.debug((Object)"constructLayout() thread constructNonEnglish start");
                        CompetitionGUI.this.constructNonEnglish(id);
                        log.debug((Object)"constructLayout() thread constructNonEnglish finish");
                    }
                });
            }
            log.debug((Object)"constructLayout() firstRound==true finished");
        } else {
            log.debug((Object)"constructLayout() runEnglishRound start");
            this.runEnglishRound(info);
            log.debug((Object)"constructLayout() runEnglishRound finished");
        }
    }

    protected void constructWaitingLayout(Information info) {
    }

    private AbstractAction makeTimer() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                log.debug((Object)"constructLayout() timeAction start");
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        log.debug((Object)"constructLayout() timeAction thread start");
                        CompetitionGUI.this.submitButton.setEnabled(false);
                        CompetitionGUI.this.stopButton.setEnabled(false);
                        CompetitionGUI.this.roundTimer.stop();
                        log.debug((Object)"constructLayout() timeAction thread finished");
                    }
                });
                log.debug((Object)"constructLayout() timeAction finished");
                CompetitionGUI.this.bidding = false;
                CompetitionGUI.this.addIntInfo("bid", CompetitionGUI.this.lastBid);
                CompetitionGUI.this.addBooleanInfo("stillIn", false);
                CompetitionGUI.this.makeMove();
            }
        };
    }

    private AbstractAction makeCountdown() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent ev) {
                if (CompetitionGUI.this.timeRemaining >= 0) {
                    CompetitionGUI.this.timeRemaining = CompetitionGUI.this.timeRemaining - 1000;
                }
                String displayTime = CompetitionGUI.this.timeRemaining / 1000 + "";
                if (CompetitionGUI.this.timeRemaining <= 5000) {
                    displayTime = "<font color = FF0000>" + displayTime + "</font>";
                }
                final String displayTimeFinal = displayTime;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        log.debug((Object)"constructLayout() countdownAction thread start");
                        CompetitionGUI.this.timeLabel.setText("<html>Time Left:<br><center>" + displayTimeFinal + "</center></br></html>");
                        log.debug((Object)"constructLayout() countdownAction thread finished");
                    }
                });
            }
        };
    }

    public void testingProcedures() {
    }

    public void respond(Object obj) {
    }

    public void close() {
    }

    public void reauthenticate() {
    }

    private void constructEnglish(int id) {
        log.debug((Object)"constructEnglish() started");
        if (!this.showHistory) {
            log.debug((Object)"constructEnglish() getContentPane().remove()");
            this.clientHistory.setVisible(false);
        }
        this.subjMetaLabel.setText("Subject: " + id);
        this.matchMetaLabel.setText(this.metaLabelText);
        this.submitButton.setText(this.bidButtonText);
        if (this.showImage) {
            this.displayLabel.setIcon(new ImageIcon(this.getClass().getResource(this.imgLink)));
        } else {
            this.displayLabel.setIcon(null);
            this.displayLabel.setText(this.imgLink);
        }
        log.debug((Object)"constructEnglish() submitButton.setEnabled");
        this.submitButton.setEnabled(true);
        this.lightbulbLabel.setText(this.biddersLabelText);
        String bidPromptDisplay = this.bidPromptText.replaceFirst("%num%", this.bid + "");
        this.bidPromptLabel.setText(bidPromptDisplay);
        this.stopButton.setEnabled(true);
        String thermometerLabelDisplay = this.thermometerLabelText.replaceFirst("%num%", this.bid + "");
        this.thermometerLabel.setText(thermometerLabelDisplay);
        this.setThermometerLevel(this.bid, this.thermDisplayType);
        this.submitPanel.remove(this.bidSlider);
        log.debug((Object)"constructEnglish() for loop");
        for (int i = 0; i < this.currentLightbulbs; ++i) {
            this.lightbulbs[i] = new JLabel();
            this.lightbulbs[i].setIcon(new ImageIcon(this.getClass().getResource("/edu/caltech/ssel/multistage/client/interfaces/images/Competition/bulbOn.png")));
            this.lightbulbPanel.add(this.lightbulbs[i]);
        }
        if (this.timeLimit > 0) {
            log.debug((Object)"constructEnglish() roundTimer.start");
            this.roundTimer.start();
            log.debug((Object)"constructEnglish() countdownTimer.start");
            this.countdownTimer.start();
        }
        if (!this.showRemaining) {
            this.lightbulbPanel.setVisible(false);
        }
        log.debug((Object)"constructEnglish() displayPanel.repaint()");
        this.displayPanel.repaint();
        log.debug((Object)"constructEnglish() minPack()");
        this.minPack();
        log.debug((Object)"constructEnglish() centerOnScreen()");
        this.centerOnScreen();
        log.debug((Object)"constructEnglish() setVisible()");
        this.setVisible(true);
    }

    private void constructNonEnglish(int id) {
        log.debug((Object)"constructNonEnglish() started");
        if (!this.showHistory) {
            log.debug((Object)"constructEnglish() getContentPane().remove()");
            this.clientHistory.setVisible(false);
        }
        this.subjMetaLabel.setText("Subject: " + id);
        this.matchMetaLabel.setText(this.metaLabelText);
        this.submitButton.setText(this.bidButtonText);
        if (this.showImage) {
            this.displayLabel.setIcon(new ImageIcon(this.getClass().getResource(this.imgLink)));
        } else {
            this.displayLabel.setIcon(null);
            this.displayLabel.setText(this.imgLink);
        }
        log.debug((Object)"constructNonEnglish() submitButton.setEnabled");
        this.submitButton.setEnabled(true);
        this.bidSlider.setMaximum(this.endBid);
        this.thermometerPanel.remove(this.timeLabel);
        String bidPromptDisplay = this.bidPromptText.replaceFirst("%num%", "0");
        this.bidPromptLabel.setText(bidPromptDisplay);
        this.bidSlider.setValue(0);
        this.bidSlider.setEnabled(true);
        this.bidSlider.setMajorTickSpacing(this.majorTickSpacing);
        this.bidSlider.setMinorTickSpacing(this.minorTickSpacing);
        this.bidSlider.setPaintLabels(this.endBid < 45);
        this.displayPanel.remove(this.thermometerPanel);
        this.displayPanel.remove(this.lightbulbPanel);
        this.submitButtonPanel.remove(this.stopButton);
        log.debug((Object)"constructNonEnglish() displayPanel.repaint()");
        this.displayPanel.repaint();
        log.debug((Object)"constructNonEnglish() minPack()");
        this.minPack();
        log.debug((Object)"constructNonEnglish() centerOnScreen()");
        this.centerOnScreen();
        log.debug((Object)"constructNonEnglish() setVisible()");
        this.setVisible(true);
    }

    private void runEnglishRound(Information info) {
        boolean postRound = info.getBooleanInfo("postRound");
        this.currentLightbulbs = info.getIntInfo("remainingBidders");
        if (postRound) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    log.debug((Object)"runEnglishround() postRound==true thread start");
                    CompetitionGUI.this.setLitLightbulbs(CompetitionGUI.this.currentLightbulbs);
                    CompetitionGUI.this.countdownTimer.stop();
                    CompetitionGUI.this.timeLabel.setText("<html>Time Left:<br><center><font color = FF0000>0</font></center></br></html>");
                    log.debug((Object)"runEnglishround() postRound==true thread finished");
                }
            });
            this.makeMove();
        } else {
            final int bidFinal = this.bid = info.getIntInfo("bid");
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    log.debug((Object)"runEnglishround() postRound==false thread start");
                    if (CompetitionGUI.this.showRemaining) {
                        CompetitionGUI.this.setLitLightbulbs(CompetitionGUI.this.currentLightbulbs);
                    }
                    CompetitionGUI.this.setThermometerLevel(bidFinal, CompetitionGUI.this.thermDisplayType);
                    String bidPromptDisplay = CompetitionGUI.this.bidPromptText.replaceFirst("%num%", bidFinal + "");
                    CompetitionGUI.this.bidPromptLabel.setText(bidPromptDisplay);
                    String thermometerLabelDisplay = CompetitionGUI.this.thermometerLabelText.replaceFirst("%num%", CompetitionGUI.this.bid + "");
                    CompetitionGUI.this.thermometerLabel.setText(thermometerLabelDisplay);
                    if (CompetitionGUI.this.bidding) {
                        CompetitionGUI.this.submitButton.setEnabled(true);
                        CompetitionGUI.this.stopButton.setEnabled(true);
                    }
                    log.debug((Object)"runEnglishround() postRound==false thread finished");
                }
            });
            if (!this.bidding) {
                this.addIntInfo("bid", this.lastBid);
                this.addBooleanInfo("stillIn", false);
                this.makeMove();
            } else if (this.timeLimit > 0) {
                log.debug((Object)"runEnglishRound() roundTimer.restart");
                this.roundTimer.start();
            }
            if (this.timeLimit > 0) {
                this.timeRemaining = this.timeLimit;
                log.debug((Object)"runEnglishRound() countdownTimer.start");
                this.countdownTimer.restart();
            }
        }
    }

    private void setThermometerLevel(int value, int displayType) {
        boolean ascending = this.startBid < this.endBid;
        double levelFloat = ascending ? (double)(value - this.startBid) / (double)(this.endBid - this.startBid) : (double)(value - this.endBid) / (double)(this.startBid - this.endBid);
        int level = displayType == 1 ? (int)(Math.sqrt(levelFloat) * 100.0) : (int)(levelFloat * 100.0);
        this.thermometerProgressBar.setValue(level);
    }

    private void setLitLightbulbs(int numLitFinal) {
        for (int i = numLitFinal; i < this.lightbulbs.length; ++i) {
            this.lightbulbs[i].setIcon(new ImageIcon(this.getClass().getResource("/edu/caltech/ssel/multistage/client/interfaces/images/Competition/bulbOff.png")));
            this.lightbulbs[i].setEnabled(false);
        }
    }
}

