/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces.gameinterfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class BankRunOldGUI
extends ClientGUI {
    private JPanel actionPanel;
    private JPanel trialPanel;
    private JPanel titlePanel;
    private JPanel infoPanel;
    private JPanel dataPanel;
    private JPanel timePanel;
    private JPanel instructionsPanel;
    private JPanel buttonPanel;
    private JLabel trialLabel;
    private JLabel titleLabel;
    private JLabel infoLabel;
    private JLabel timeLabel;
    private JLabel instructionsLabel;
    private JButton withdrawButton;
    private JPanel waitPanel;
    private JPanel receivedPanel;
    private JPanel pleaseWaitPanel;
    private JPanel earningsPanel;
    private JPanel infoPanel2;
    private JPanel timePanel2;
    private JLabel receivedLabel;
    private JLabel pleaseWaitLabel;
    private JLabel earningsLabel;
    private JLabel trialLabel2;
    private JLabel timeLabel2;
    private JPanel continuePanel;
    private JPanel waitReadyPanel;
    private JPanel paymentPanel;
    private JPanel totalEarningsPanel;
    private JLabel waitReadyLabel;
    private JLabel paymentLabel;
    private JLabel totalEarningsLabel;
    private int numWithdrawn;
    private int numRemaining;
    private int time;
    private int reauthTime;
    private String opportunityNum;
    private String trialNum;
    private float[][] payoffGrid;
    private boolean dialogHold;
    private float payment;
    private float earnings;
    private boolean withdrawn;
    private boolean confirming;
    private boolean autoWithdraw;
    private boolean messaging;
    private Timer timer;
    private static Category log = Category.getInstance(BankRunOldGUI.class);

    public void close() {
    }

    protected void constructLayout(Information info, ClientData clientData) {
        this.withdrawn = false;
        this.numWithdrawn = (Integer)info.getInfo("numWithdrawn");
        this.numRemaining = (Integer)info.getInfo("numRemaining");
        this.time = (Integer)info.getInfo("time");
        this.opportunityNum = (String)info.getInfo("opportunityNum");
        this.trialNum = (String)info.getInfo("trialNum");
        this.payoffGrid = (float[][])info.getInfo("payoffGrid");
        this.withdrawn = (Boolean)info.getInfo("withdrawn");
        this.reauthTime = (Integer)info.getInfo("reauthTime");
        this.autoWithdraw = (Boolean)info.getInfo("autoWithdraw");
        this.messaging = (Boolean)info.getInfo("messaging");
        Runnable doUpdate = new Runnable(){

            public void run() {
                BankRunOldGUI.this.trialLabel.setText("Trial " + BankRunOldGUI.this.trialNum);
                BankRunOldGUI.this.titleLabel.setText("Withdrawal Opportunity " + BankRunOldGUI.this.opportunityNum);
                BankRunOldGUI.this.timeLabel.setText("<html>Time remaining in Withdrawal Opportunity " + BankRunOldGUI.this.opportunityNum + ": <font color=red size=20>" + BankRunOldGUI.this.time + "</font> seconds</html>");
                BankRunOldGUI.this.trialLabel2.setText("<html>Trial <font color=red>" + BankRunOldGUI.this.trialNum + "</font>");
                BankRunOldGUI.this.timeLabel2.setText("<html>Time remaining in Withdrawal Opportunity " + BankRunOldGUI.this.opportunityNum + ": <font color=red>" + BankRunOldGUI.this.time + "</font> seconds</html>");
                if (!BankRunOldGUI.this.withdrawn) {
                    if (BankRunOldGUI.this.autoWithdraw) {
                        BankRunOldGUI.this.withdrawn = true;
                        BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.actionPanel);
                        BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.waitPanel);
                        if (BankRunOldGUI.this.messaging) {
                            BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.clientMessages);
                        }
                    } else {
                        BankRunOldGUI.this.withdrawButton.setEnabled(true);
                        BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.continuePanel);
                        BankRunOldGUI.this.constructPayoffTable();
                        BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.actionPanel);
                        if (BankRunOldGUI.this.messaging) {
                            BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.clientMessages);
                        }
                    }
                } else {
                    BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.waitPanel);
                }
                BankRunOldGUI.this.pack();
                BankRunOldGUI.this.centerOnScreen();
            }
        };
        this.timer = new Timer();
        TimerTask task = new TimerTask(){

            public void run() {
                BankRunOldGUI.this.time--;
                BankRunOldGUI.this.timeLabel.setText("<html>Time remaining in Withdrawal Opportunity " + BankRunOldGUI.this.opportunityNum + ": <font color=red size=20>" + BankRunOldGUI.this.time + "</font> seconds</html>");
                BankRunOldGUI.this.timeLabel2.setText("<html>Time remaining in Withdrawal Opportunity " + BankRunOldGUI.this.opportunityNum + ": <font color=red>" + BankRunOldGUI.this.time + "</font> seconds</html>");
                if (BankRunOldGUI.this.time == 0) {
                    BankRunOldGUI.this.timer.cancel();
                    BankRunOldGUI.this.withdrawButton.setEnabled(false);
                    BankRunOldGUI.this.timeLabel.setText("Please Wait");
                    BankRunOldGUI.this.timeLabel2.setText("Please Wait");
                    BankRunOldGUI.this.sendResponse();
                }
            }
        };
        this.timer.schedule(task, 1000L, 1000L);
        SwingUtilities.invokeLater(doUpdate);
        if (!this.withdrawn && this.autoWithdraw) {
            JOptionPane.showMessageDialog(null, "<html>A withdrawal request has automatically been put in on your behalf.<br>Your payoff will appear shortly.</html>", "Withdrawal Complete", 0);
        }
    }

    protected void constructWaitingLayout(Information info) {
    }

    private void constructPayoffTable() {
        this.dataPanel.removeAll();
        this.dataPanel.setLayout(new BoxLayout(this.dataPanel, 1));
        JPanel gridTitlePanel = new JPanel();
        JLabel gridTitleLabel = new JLabel("Payoff Table");
        gridTitleLabel.setFont(new Font("Arial", 1, 17));
        gridTitleLabel.setForeground(Color.red);
        gridTitlePanel.add(gridTitleLabel);
        this.dataPanel.add(gridTitlePanel);
        JScrollPane gridScroll = new JScrollPane();
        JPanel headerPanel = new JPanel();
        JPanel gridPanel = new JPanel();
        gridScroll.setColumnHeaderView(headerPanel);
        gridScroll.setViewportView(gridPanel);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        gridScroll.setPreferredSize(new Dimension(screen.width / 2, screen.height / 2));
        gridScroll.setMaximumSize(new Dimension(32000, (int)((double)screen.height / 1.5)));
        int numRows = this.payoffGrid.length;
        int numCols = 3;
        headerPanel.setLayout(new GridLayout(1, numCols));
        gridPanel.setLayout(new GridLayout(numRows, numCols));
        JLabel heading1 = new JLabel();
        heading1.setText("<html>Estimated number of<br>new withdrawal<br>requests</html>");
        heading1.setFont(new Font("Arial", 1, 13));
        heading1.setForeground(Color.black);
        heading1.setHorizontalAlignment(0);
        headerPanel.add(heading1);
        JLabel heading2 = new JLabel();
        heading2.setText("<html>Amount each<br>requester would<br>receive</html>");
        heading2.setFont(new Font("Arial", 1, 13));
        heading2.setForeground(Color.black);
        heading2.setHorizontalAlignment(0);
        headerPanel.add(heading2);
        JLabel heading3 = new JLabel();
        heading3.setText("<html>Payment to each<br>remaining depositor if<br>no more withdrawals</html>");
        heading3.setFont(new Font("Arial", 1, 13));
        heading3.setForeground(Color.black);
        heading3.setHorizontalAlignment(0);
        headerPanel.add(heading3);
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        for (int i = 0; i < numRows; ++i) {
            JLabel number = new JLabel();
            number.setText("<html><br>" + i + "<br></html>");
            number.setFont(new Font("Arial", 1, 13));
            number.setForeground(Color.black);
            number.setHorizontalAlignment(0);
            gridPanel.add(number);
            JLabel requestAmount = new JLabel();
            float withdrawPayment = this.payoffGrid[i][0];
            if (withdrawPayment >= 0.0f) {
                requestAmount.setText("<html><br>" + formatter.format(withdrawPayment) + "<br></html>");
            } else {
                requestAmount.setText("<html><br>Not Applicable<br></html>");
            }
            requestAmount.setFont(new Font("Arial", 1, 13));
            requestAmount.setForeground(Color.black);
            requestAmount.setHorizontalAlignment(0);
            gridPanel.add(requestAmount);
            JLabel depositAmount = new JLabel();
            float depositPayment = this.payoffGrid[i][1];
            if (depositPayment >= 0.0f) {
                depositAmount.setText("<html><br>" + formatter.format(depositPayment) + "<br></html>");
            } else {
                depositAmount.setText("<html><br>Not Applicable<br></html>");
            }
            depositAmount.setFont(new Font("Arial", 1, 13));
            depositAmount.setForeground(Color.black);
            depositAmount.setHorizontalAlignment(0);
            gridPanel.add(depositAmount);
        }
        this.dataPanel.add(gridScroll);
    }

    private void sendResponse() {
        if (this.withdrawn) {
            this.addInfo("withdrawn", "true");
        } else {
            this.addInfo("withdrawn", "false");
        }
        this.makeMove();
    }

    public void reauthenticate() {
        this.time = this.reauthTime;
    }

    public void initialize() {
        this.actionPanel = new JPanel();
        this.trialPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.dataPanel = new JPanel();
        this.infoPanel = new JPanel();
        this.timePanel = new JPanel();
        this.instructionsPanel = new JPanel();
        this.trialLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.timeLabel = new JLabel();
        this.instructionsLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.withdrawButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 1));
        this.trialLabel.setText("Trial 0");
        this.trialLabel.setFont(new Font("Arial", 1, 16));
        this.trialLabel.setForeground(Color.blue);
        this.trialPanel.add(this.trialLabel);
        this.actionPanel.add(this.trialPanel);
        this.titleLabel.setText("Withdrawal Opportunity 1");
        this.titleLabel.setFont(new Font("Arial", 1, 27));
        this.titleLabel.setForeground(Color.blue);
        this.titlePanel.add(this.titleLabel);
        this.actionPanel.add(this.titlePanel);
        this.infoLabel.setText("<html><font color=red>X</font> withdrawal requests were made so far. The number of remaining depositors is <font color=red>Y</font></html>");
        this.infoLabel.setFont(new Font("Arial", 1, 16));
        this.infoLabel.setForeground(Color.black);
        this.infoPanel.add(this.infoLabel);
        this.actionPanel.add(this.dataPanel);
        this.timeLabel.setText("<html>Time remaining in Withdrawal Opportunity 1: <font color=red size=20>XX</font> seconds</html>");
        this.timeLabel.setFont(new Font("Arial", 1, 16));
        this.timeLabel.setForeground(Color.black);
        this.timePanel.add(this.timeLabel);
        this.actionPanel.add(this.timePanel);
        this.instructionsLabel.setText("<html>To make a withdrawal request click the 'Withdraw Now' button at the bottom of the page<br><u>before time expires.</u> If you do not click the 'Withdraw Now' button before time expires<br>your money will remain deposited.</html>");
        this.instructionsPanel.add(this.instructionsLabel);
        this.actionPanel.add(this.instructionsPanel);
        this.withdrawButton.setText("Withdraw Now");
        this.withdrawButton.setFont(new Font("Arial", 1, 24));
        this.withdrawButton.setForeground(Color.black);
        this.withdrawButton.setBackground(Color.lightGray);
        this.withdrawButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BankRunOldGUI.this.dialogHold = true;
                BankRunOldGUI.this.withdrawn = true;
                BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.actionPanel);
                BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.waitPanel);
                if (BankRunOldGUI.this.messaging) {
                    BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.clientMessages);
                }
                BankRunOldGUI.this.pack();
                BankRunOldGUI.this.centerOnScreen();
                BankRunOldGUI.this.dialogHold = false;
            }
        });
        this.buttonPanel.add(this.withdrawButton);
        this.actionPanel.add(this.buttonPanel);
        this.waitPanel = new JPanel();
        this.receivedPanel = new JPanel();
        this.pleaseWaitPanel = new JPanel();
        this.earningsPanel = new JPanel();
        this.infoPanel2 = new JPanel();
        this.timePanel2 = new JPanel();
        this.receivedLabel = new JLabel();
        this.pleaseWaitLabel = new JLabel();
        this.earningsLabel = new JLabel();
        this.trialLabel2 = new JLabel();
        this.timeLabel2 = new JLabel();
        this.waitPanel.setLayout(new GridLayout(5, 1));
        this.receivedLabel.setText("Your withdrawal request was received.");
        this.receivedLabel.setFont(new Font("Arial", 1, 20));
        this.receivedLabel.setForeground(Color.black);
        this.receivedPanel.setLayout(new FlowLayout(1, 5, 5));
        this.receivedPanel.add(this.receivedLabel);
        this.waitPanel.add(this.receivedPanel);
        this.pleaseWaitLabel.setText("Please wait until the end of this trial.");
        this.pleaseWaitLabel.setFont(new Font("Arial", 1, 17));
        this.pleaseWaitLabel.setForeground(Color.red);
        this.pleaseWaitPanel.setLayout(new FlowLayout(1, 5, 5));
        this.pleaseWaitPanel.add(this.pleaseWaitLabel);
        this.waitPanel.add(this.pleaseWaitPanel);
        this.earningsLabel.setText("<html>Your <b>earnings for this trial</b> and your <b>total earnings</b><br>(excluding show-up fee) will be presented to you shortly.</html>");
        this.earningsLabel.setFont(new Font("Arial", 1, 15));
        this.earningsLabel.setForeground(Color.black);
        this.earningsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.earningsPanel.add(this.earningsLabel);
        this.waitPanel.add(this.earningsPanel);
        this.trialLabel2.setText("<html>Trial <font color=red>XX</font>");
        this.trialLabel2.setFont(new Font("Arial", 1, 15));
        this.trialLabel2.setForeground(Color.black);
        this.trialLabel2.setHorizontalAlignment(0);
        this.trialLabel2.setVerticalAlignment(0);
        this.infoPanel2.add(this.trialLabel2);
        this.waitPanel.add(this.infoPanel2);
        this.timeLabel2.setText("<html>Time remaining in Withdrawal Opportunity 1: <font color=red>XX</font> seconds</html>");
        this.timeLabel2.setFont(new Font("Arial", 1, 15));
        this.timeLabel2.setForeground(Color.black);
        this.timePanel2.add(this.timeLabel2);
        this.waitPanel.add(this.timePanel2);
        this.continuePanel = new JPanel();
        this.waitReadyPanel = new JPanel();
        this.paymentPanel = new JPanel();
        this.totalEarningsPanel = new JPanel();
        this.waitReadyLabel = new JLabel();
        this.paymentLabel = new JLabel();
        this.totalEarningsLabel = new JLabel();
        this.continuePanel.setLayout(new GridLayout(3, 1));
        this.waitReadyLabel.setText("<html>Please wait until the other participants are ready to begin the next trial.</html>");
        this.waitReadyLabel.setFont(new Font("Arial", 1, 18));
        this.waitReadyLabel.setForeground(Color.black);
        this.waitReadyPanel.add(this.waitReadyLabel);
        this.continuePanel.add(this.waitReadyPanel);
        this.paymentLabel.setText("Processing payoff...");
        this.paymentLabel.setFont(new Font("Arial", 1, 15));
        this.paymentLabel.setForeground(Color.black);
        this.paymentPanel.add(this.paymentLabel);
        this.continuePanel.add(this.paymentPanel);
        this.totalEarningsLabel.setText("Processing total earnings...");
        this.totalEarningsLabel.setFont(new Font("Arial", 1, 15));
        this.totalEarningsLabel.setForeground(Color.black);
        this.totalEarningsPanel.add(this.totalEarningsLabel);
        this.continuePanel.add(this.totalEarningsPanel);
        this.pack();
        this.centerOnScreen();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new BankRunOldGUI().setVisible(true);
    }

    public void respond(Object obj) {
    }

    public void testingProcedures() {
    }

    public void processMessage(MessagePacket mes) {
        try {
            if (mes.getType() == 5) {
                float[] earningsArray = (float[])mes.getObject();
                this.payment = earningsArray[0];
                this.earnings = earningsArray[1];
                NumberFormat formatter = NumberFormat.getCurrencyInstance();
                if (this.paymentLabel != null) {
                    this.paymentLabel.setText("<html>Your payment for <font color=red>trial " + this.trialNum + "</font> is " + formatter.format(this.payment) + "</html>");
                }
                if (this.totalEarningsLabel != null) {
                    this.totalEarningsLabel.setText("<html>Your <b>total earnings</b> excluding show-up fee are " + formatter.format(this.earnings) + "</html>");
                }
                Runnable update = new Runnable(){

                    public void run() {
                        BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.actionPanel);
                        BankRunOldGUI.this.getContentPane().remove(BankRunOldGUI.this.waitPanel);
                        BankRunOldGUI.this.getContentPane().add(BankRunOldGUI.this.continuePanel);
                    }
                };
                SwingUtilities.invokeLater(update);
            } else {
                super.processMessage(mes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayMessage(Object[] message) {
        while (this.dialogHold) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        super.displayMessage(message);
        this.pack();
        this.centerOnScreen();
    }
}

