/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class StatPanel
extends JPanel {
    private JPanel TitlePanel;
    private JLabel TitleLabel;
    private JScrollPane DataScroller;
    private JPanel DataPanel;
    protected String[] rowLabels;
    protected String[] columnLabels;
    protected String[][] data;

    public StatPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.DataScroller = new JScrollPane();
        this.DataPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.TitlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 32));
        this.TitleLabel.setText("Statistics Panel");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setHorizontalAlignment(0);
        this.TitleLabel.setFont(new Font("Arial Black", 0, 15));
        this.TitlePanel.add(this.TitleLabel);
        this.add(this.TitlePanel);
        this.DataScroller.setViewportView(this.DataPanel);
        this.add(this.DataScroller);
    }

    public void updateStatData() {
        if (this.data == null || this.data.length < 1 || this.columnLabels == null || this.rowLabels == null) {
            return;
        }
        Runnable doUpdate = new Runnable(){

            public void run() {
                JPanel border;
                int i;
                StatPanel.this.DataPanel.removeAll();
                int numColumns = Math.min(StatPanel.this.columnLabels.length, StatPanel.this.data[0].length);
                int numRows = Math.min(StatPanel.this.rowLabels.length, StatPanel.this.data.length);
                GridBagLayout gridbag = new GridBagLayout();
                StatPanel.this.DataPanel.setLayout(gridbag);
                GridBagConstraints normalCell = new GridBagConstraints();
                GridBagConstraints endCell = new GridBagConstraints();
                GridBagConstraints fillerCell = new GridBagConstraints();
                normalCell.weightx = 1.0;
                normalCell.fill = 1;
                endCell.weightx = 1.0;
                endCell.fill = 1;
                endCell.gridwidth = 0;
                fillerCell.weighty = 1.0;
                fillerCell.fill = 1;
                JPanel filler = new JPanel();
                gridbag.setConstraints(filler, normalCell);
                StatPanel.this.DataPanel.add(filler);
                for (i = 0; i < numColumns; ++i) {
                    border = new JPanel();
                    JLabel colLabel = new JLabel();
                    colLabel.setForeground(Color.blue);
                    colLabel.setText(StatPanel.this.columnLabels[i]);
                    colLabel.setHorizontalAlignment(0);
                    border.add(colLabel);
                    if (i == numColumns - 1) {
                        gridbag.setConstraints(border, endCell);
                    } else {
                        gridbag.setConstraints(border, normalCell);
                    }
                    StatPanel.this.DataPanel.add(border);
                }
                for (i = 0; i < numRows; ++i) {
                    border = new JPanel();
                    JLabel rowLabel = new JLabel();
                    rowLabel.setText(StatPanel.this.rowLabels[i]);
                    rowLabel.setForeground(Color.blue);
                    rowLabel.setHorizontalAlignment(2);
                    border.add(rowLabel);
                    gridbag.setConstraints(border, normalCell);
                    StatPanel.this.DataPanel.add(border);
                    for (int j = 0; j < numColumns; ++j) {
                        JPanel border2 = new JPanel();
                        JLabel dataLabel = new JLabel();
                        dataLabel.setText(StatPanel.this.data[i][j]);
                        dataLabel.setForeground(Color.black);
                        dataLabel.setHorizontalAlignment(0);
                        border2.add(dataLabel);
                        if (j == numColumns - 1) {
                            gridbag.setConstraints(border2, endCell);
                        } else {
                            gridbag.setConstraints(border2, normalCell);
                        }
                        StatPanel.this.DataPanel.add(border2);
                    }
                }
                StatPanel.this.updateUI();
                StatPanel.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setData(String[][] data) {
        this.data = data;
    }

    public void setRowLabels(String[] rowLabels) {
        this.rowLabels = rowLabels;
    }

    public void setColumnLabels(String[] columnLabels) {
        this.columnLabels = columnLabels;
    }

    public void setTitle(String title) {
        final String t = title;
        Runnable doUpdate = new Runnable(){

            public void run() {
                StatPanel.this.TitleLabel.setText(t);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }
}

