/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RandomUrn
extends JPanel {
    public static final String FILESEP = System.getProperty("file.separator");
    private Random rand = new Random();
    private int[] intVals;
    private double[] doubleVals;
    public HandAnim handAnim;
    private boolean ints;
    private boolean choicesVis;
    private boolean discrete = true;
    private JButton choicesButton;
    private JPanel choicesPanel;
    private JPanel dialogPanel;

    public RandomUrn(int[] intVals) {
        this.ints = true;
        this.intVals = (int[])intVals.clone();
        this.doubleVals = new double[intVals.length];
        for (int i = 0; i < intVals.length; ++i) {
            this.doubleVals[i] = intVals[i];
        }
        this.finishSetup();
    }

    public RandomUrn(double[] doubleVals) {
        this.ints = false;
        this.doubleVals = (double[])doubleVals.clone();
        this.intVals = new int[doubleVals.length];
        for (int i = 0; i < this.intVals.length; ++i) {
            this.intVals[i] = (int)Math.round(doubleVals[i]);
        }
        this.finishSetup();
    }

    public RandomUrn(double lowval, double highval) {
        this(lowval, highval, 0.01, false);
    }

    public RandomUrn(int lowval, int highval) {
        this(lowval, highval, 1);
    }

    public RandomUrn(int lowval, int highval, int spacing) {
        this.ints = true;
        if (lowval > highval) {
            int temp = lowval;
            lowval = highval;
            highval = temp;
        }
        if (lowval == highval) {
            throw new IllegalArgumentException("Low value and high value are equal");
        }
        if (spacing <= 0) {
            throw new IllegalArgumentException("Spacing must be positive");
        }
        int size = highval - lowval;
        int n = size / spacing + 1;
        this.intVals = new int[n];
        this.doubleVals = new double[n];
        int i = 0;
        int k = lowval;
        while (i < n) {
            this.intVals[i] = k;
            this.doubleVals[i] = this.intVals[i];
            ++i;
            k += spacing;
        }
        this.finishSetup();
    }

    public RandomUrn(double lowval, double highval, double spacing) {
        this(lowval, highval, spacing, true);
    }

    private RandomUrn(double lowval, double highval, double spacing, boolean discrete) {
        this.ints = false;
        this.discrete = discrete;
        if (lowval > highval) {
            double temp = lowval;
            lowval = highval;
            highval = temp;
        }
        if (Math.abs(lowval - highval) < Math.abs(spacing)) {
            throw new IllegalArgumentException("Low value and high value are too close together");
        }
        if (spacing <= 0.0) {
            throw new IllegalArgumentException("Spacing must be positive");
        }
        double size = highval - lowval;
        int n = (int)Math.round(size / spacing) + 1;
        this.intVals = new int[n];
        this.doubleVals = new double[n];
        int i = 0;
        double k = lowval;
        while (i < n) {
            this.intVals[i] = (int)Math.round(k);
            this.doubleVals[i] = lowval + (double)i * spacing;
            this.doubleVals[i] = Math.rint(1000.0 * this.doubleVals[i]) / 1000.0;
            ++i;
            k += spacing;
        }
        this.finishSetup();
    }

    private void finishSetup() {
        JLabel label;
        this.choicesPanel = new JPanel();
        this.dialogPanel = new JPanel();
        if (this.discrete) {
            int n = (int)Math.ceil(Math.sqrt(this.intVals.length));
            this.choicesPanel.setLayout(new GridLayout(n, n));
            for (int i = 0; i < this.intVals.length; ++i) {
                label = this.ints ? new JLabel("  " + this.intVals[i]) : new JLabel("  " + this.doubleVals[i]);
                label.setForeground(Color.black);
                this.choicesPanel.add(label);
            }
        }
        this.dialogPanel.setLayout(new BorderLayout());
        label = new JLabel();
        if (this.discrete) {
            label.setText("One of the following will be selected with equal probability:");
        } else {
            label.setText("A number between " + this.doubleVals[0] + " and " + this.doubleVals[this.doubleVals.length - 1] + " will be selected, each with equal probability.");
        }
        label.setForeground(Color.black);
        this.dialogPanel.add((Component)label, "North");
        this.dialogPanel.add((Component)this.choicesPanel, "South");
        this.choicesButton = new JButton("Show possible outcomes");
        this.choicesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(RandomUrn.this, RandomUrn.this.dialogPanel);
            }
        });
        this.setLayout(new BorderLayout());
        this.choicesVis = false;
        this.handAnim = new HandAnim();
        this.add((Component)this.handAnim, "North");
    }

    public void setSeed(long seed) {
        this.rand.setSeed(seed);
    }

    public int nextInt() {
        int i = this.intVals[this.rand.nextInt(this.intVals.length)];
        this.handAnim.setString("" + i);
        this.handAnim.resetAnimation();
        return i;
    }

    public double nextDouble() {
        double d = this.doubleVals[this.rand.nextInt(this.doubleVals.length)];
        this.handAnim.setString("" + d);
        this.handAnim.resetAnimation();
        return d;
    }

    public void forceDraw(String s) {
        this.handAnim.setString(s);
        this.handAnim.resetAnimation();
    }

    public void startingAction() {
    }

    public void stoppingAction() {
    }

    public void setChoicesButtonVisible(boolean show) {
        if (this.choicesVis && !show) {
            this.remove(this.choicesButton);
            this.choicesVis = false;
        } else if (!this.choicesVis && show) {
            this.add((Component)this.choicesButton, "South");
            this.choicesVis = true;
        }
    }

    public static void main2(String[] args) {
        JFrame f = new JFrame("Random Urn tester");
        final RandomUrn urn = new RandomUrn(0.0, 1.0){

            public void stoppingAction() {
                System.out.println("done");
            }
        };
        f.getContentPane().add((Component)urn, "Center");
        JButton b = new JButton("Gimme a new number");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(urn.nextDouble());
            }
        });
        urn.setChoicesButtonVisible(true);
        f.getContentPane().add((Component)b, "South");
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        final JButton draw = new JButton("draw");
        final JButton ok = new JButton("ok");
        ok.setEnabled(false);
        final RandomUrn urn = new RandomUrn(-100, 100){

            public void stoppingAction() {
                ok.setEnabled(true);
            }

            public void startingAction() {
                draw.setEnabled(false);
            }
        };
        urn.setChoicesButtonVisible(true);
        draw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                urn.forceDraw("42");
            }
        });
        JPanel urnpanel = new JPanel();
        urnpanel.add(urn);
        urnpanel.add(draw);
        JFrame f = new JFrame("this better work");
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Object[] choices = new Object[]{ok, draw};
        JOptionPane optionPane = new JOptionPane(urnpanel, -1, -1, null, choices);
        final JDialog dialog = new JDialog(f, "I sure hope this works", true);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
            }
        });
        dialog.pack();
        dialog.setVisible(true);
    }

    public class HandAnim
    extends JPanel
    implements ActionListener {
        int frameNumber = -1;
        boolean frozen = false;
        Timer timer;
        AnimationPane animationPane;
        private String path = "E:\\proj\\multistage\\trunk\\src\\edu\\caltech\\ssel\\projects\\multistage\\client\\interfaces\\images\\RandomUrn\\";

        HandAnim() {
            String fgFile = this.path + "balls.gif";
            String mgFile1 = this.path + "hand0.gif";
            String mgFile2 = this.path + "hand1.gif";
            System.out.println(this.path);
            Image mgImage1 = Toolkit.getDefaultToolkit().getImage(mgFile1);
            Image mgImage2 = Toolkit.getDefaultToolkit().getImage(mgFile2);
            Image fgImage = Toolkit.getDefaultToolkit().getImage(fgFile);
            int fps = 20;
            int delay = fps > 0 ? 1000 / fps : 100;
            this.timer = new Timer(delay, this);
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
            this.animationPane = new AnimationPane(mgImage1, mgImage2, fgImage, "");
            this.add((Component)this.animationPane, "Center");
        }

        public void setString(String s) {
            this.animationPane.s = s;
        }

        public boolean isDone() {
            return this.frozen;
        }

        public synchronized void startAnimation() {
            RandomUrn.this.startingAction();
            if (!this.frozen && !this.timer.isRunning()) {
                this.timer.start();
            }
        }

        public synchronized void stopAnimation() {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }

        public synchronized void resetAnimation() {
            this.stopAnimation();
            this.frameNumber = -1;
            this.frozen = false;
            this.animationPane.repaint();
            this.startAnimation();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.frameNumber > 2 * this.animationPane.stop) {
                this.stopAnimation();
                this.frozen = true;
                RandomUrn.this.stoppingAction();
            }
            this.frameNumber += 5;
            this.animationPane.repaint();
        }

        class AnimationPane
        extends JPanel {
            protected Image background;
            protected Image midground;
            protected Image midground2;
            protected Image foreground;
            protected String s = "4.2";
            private int compWidth;
            private int compHeight;
            private int bgWidth;
            private int bgHeight;
            private int fgWidth;
            private int fgHeight;
            private int mgWidth;
            private int mgHeight;
            private int handX;
            private int handY;
            private int stop;

            public AnimationPane(Image midground, Image midground2, Image foreground, String s) {
                this.midground = midground;
                this.midground2 = midground2;
                this.foreground = foreground;
                this.s = s;
                this.setBackground(Color.white);
                this.setBorder(BorderFactory.createLineBorder(Color.black, 4));
            }

            public Dimension getMinimumSize() {
                return new Dimension(250, 350);
            }

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setFont(new Font("Dialog", 1, 14));
                g.setColor(Color.black);
                this.compWidth = this.getWidth();
                this.compHeight = this.getHeight();
                this.mgWidth = this.midground.getWidth(this);
                this.mgHeight = this.midground.getHeight(this);
                this.fgWidth = this.foreground.getWidth(this);
                this.fgHeight = this.foreground.getHeight(this);
                this.stop = this.compHeight - this.mgHeight - this.fgHeight + 60;
                this.handX = (this.compWidth - this.mgWidth) / 2;
                int n = this.handY = HandAnim.this.frameNumber < this.stop ? HandAnim.this.frameNumber : 2 * this.stop - HandAnim.this.frameNumber;
                if (HandAnim.this.frameNumber < this.stop) {
                    g.drawImage(this.midground, this.handX, this.handY, this);
                    g.drawImage(this.midground2, -1000, -1000, this);
                } else {
                    g.drawImage(this.midground2, this.handX, this.handY, this);
                    g.drawString(this.s, this.handX + 80 - 4 * this.s.length(), this.handY + 110);
                }
                g.drawImage(this.foreground, (this.compWidth - this.fgWidth) / 2, this.compHeight - this.fgHeight, this);
            }
        }
    }
}

