/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.shared.data.ChoiceQuestion;
import edu.caltech.ssel.multistage.shared.data.DegreeQuestion;
import edu.caltech.ssel.multistage.shared.data.DropdownQuestion;
import edu.caltech.ssel.multistage.shared.data.EssayQuestion;
import edu.caltech.ssel.multistage.shared.data.InstructionQuestion;
import edu.caltech.ssel.multistage.shared.data.Question;
import edu.caltech.ssel.multistage.shared.data.SliderQuestion;
import edu.caltech.ssel.multistage.shared.data.TextQuestion;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Category;

public class QuestionDialog
extends JDialog {
    private JPanel SubmitPanel;
    private JPanel TitlePanel;
    private JScrollPane QuestionScroller;
    private JPanel QuestionPanel;
    private JLabel TitleLabel;
    private JButton SubmitButton;
    private JPanel TimePanel;
    private JLabel TimeLabel;
    private Timer countdown;
    private Timer timer;
    private ClientGUI parent;
    private Vector questions;
    private boolean testingMode;
    private long confirmDelay;
    private int timeLimit;
    public static Category log = Category.getInstance(QuestionDialog.class);

    public QuestionDialog(ClientGUI parent, boolean modal, boolean testingMode, int timeLimit, String titleText, String submitText) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.testingMode = testingMode;
        this.timeLimit = timeLimit;
        if (timeLimit == 0) {
            timeLimit = -1;
        }
        this.initComponents(titleText, submitText);
        this.questions = new Vector();
    }

    public QuestionDialog(ClientGUI parent, boolean modal, boolean testingMode, String titleText, String submitText) {
        this(parent, modal, testingMode, -1, titleText, submitText);
    }

    public QuestionDialog(ClientGUI parent, boolean modal, boolean testingMode, int timeLimit) {
        this(parent, modal, testingMode, timeLimit, null, null);
    }

    public QuestionDialog(ClientGUI parent, boolean modal, boolean testingMode) {
        this(parent, modal, testingMode, -1, null, null);
    }

    protected void initComponents(String titleText, String submitText) {
        if (titleText == null) {
            titleText = "Questions";
        }
        if (submitText == null) {
            submitText = "Submit Answers";
        }
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.QuestionScroller = new JScrollPane();
        this.QuestionPanel = new JPanel();
        this.SubmitPanel = new JPanel();
        this.SubmitButton = new JButton();
        this.TimePanel = new JPanel();
        this.TimeLabel = new JLabel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                QuestionDialog.this.closeDialog(evt);
            }
        });
        this.TitlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.TitleLabel.setFont(new Font("Arial Black", 0, 18));
        this.TitleLabel.setText(titleText);
        this.TitlePanel.add(this.TitleLabel);
        this.getContentPane().add(this.TitlePanel);
        this.TimePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.TimeLabel.setFont(new Font("Arial", 1, 15));
        this.TimeLabel.setForeground(new Color(120, 20, 30));
        if (this.timeLimit > -1) {
            this.TimeLabel.setText("Time Remaining: " + this.timeLimit);
            this.TimePanel.add(this.TimeLabel);
            this.getContentPane().add(this.TimePanel);
        }
        this.QuestionPanel.setLayout(new GridBagLayout());
        this.QuestionScroller.setViewportView(this.QuestionPanel);
        this.getContentPane().add(this.QuestionScroller);
        this.SubmitPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.SubmitButton.setText(submitText);
        this.SubmitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QuestionDialog.this.SubmitButtonActionPerformed(evt);
            }
        });
        this.SubmitPanel.add(this.SubmitButton);
        this.getContentPane().add(this.SubmitPanel);
        this.initSpecifics();
        this.pack();
    }

    protected void initSpecifics() {
    }

    protected Dimension relativeSize(float widthMultiple, float heightMultiple) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)((float)screen.width * widthMultiple);
        int height = (int)((float)screen.height * heightMultiple);
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    private void SubmitButtonActionPerformed(ActionEvent evt) {
        this.checkAnswers();
    }

    private void closeDialog(WindowEvent evt) {
        if (evt != null) {
            JOptionPane.showMessageDialog(null, this.getCloseError(), "Message", 0);
            return;
        }
        this.timer.cancel();
        this.countdown.cancel();
        this.setVisible(false);
        this.dispose();
    }

    protected void close() {
        this.closeDialog(null);
    }

    protected String getCloseError() {
        return "Please use the '" + this.SubmitButton.getText() + "' button to close this window";
    }

    public static void main(String[] args) {
        String[] a1 = new String[]{"3,000,000", "4,000,000", "5,000,000"};
        String[] a2 = new String[]{"Male", "Female"};
        String[] a3 = new String[]{"18", "19", "20", "21", "22"};
        SliderQuestion q1 = new SliderQuestion("<html><font color=#003366><br>What is the world population?</font></html>", 0, 2000, 4000);
        ChoiceQuestion q2 = new ChoiceQuestion("Are you male or female?", "Neither", a2);
        q2.setOtherChoice("Other");
        EssayQuestion q3 = new EssayQuestion("How do you feel?");
        String[] options = new String[]{"Not At All", "Slightly", "Moderately", "Very Much", "Completely"};
        String[] questions = new String[]{"Do you like anchovies because they can be really good if you eat them with a good dose of soup and possibly weed", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream", "Do you like ice cream"};
        DegreeQuestion q4 = new DegreeQuestion("Answer the questions using the following options", questions, options);
        InstructionQuestion q5 = new InstructionQuestion("<html><center><big><b>For the next few questions,<br>please take your time</html>");
        QuestionDialog qd = new QuestionDialog(null, true, true, 40, "Essay", "Submit");
        qd.addQuestion(q1);
        qd.addQuestion(q2);
        qd.addQuestion(q3);
        qd.addQuestion(q5);
        qd.addQuestion(q4);
        qd.setConfirmDelay(40000L);
        qd.display();
        System.out.println(qd.getQuestions());
    }

    public void setTitle(String title) {
        this.TitleLabel.setText(title);
    }

    public void addQuestions(Vector questions) {
        if (questions == null) {
            return;
        }
        for (int i = 0; i < questions.size(); ++i) {
            this.addQuestion((Question)questions.get(i));
        }
    }

    protected void addChoiceQuestion(ChoiceQuestion q, JPanel aPanel) {
        String[] answers = q.getOptions();
        ChoiceQuestion cq = q;
        String other = cq.getOtherChoice();
        final JTextField otherText = new JTextField();
        otherText.setMinimumSize(new Dimension(120, 24));
        otherText.setPreferredSize(new Dimension(120, 24));
        ButtonGroup bg = new ButtonGroup();
        aPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int i = 0;
        while (i < answers.length) {
            JRadioButton a = new JRadioButton(answers[i]);
            a.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    otherText.setEnabled(false);
                }
            });
            bg.add(a);
            a.setHorizontalAlignment(2);
            c.anchor = 23;
            c.gridx = 0;
            c.gridy = i++;
            aPanel.add((Component)a, c);
        }
        if (other != null) {
            final JRadioButton ob = new JRadioButton(other);
            ob.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    otherText.setEnabled(true);
                    ob.transferFocus();
                }
            });
            if (!ob.isSelected()) {
                otherText.setEnabled(false);
            }
            bg.add(ob);
            JPanel holder = new JPanel();
            holder.setLayout(new FlowLayout(0, 0, 0));
            holder.add(ob);
            holder.add(otherText);
            holder.setBackground(Color.ORANGE);
            c.gridy = answers.length;
            aPanel.add((Component)holder, c);
        }
    }

    protected void addSliderQuestion(SliderQuestion q, JPanel aPanel) {
        int min = Integer.parseInt(q.getOptions()[0]);
        int max = Integer.parseInt(q.getOptions()[2]);
        int inc = Integer.parseInt(q.getOptions()[1]);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter formatter = new NumberFormatter(numberFormat);
        formatter.setMinimum(new Integer(min));
        formatter.setMaximum(new Integer(max));
        final JSlider slider = new JSlider(min, max);
        final JFormattedTextField textField = new JFormattedTextField(formatter);
        slider.setLabelTable(slider.createStandardLabels(inc));
        slider.setPaintLabels(true);
        slider.setMinimumSize(new Dimension(400, 32));
        slider.setPreferredSize(new Dimension(400, 32));
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = slider.getValue();
                if (!slider.getValueIsAdjusting()) {
                    textField.setValue(new Integer(val));
                } else {
                    textField.setText(String.valueOf(val));
                }
            }
        });
        textField.setValue(new Integer(slider.getValue()));
        textField.setColumns(4);
        textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        AbstractAction anAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!textField.isEditValid()) {
                    textField.selectAll();
                } else {
                    try {
                        textField.commitEdit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        textField.getActionMap().put("check", anAction);
        textField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("value")) {
                    Number value = (Number)e.getNewValue();
                    if (slider != null && value != null) {
                        slider.setValue(value.intValue());
                    }
                }
            }
        });
        aPanel.setLayout(new FlowLayout(0));
        aPanel.add(textField);
        aPanel.add(slider);
    }

    protected void addEssayQuestion(EssayQuestion q, JPanel aPanel) {
        JScrollPane scroller = new JScrollPane();
        JTextArea text = new JTextArea(q.getOptions()[0]);
        text.setLineWrap(true);
        scroller.setViewportView(text);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        scroller.setMinimumSize(new Dimension((int)((double)screen.width * 0.34), (int)((double)screen.height * 0.25)));
        scroller.setPreferredSize(new Dimension((int)((double)screen.width * 0.34), (int)((double)screen.height * 0.25)));
        aPanel.setLayout(new FlowLayout(0));
        aPanel.add(scroller);
    }

    protected void addTextQuestion(TextQuestion q, JPanel aPanel) {
        JTextField text = new JTextField(q.getOptions()[0]);
        text.setMinimumSize(new Dimension(200, 28));
        text.setPreferredSize(new Dimension(300, 28));
        aPanel.add(text);
    }

    protected void addDegreeQuestion(DegreeQuestion q, JPanel aPanel) {
        String[] options = q.getOptions();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        for (int i = 0; i < options.length; ++i) {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            JLabel ql = new JLabel(options[i]);
            JTextField field = new JTextField();
            field.setColumns(3);
            field.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).setBackground(Color.white);
                }
            });
            panel.add(field);
            panel.add(ql);
            aPanel.add(panel);
        }
    }

    protected void addInstruction(InstructionQuestion q, JPanel aPanel) {
    }

    protected void addDropdownQuestion(DropdownQuestion q, JPanel aPanel) {
        String[] answers = q.getOptions();
        aPanel.setLayout(new FlowLayout(0));
        JComboBox<String> box = new JComboBox<String>(answers);
        box.setSelectedIndex(-1);
        aPanel.add(box);
    }

    public void addQuestion(Question question) {
        try {
            final Question q = question;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    QuestionDialog.this.setBackground(Color.WHITE);
                    JPanel tPanel = new JPanel();
                    tPanel.setLayout(new GridBagLayout());
                    GridBagConstraints c = new GridBagConstraints();
                    JPanel qPanel = new JPanel();
                    qPanel.setLayout(new FlowLayout(0));
                    JLabel qLabel = new JLabel();
                    qLabel.setForeground(Color.black);
                    qLabel.setText(q.getQuestion());
                    qPanel.add(qLabel);
                    c.anchor = 25;
                    c.gridx = 0;
                    c.gridy = 0;
                    c.ipady = 0;
                    tPanel.add((Component)qPanel, c);
                    JPanel aPanel = new JPanel();
                    Dimension size = QuestionDialog.this.getSize();
                    if (q.getStyle() == Question.CHOICE_QUESTION) {
                        QuestionDialog.this.addChoiceQuestion((ChoiceQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.SLIDER_QUESTION) {
                        QuestionDialog.this.addSliderQuestion((SliderQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.DROP_DOWN_QUESTION) {
                        QuestionDialog.this.addDropdownQuestion((DropdownQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.TEXT_QUESTION) {
                        QuestionDialog.this.addTextQuestion((TextQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.ESSAY_QUESTION) {
                        QuestionDialog.this.addEssayQuestion((EssayQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.DEGREE_QUESTION) {
                        QuestionDialog.this.addDegreeQuestion((DegreeQuestion)q, aPanel);
                    } else if (q.getStyle() == Question.INSTRUCTION_QUESTION) {
                        QuestionDialog.this.addInstruction((InstructionQuestion)q, aPanel);
                    }
                    c.gridy = 1;
                    tPanel.add((Component)aPanel, c);
                    c.gridx = 0;
                    c.gridy = QuestionDialog.this.questions.size();
                    c.anchor = 21;
                    c.ipady = 15;
                    QuestionDialog.this.QuestionPanel.add((Component)tPanel, c);
                    QuestionDialog.this.questions.add(q);
                    Dimension d = QuestionDialog.this.relativeSize(0.92f, 0.8f);
                    QuestionDialog.this.QuestionScroller.setPreferredSize(new Dimension(d.width, d.height));
                    QuestionDialog.this.pack();
                    QuestionDialog.this.centerOnScreen();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to add questions to the QuestionDialog" + MSConstants.newline + e));
        }
    }

    protected boolean checkAnswers() {
        if (this.questions == null) {
            return true;
        }
        boolean incorrect = false;
        boolean incomplete = false;
        for (int i = 0; i < this.questions.size(); ++i) {
            Question q = (Question)this.questions.get(i);
            String realAnswer = q.getAnswer();
            JPanel qpanel = (JPanel)this.QuestionPanel.getComponent(i);
            JPanel answerPanel = (JPanel)qpanel.getComponent(1);
            String chosenAnswer = "";
            if (q.getStyle() == Question.CHOICE_QUESTION) {
                JPanel holder;
                JRadioButton a;
                int numButtons = answerPanel.getComponentCount();
                ChoiceQuestion cq = (ChoiceQuestion)q;
                if (cq.hasOtherQuestion()) {
                    --numButtons;
                }
                for (int j = 0; j < numButtons; ++j) {
                    a = (JRadioButton)answerPanel.getComponent(j);
                    if (!a.isSelected()) continue;
                    chosenAnswer = a.getText();
                }
                if (cq.hasOtherQuestion() && (a = (JRadioButton)(holder = (JPanel)answerPanel.getComponent(numButtons)).getComponent(0)).isSelected()) {
                    chosenAnswer = ((JTextField)holder.getComponent(1)).getText();
                }
            }
            if (q.getStyle() == Question.SLIDER_QUESTION) {
                JSlider slider = (JSlider)answerPanel.getComponent(1);
                chosenAnswer = "" + slider.getValue();
            }
            if (q.getStyle() == Question.TEXT_QUESTION) {
                JTextField field = (JTextField)answerPanel.getComponent(0);
                chosenAnswer = field.getText();
            }
            if (q.getStyle() == Question.DROP_DOWN_QUESTION) {
                JComboBox box = (JComboBox)answerPanel.getComponent(0);
                int chosenIndex = box.getSelectedIndex();
                chosenAnswer = chosenIndex == -1 ? "" : (String)box.getSelectedItem();
            }
            if (q.getStyle() == Question.ESSAY_QUESTION) {
                JScrollPane scroller = (JScrollPane)answerPanel.getComponent(0);
                JTextArea text = (JTextArea)scroller.getViewport().getView();
                chosenAnswer = text.getText();
            }
            if (q.getStyle() == Question.DEGREE_QUESTION) {
                DegreeQuestion dq = (DegreeQuestion)q;
                int max = dq.getMaxOption();
                int min = dq.getMinOption();
                chosenAnswer = "";
                for (int j = 0; j < answerPanel.getComponentCount(); ++j) {
                    JPanel panel = (JPanel)answerPanel.getComponent(j);
                    JTextField field = (JTextField)panel.getComponent(0);
                    String answer = field.getText();
                    try {
                        int in = Integer.parseInt(answer);
                        if (in < min || in > max) {
                            throw new Exception();
                        }
                        chosenAnswer = chosenAnswer + " - " + in;
                        continue;
                    }
                    catch (Exception e) {
                        if (this.timeLimit != 0) {
                            JOptionPane.showMessageDialog(this, "The answer in the highlighted field must be between " + min + " and " + max + " inclusive", "Input Error", 0);
                            field.setBackground(new Color(179, 196, 255));
                            return false;
                        }
                        chosenAnswer = chosenAnswer + " - 0";
                    }
                }
                if (chosenAnswer.length() > 3) {
                    chosenAnswer = chosenAnswer.substring(3);
                }
            }
            if (!q.isSurvey() && realAnswer != null && chosenAnswer != null && this.timeLimit != 0 && !realAnswer.equals(chosenAnswer)) {
                incorrect = true;
                q.addWrongAnswer(chosenAnswer);
            }
            if (chosenAnswer.length() == 0 && this.timeLimit != 0 && q.getStyle() != Question.INSTRUCTION_QUESTION) {
                incomplete = true;
            }
            q.setChosenAnswer(chosenAnswer);
        }
        if (incomplete) {
            this.processIncomplete();
            return false;
        }
        if (incorrect) {
            this.processIncorrect();
            return false;
        }
        this.processCorrect();
        return true;
    }

    protected void processIncorrect() {
        JOptionPane.showMessageDialog(this, "Not all of your answers were correct! Try again.", "Incorrect", 0);
    }

    protected void processIncomplete() {
        JOptionPane.showMessageDialog(this, "Please answer all questions before proceeding", "Incomplete", 0);
    }

    protected void processCorrect() {
        this.close();
    }

    public void display() {
        final QuestionDialog qd = this;
        this.timer = new Timer();
        this.countdown = new Timer();
        final TimerTask task = new TimerTask(){

            public void run() {
                Runnable doUpdate = new Runnable(){

                    public void run() {
                        QuestionDialog.this.checkAnswers();
                        QuestionDialog.this.timer.cancel();
                        QuestionDialog.this.countdown.cancel();
                    }
                };
                SwingUtilities.invokeLater(doUpdate);
            }
        };
        final TimerTask countdownTask = new TimerTask(){

            public void run() {
                QuestionDialog.this.timeLimit--;
                Runnable doUpdate = new Runnable(){

                    public void run() {
                        QuestionDialog.this.TimeLabel.setText("Time Remaining: " + QuestionDialog.this.timeLimit);
                        if (QuestionDialog.this.timeLimit == 0) {
                            QuestionDialog.this.timer.cancel();
                            QuestionDialog.this.countdown.cancel();
                            JOptionPane.showMessageDialog(qd, "<html><center>The time allotted for answering the questions has expired.<br>Your current answers have been submitted.</center></html>");
                            QuestionDialog.this.checkAnswers();
                        }
                    }
                };
                SwingUtilities.invokeLater(doUpdate);
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                try {
                    if (QuestionDialog.this.testingMode) {
                        if (QuestionDialog.this.parent != null) {
                            QuestionDialog.this.confirmDelay = QuestionDialog.this.parent.getConfirmDelay();
                        }
                        QuestionDialog.this.generateTestAnswers();
                        QuestionDialog.this.timer.schedule(task, QuestionDialog.this.confirmDelay);
                    }
                    QuestionDialog.this.countdown.schedule(countdownTask, 1000L, 1000L);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to run QuestionDialog on-display procedures" + MSConstants.newline + e));
                    e.printStackTrace();
                }
            }
        });
        Runnable doUpdate = new Runnable(){

            public void run() {
                QuestionDialog.this.centerOnScreen();
                QuestionDialog.this.setVisible(true);
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to hold the current thread while running the QuestionDialog" + MSConstants.newline + e));
        }
    }

    private void generateTestAnswers() {
        if (this.questions == null) {
            return;
        }
        for (int i = 0; i < this.questions.size(); ++i) {
            int j;
            Question q = (Question)this.questions.get(i);
            JPanel qpanel = (JPanel)this.QuestionPanel.getComponent(i);
            JPanel answerPanel = (JPanel)qpanel.getComponent(1);
            if (q.getStyle() == Question.CHOICE_QUESTION) {
                ChoiceQuestion cq = (ChoiceQuestion)q;
                String testingAnswer = q.getTestingModeAnswer();
                int numButtons = answerPanel.getComponentCount();
                if (cq.hasOtherQuestion()) {
                    --numButtons;
                }
                boolean foundAnswer = false;
                for (j = 0; j < numButtons; ++j) {
                    JRadioButton a = (JRadioButton)answerPanel.getComponent(j);
                    if (!a.getText().equals(testingAnswer)) continue;
                    foundAnswer = true;
                    a.setSelected(true);
                }
                if (!foundAnswer && cq.hasOtherQuestion()) {
                    JPanel holder = (JPanel)answerPanel.getComponent(numButtons);
                    JRadioButton other = (JRadioButton)holder.getComponent(0);
                    other.setSelected(true);
                    JTextField otherText = (JTextField)holder.getComponent(1);
                    otherText.setText(testingAnswer);
                }
            }
            if (q.getStyle() == Question.SLIDER_QUESTION) {
                JSlider slider = (JSlider)answerPanel.getComponent(1);
                slider.setValue(Integer.parseInt(q.getTestingModeAnswer()));
            }
            if (q.getStyle() == Question.TEXT_QUESTION) {
                JTextField field = (JTextField)answerPanel.getComponent(0);
                field.setText(q.getTestingModeAnswer());
            }
            if (q.getStyle() == Question.DROP_DOWN_QUESTION) {
                JComboBox box = (JComboBox)answerPanel.getComponent(0);
                int itemCount = box.getItemCount();
                String testAnswer = q.getTestingModeAnswer();
                for (int j2 = 0; j2 < itemCount; ++j2) {
                    String a = (String)box.getItemAt(j2);
                    if (!a.equals(testAnswer)) continue;
                    box.setSelectedIndex(j2);
                }
            }
            if (q.getStyle() == Question.ESSAY_QUESTION) {
                JScrollPane scroller = (JScrollPane)answerPanel.getComponent(0);
                JTextArea text = (JTextArea)scroller.getViewport().getView();
                text.setText(q.getTestingModeAnswer());
            }
            if (q.getStyle() != Question.DEGREE_QUESTION) continue;
            DegreeQuestion qd = (DegreeQuestion)q;
            int min = qd.getMinOption();
            int max = qd.getMaxOption() + 1;
            Random rand = new Random();
            for (j = 0; j < answerPanel.getComponentCount(); ++j) {
                JPanel panel = (JPanel)answerPanel.getComponent(j);
                JTextField field = (JTextField)panel.getComponent(0);
                int testChoice = rand.nextInt(max - min) + min;
                field.setText("" + testChoice);
            }
        }
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public Vector getQuestions() {
        return this.questions;
    }

    public void setConfirmDelay(long confirmDelay) {
        this.confirmDelay = confirmDelay;
    }

    public JPanel getSubmitPanel() {
        return this.SubmitPanel;
    }

    public JPanel getTitlePanel() {
        return this.TitlePanel;
    }

    public JButton getSubmitButton() {
        return this.SubmitButton;
    }

    public JPanel getQuestionPanel() {
        return this.QuestionPanel;
    }
}

