/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Time;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class MediaPanel
extends JPanel {
    private Player mediaPlayer;
    private boolean controllable;
    private boolean displayed = true;
    private boolean error = false;
    private static Category log = Category.getInstance(MediaPanel.class);
    private Time duration;

    public MediaPanel(boolean controllable) {
        this.controllable = controllable;
    }

    public void load(String path) {
        try {
            this.load(new URL(path));
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Error loading media, path malformed: " + ex));
            System.out.println("Error loading media, path malformed: " + ex);
        }
    }

    public void load(String path, String buttonText) {
        try {
            this.load(new URL(path), buttonText);
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Error loading media, path malformed: " + ex));
            System.out.println("Error loading media, path malformed: " + ex);
        }
    }

    public void load(URL path) {
        try {
            this.mediaPlayer = Manager.createRealizedPlayer((MediaLocator)new MediaLocator(path));
            log.debug((Object)"Media found and media player realized.");
            this.removeAll();
            Component mediaPanel = this.mediaPlayer.getVisualComponent();
            if (mediaPanel != null) {
                this.add(mediaPanel, "Center");
            }
            if (this.controllable) {
                this.add(this.mediaPlayer.getControlPanelComponent(), "South");
            }
            this.duration = this.mediaPlayer.getDuration();
        }
        catch (Exception ex) {
            try {
                ImageIcon image = new ImageIcon(path);
                Image iconImage = image.getImage();
                image.setImage(iconImage.getScaledInstance(211, -1, 4));
                this.removeAll();
                this.add(new JLabel(image));
                log.debug((Object)"Image found and loaded.");
                this.duration = new Time(0L);
            }
            catch (Exception ex2) {
                this.error = true;
                log.warn((Object)("Error loading media " + path));
            }
        }
    }

    public void load(URL path, String buttonText) {
        final JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.gray);
        this.displayed = false;
        try {
            this.mediaPlayer = Manager.createRealizedPlayer((MediaLocator)new MediaLocator(path));
            log.debug((Object)"Media found and media player realized.");
            this.removeAll();
            Component mediaPanel = this.mediaPlayer.getVisualComponent();
            if (mediaPanel != null) {
                panel.add(mediaPanel, "Center");
            }
            if (this.controllable) {
                panel.add(this.mediaPlayer.getControlPanelComponent(), "South");
            }
            this.duration = this.mediaPlayer.getDuration();
        }
        catch (Exception ex) {
            try {
                ImageIcon image = new ImageIcon(path);
                Image iconImage = image.getImage();
                image.setImage(iconImage.getScaledInstance(208, -1, 4));
                this.removeAll();
                panel.add(new JLabel(image));
                this.duration = new Time(0L);
                log.debug((Object)"Image found and loaded.");
            }
            catch (Exception ex2) {
                try {
                    path = new URL("file:/p:/idMediaFiles/zeroInformation.jpg");
                    ImageIcon image = new ImageIcon(path);
                    Image iconImage = image.getImage();
                    image.setImage(iconImage.getScaledInstance(208, -1, 4));
                    this.removeAll();
                    panel.add(new JLabel(image));
                    this.duration = new Time(0L);
                    log.debug((Object)"Image found and loaded.");
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                    log.warn((Object)("Error loading media " + path));
                }
            }
        }
        JButton button = new JButton(buttonText);
        final MediaPanel parent = this;
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parent.removeAll();
                parent.setLayout(new BorderLayout());
                parent.add((Component)panel, "Center");
                parent.revalidate();
                parent.repaint();
                MediaPanel.this.displayed = true;
                MediaPanel.this.play();
            }
        });
        this.setPreferredSize(panel.getPreferredSize());
        this.setMinimumSize(panel.getMinimumSize());
        this.setLayout(new BoxLayout(this, 1));
        button.setAlignmentX(0.5f);
        this.add(Box.createVerticalGlue());
        this.add(button);
        this.add(Box.createVerticalGlue());
    }

    public void setControllable(boolean controllable) {
        this.controllable = controllable;
    }

    public void play() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    public boolean displayed() {
        return this.displayed;
    }

    public boolean errored() {
        return this.error;
    }

    public Time getMediaTime() {
        return this.duration;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("MediaPanel test");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        MediaPanel mp = new MediaPanel(true);
        f.getContentPane().add(mp);
        f.pack();
        f.setVisible(true);
    }
}

