/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Category;

public class MatrixPanel
extends JPanel {
    protected int choice;
    protected int rows;
    protected int cols;
    protected double[][] rowPayoffs;
    protected double[][] colPayoffs;
    protected String[] rowChoices;
    protected String[] colChoices;
    protected boolean grayedOut;
    protected boolean rowPlayer;
    protected boolean showRows = true;
    protected boolean showCols = true;
    protected SmartJPanel[][] subpanels;
    protected JComponent[][] rowLabels;
    protected JComponent[][] colLabels;
    protected ClientGUI parent;
    protected Color rowHighlight;
    protected Color rowBorder;
    protected Color colHighlight;
    protected Color colBorder;
    protected Color intersectHighlight;
    protected Color intersectBorder;
    protected Color bgColor;
    protected Color grayColor;
    protected Color activeRowColor;
    protected Color activeColColor;
    protected Color singularColor;
    protected Color colColor;
    protected Color rowColor;
    protected int numBlinks;
    protected int flickerPeriod;
    protected Timer timer;
    protected ActionListener actList;
    protected int framesLeft;
    protected int flickerRow = -1;
    protected int flickerCol = -1;
    protected Vector highlitRows;
    protected Vector highlitCols;
    protected Vector borderRows;
    protected Vector borderCols;
    protected Font headerFont;
    protected Font labelFont;
    protected int highlighter;
    protected static Color medGray = new Color(150, 150, 150);
    protected static Color redHighlight = new Color(253, 159, 186);
    protected static Color blueHighlight = new Color(159, 186, 253);
    protected static Color yellowHighlight = new Color(251, 255, 94);
    public static int BACKGROUND_HIGHLIGHTER = 0;
    public static int BORDER_HIGHLIGHTER = 1;
    public static Category log = Category.getInstance(MatrixPanel.class);

    public MatrixPanel(ClientGUI parent, int rows, int cols, boolean rowPlayer) {
        double[][] rowPayoffs = new double[rows][cols];
        double[][] colPayoffs = new double[rows][cols];
        String[] rowChoices = new String[rows];
        for (int i = 0; i < rowChoices.length; ++i) {
            rowChoices[i] = "0";
        }
        String[] colChoices = new String[cols];
        for (int i = 0; i < colChoices.length; ++i) {
            colChoices[i] = "0";
        }
        this.initPanel(parent, rowPayoffs, colPayoffs, rowChoices, colChoices, rowPlayer, true);
    }

    public MatrixPanel(ClientGUI parent, double[][] payoffs, String[] choices, boolean grayedOut) {
        this(parent, payoffs, null, choices, choices, true, grayedOut);
    }

    public MatrixPanel(ClientGUI parent, double[][] rowPayoffs, double[][] colPayoffs, String[] rowChoices, String[] colChoices, boolean rowPlayer, boolean grayedOut) {
        this.initPanel(parent, rowPayoffs, colPayoffs, rowChoices, colChoices, rowPlayer, grayedOut);
    }

    private void initPanel(ClientGUI parent, double[][] rowPayoffs, double[][] colPayoffs, String[] rowChoices, String[] colChoices, boolean rowPlayer, boolean grayedOut) {
        this.rows = rowChoices.length;
        this.cols = colChoices.length;
        this.rowPayoffs = rowPayoffs;
        this.colPayoffs = colPayoffs;
        this.rowChoices = rowChoices;
        this.colChoices = colChoices;
        this.rowPlayer = rowPlayer;
        this.parent = parent;
        this.grayedOut = grayedOut;
        this.highlitRows = new Vector();
        this.highlitCols = new Vector();
        this.borderRows = new Vector();
        this.borderCols = new Vector();
        if (rowPayoffs == null) {
            this.showRows = false;
        }
        if (colPayoffs == null) {
            this.showCols = false;
        }
        this.numBlinks = 12;
        this.flickerPeriod = 50;
        this.highlighter = BACKGROUND_HIGHLIGHTER;
        this.initColors();
        this.setupLayout();
        this.choice = -1;
    }

    private void initColors() {
        this.activeRowColor = Color.red;
        this.rowBorder = Color.red;
        this.rowHighlight = redHighlight;
        this.activeColColor = Color.blue;
        this.colBorder = Color.blue;
        this.colHighlight = blueHighlight;
        this.singularColor = Color.black;
        this.grayColor = medGray;
        this.bgColor = this.getBackground();
        this.intersectHighlight = yellowHighlight;
        this.intersectBorder = Color.yellow;
        this.headerFont = new Font("Dialog", 1, 14);
        this.labelFont = new Font("Dialog", 1, 14);
    }

    public void setGrayedOut(boolean grayOut) {
        this.grayedOut = grayOut;
        Runnable doUpdate = new Runnable(){

            public void run() {
                int j;
                int i;
                if (MatrixPanel.this.grayedOut) {
                    MatrixPanel.this.rowColor = MatrixPanel.this.colColor = MatrixPanel.this.grayColor;
                } else if (MatrixPanel.this.colPayoffs == null || MatrixPanel.this.rowPayoffs == null) {
                    MatrixPanel.this.rowColor = MatrixPanel.this.colColor = MatrixPanel.this.singularColor;
                } else {
                    MatrixPanel.this.rowColor = MatrixPanel.this.activeRowColor;
                    MatrixPanel.this.colColor = MatrixPanel.this.activeColColor;
                }
                for (i = 1; i < MatrixPanel.this.rows + 1; ++i) {
                    MatrixPanel.this.rowLabels[0][i].setForeground(MatrixPanel.this.grayedOut ? MatrixPanel.this.grayColor : MatrixPanel.this.activeRowColor);
                }
                for (i = 1; i < MatrixPanel.this.cols + 1; ++i) {
                    MatrixPanel.this.colLabels[i][0].setForeground(MatrixPanel.this.grayedOut ? MatrixPanel.this.grayColor : MatrixPanel.this.activeColColor);
                }
                for (i = 0; i < MatrixPanel.this.cols + 1; ++i) {
                    for (j = 0; j < MatrixPanel.this.rows + 1; ++j) {
                        if (i != 0 && j != 0 || i + j == 0) continue;
                        MatrixPanel.this.subpanels[i][j].setBorder(BorderFactory.createLineBorder(MatrixPanel.this.grayedOut ? Color.lightGray : Color.black, 1));
                    }
                }
                for (i = 1; i < MatrixPanel.this.cols + 1; ++i) {
                    for (j = 1; j < MatrixPanel.this.rows + 1; ++j) {
                        MatrixPanel.this.rowLabels[i][j].setForeground(MatrixPanel.this.rowColor);
                        MatrixPanel.this.colLabels[i][j].setForeground(MatrixPanel.this.colColor);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void setRowColor(int r, Color color) {
        if (r < 0 || this.grayedOut) {
            return;
        }
        final int row = r;
        final Color c = color;
        Runnable doUpdate = new Runnable(){

            public void run() {
                for (int i = 0; i < MatrixPanel.this.cols + 1; ++i) {
                    MatrixPanel.this.subpanels[i][row].setBackground(c);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setColColor(int c, Color color) {
        if (c < 0 || this.grayedOut) {
            return;
        }
        final int column = c;
        final Color col = color;
        Runnable doUpdate = new Runnable(){

            public void run() {
                for (int i = 0; i < MatrixPanel.this.rows + 1; ++i) {
                    MatrixPanel.this.subpanels[column][i].setBackground(col);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setRowBorder(int r, Color color) {
        if (r < 0 || this.grayedOut) {
            return;
        }
        for (int i = 0; i < this.cols + 1; ++i) {
            this.subpanels[i][r].drawRowBorder(color);
        }
    }

    private void setColBorder(int c, Color color) {
        if (c < 0 || this.grayedOut) {
            return;
        }
        for (int i = 0; i < this.rows + 1; ++i) {
            this.subpanels[c][i].drawColBorder(color);
        }
    }

    public void setPayoffs(double[][] payoffs) {
        if (this.rowPayoffs != null) {
            this.setRowPayoffs(payoffs);
        }
        if (this.colPayoffs != null) {
            this.setColPayoffs(payoffs);
        }
    }

    public void swapColors() {
        Color c = this.activeRowColor;
        this.activeRowColor = this.activeColColor;
        this.activeColColor = c;
        c = this.rowHighlight;
        this.rowHighlight = this.colHighlight;
        this.colHighlight = c;
        this.setGrayedOut(this.grayedOut);
    }

    public synchronized void setSelectedRow(int r) {
        this.waitForFlickerEnd();
        this.highlightRow(r);
        this.flickerRow = r + 1;
    }

    public synchronized void setSelectedColumn(int c) {
        this.waitForFlickerEnd();
        this.highlightColumn(c);
        this.flickerCol = c + 1;
    }

    public void highlightRow(int r) {
        if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
            this.setRowColor(r + 1, this.rowHighlight);
            this.highlitRows.add(new Integer(r + 1));
        }
        if (this.highlighter == BORDER_HIGHLIGHTER) {
            this.setRowBorder(r + 1, this.rowBorder);
            this.borderRows.add(new Integer(r + 1));
            this.repaint();
        }
    }

    public void highlightColumn(int c) {
        if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
            this.setColColor(c + 1, this.colHighlight);
            this.highlitCols.add(new Integer(c + 1));
        }
        if (this.highlighter == BORDER_HIGHLIGHTER) {
            this.setColBorder(c + 1, this.colBorder);
            this.borderCols.add(new Integer(c + 1));
            this.repaint();
        }
    }

    public void undoHighlightRow(int r) {
        if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
            this.setRowColor(r + 1, this.bgColor);
            this.highlitRows.remove(new Integer(r + 1));
            final int row = r;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    for (int i = 0; i < MatrixPanel.this.highlitCols.size(); ++i) {
                        int col = (Integer)MatrixPanel.this.highlitCols.get(i);
                        MatrixPanel.this.subpanels[col][row + 1].setBackground(MatrixPanel.this.colHighlight);
                    }
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        if (this.highlighter == BORDER_HIGHLIGHTER) {
            this.setRowBorder(r + 1, null);
            this.borderRows.remove(new Integer(r + 1));
            for (int i = 0; i < this.borderCols.size(); ++i) {
                int col = (Integer)this.borderCols.get(i);
                this.subpanels[col][r + 1].drawColBorder(this.colBorder);
            }
            this.repaint();
        }
    }

    public void undoHighlightColumn(int c) {
        if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
            this.setColColor(c + 1, this.bgColor);
            this.highlitCols.remove(new Integer(c + 1));
            final int col = c;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    for (int i = 0; i < MatrixPanel.this.highlitRows.size(); ++i) {
                        int row = (Integer)MatrixPanel.this.highlitRows.get(i);
                        MatrixPanel.this.subpanels[col + 1][row].setBackground(MatrixPanel.this.rowHighlight);
                    }
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        if (this.highlighter == BORDER_HIGHLIGHTER) {
            this.setColBorder(c + 1, null);
            this.borderCols.remove(new Integer(c + 1));
            for (int i = 0; i < this.borderRows.size(); ++i) {
                int row = (Integer)this.borderRows.get(i);
                this.subpanels[c + 1][row].drawRowBorder(this.rowBorder);
            }
            this.repaint();
        }
    }

    protected void PanelMouseEntered(MouseEvent evt) {
        if (this.choice >= 0 || this.grayedOut) {
            return;
        }
        SmartJPanel pan = (SmartJPanel)evt.getSource();
        if (this.rowPlayer) {
            this.highlightRow(pan.getRow() - 1);
        } else {
            this.highlightColumn(pan.getCol() - 1);
        }
    }

    protected void PanelMouseExited(MouseEvent evt) {
        if (this.choice >= 0 || this.grayedOut) {
            return;
        }
        SmartJPanel pan = (SmartJPanel)evt.getSource();
        if (this.rowPlayer) {
            this.undoHighlightRow(pan.getRow() - 1);
        } else {
            this.undoHighlightColumn(pan.getCol() - 1);
        }
    }

    protected void PanelMouseClicked(MouseEvent event) {
        final MouseEvent evt = event;
        if (this.choice >= 0 || this.grayedOut || event.getButton() != 1) {
            return;
        }
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (MatrixPanel.this.rowPlayer) {
                    MatrixPanel.this.choice = ((SmartJPanel)evt.getSource()).getRow() - 1;
                    MatrixPanel.this.setFlicker(MatrixPanel.this.choice + 1, -1);
                } else {
                    MatrixPanel.this.choice = ((SmartJPanel)evt.getSource()).getCol() - 1;
                    MatrixPanel.this.setFlicker(-1, MatrixPanel.this.choice + 1);
                }
                MatrixPanel.this.additionalClickedEvents(MatrixPanel.this.choice);
            }
        };
        Thread updater = new Thread(doUpdate);
        updater.start();
    }

    public void simulateClick(int move) {
        try {
            log.debug((Object)("Matrix Panel is preparing to simulate click of choice " + move));
            if (this.choice >= 0 || this.grayedOut) {
                log.warn((Object)("Simulated click not completed -- choice " + this.choice + " has already been made"));
                return;
            }
            this.choice = move;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    if (MatrixPanel.this.rowPlayer) {
                        MatrixPanel.this.setFlicker(MatrixPanel.this.choice + 1, -1);
                    } else {
                        MatrixPanel.this.setFlicker(-1, MatrixPanel.this.choice + 1);
                    }
                    MatrixPanel.this.additionalClickedEvents(MatrixPanel.this.choice);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                log.warn((Object)"Testing mode click simulation should be called OUTSIDE the event dispatch thread to avoid possible stability problems!");
                doUpdate.run();
            } else {
                log.debug((Object)"Outside event dispatch thread -- simulating click directly");
                doUpdate.run();
            }
            log.debug((Object)("Click simulation of move " + move + " completed"));
        }
        catch (Exception e) {
            log.error((Object)("Error while attempting to simulate a click of move " + move), (Throwable)e);
        }
    }

    public void additionalClickedEvents(int choice) {
    }

    public int getChoice() {
        return this.choice;
    }

    public void setChoice(int choice) {
        this.choice = choice;
    }

    protected synchronized void setFlicker(int r, int c) {
        log.debug((Object)("Activating Matrix panel flickering of row " + r + " and column " + c + " (in MatrixPanel +1 coordinates; -1 means no flicker)"));
        if (r > this.rows) {
            log.warn((Object)("Aborting panel flickering: row " + r + " (Matrix Panel +1 coordinates) does not exist!"));
            return;
        }
        if (c > this.cols) {
            log.warn((Object)("Aborting panel flickering: column " + c + " (Matrix Panel +1 coordinates) does not exist!"));
            return;
        }
        if (r > -1) {
            this.flickerRow = r;
        }
        if (c > -1) {
            this.flickerCol = c;
        }
        if (r > -1 || c > -1) {
            this.framesLeft = 2 * this.numBlinks;
        }
    }

    public void fireFlicker(int r, int c) {
        int row = r == -1 ? r : r + 1;
        int col = c == -1 ? c : c + 1;
        this.setFlicker(row, col);
    }

    public void fireRowFlicker(int r) {
        this.fireFlicker(r, -1);
    }

    public void fireColFlicker(int c) {
        this.fireFlicker(-1, c);
    }

    public void reset() {
        if (this.flickerCol >= 0 && this.flickerRow >= 0) {
            this.subpanels[this.flickerCol][this.flickerRow].setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        }
        this.choice = -1;
        this.flickerCol = -1;
        this.flickerRow = -1;
        this.framesLeft = 0;
        for (int i = 0; i < this.rows + 1; ++i) {
            this.setRowColor(i, this.bgColor);
            this.setRowBorder(i, null);
        }
    }

    public boolean isStillBlinking() {
        return this.framesLeft > 0;
    }

    protected synchronized void doFlicker() {
        if (this.framesLeft <= 0 || this.grayedOut) {
            return;
        }
        if (this.framesLeft % 2 == 1) {
            if (this.flickerRow >= 0) {
                if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
                    this.setRowColor(this.flickerRow, this.rowHighlight);
                }
                if (this.highlighter == BORDER_HIGHLIGHTER) {
                    this.setRowBorder(this.flickerRow, this.activeRowColor);
                }
            }
            if (this.flickerCol >= 0) {
                if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
                    this.setColColor(this.flickerCol, this.colHighlight);
                }
                if (this.highlighter == BORDER_HIGHLIGHTER) {
                    this.setColBorder(this.flickerCol, this.activeColColor);
                }
            }
            if (this.flickerRow >= 0 && this.flickerCol >= 0) {
                if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
                    this.subpanels[this.flickerCol][this.flickerRow].setBackground(this.intersectHighlight);
                }
                if (this.highlighter == BORDER_HIGHLIGHTER) {
                    this.subpanels[this.flickerCol][this.flickerRow].drawFullBorder(this.intersectBorder);
                }
                if (this.framesLeft == 1) {
                    this.subpanels[this.flickerCol][this.flickerRow].setBorder(BorderFactory.createBevelBorder(0));
                }
            }
        } else {
            if (this.flickerRow >= 0) {
                if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
                    this.setRowColor(this.flickerRow, this.bgColor);
                }
                if (this.highlighter == BORDER_HIGHLIGHTER) {
                    this.setRowBorder(this.flickerRow, null);
                }
            }
            if (this.flickerCol >= 0) {
                if (this.highlighter == BACKGROUND_HIGHLIGHTER) {
                    this.setColColor(this.flickerCol, this.bgColor);
                }
                if (this.highlighter == BORDER_HIGHLIGHTER) {
                    this.setColBorder(this.flickerCol, null);
                }
            }
        }
        --this.framesLeft;
        this.repaint();
        if (this.framesLeft == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitForFlickerEnd() {
        try {
            while (this.framesLeft > 0) {
                this.wait();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while waiting for Matrix flickering to end", (Throwable)e);
        }
    }

    protected void setupLayout() {
        int j;
        int i;
        this.setLayout(new GridLayout(this.rows + 1, this.cols + 1));
        this.rowLabels = new JComponent[this.cols + 1][this.rows + 1];
        this.colLabels = new JComponent[this.cols + 1][this.rows + 1];
        for (i = 0; i < this.cols + 1; ++i) {
            for (j = 0; j < this.rows + 1; ++j) {
                this.rowLabels[i][j] = new JLabel("");
                this.colLabels[i][j] = new JLabel("");
            }
        }
        this.setupSmartPanels();
        this.updateLabels();
        for (int j2 = 0; j2 < this.rows + 1; ++j2) {
            for (int i2 = 0; i2 < this.cols + 1; ++i2) {
                this.subpanels[i2][j2].add((Component)this.rowLabels[i2][j2], "West");
                this.subpanels[i2][j2].add((Component)this.colLabels[i2][j2], "East");
                this.add(this.subpanels[i2][j2]);
            }
        }
        for (i = 0; i < this.cols + 1; ++i) {
            for (j = 0; j < this.rows + 1; ++j) {
                if (i != 0 && j != 0 || i + j == 0) continue;
                this.rowLabels[i][j].setFont(this.headerFont);
                this.colLabels[i][j].setFont(this.headerFont);
            }
        }
        for (i = 1; i < this.cols + 1; ++i) {
            for (j = 1; j < this.rows + 1; ++j) {
                this.subpanels[i][j].setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
                this.rowLabels[i][j].setFont(this.labelFont);
                this.colLabels[i][j].setFont(this.labelFont);
            }
        }
        this.setGrayedOut(this.grayedOut);
        if (this.rowPlayer) {
            for (i = 1; i < this.rows + 1; ++i) {
                this.subpanels[0][i].addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseClicked(evt);
                    }

                    public void mouseExited(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseExited(evt);
                    }

                    public void mouseEntered(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseEntered(evt);
                    }
                });
            }
        } else {
            for (i = 1; i < this.cols + 1; ++i) {
                this.subpanels[i][0].addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseClicked(evt);
                    }

                    public void mouseExited(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseExited(evt);
                    }

                    public void mouseEntered(MouseEvent evt) {
                        MatrixPanel.this.PanelMouseEntered(evt);
                    }
                });
            }
        }
        this.actList = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MatrixPanel.this.doFlicker();
            }
        };
        this.timer = new Timer(this.flickerPeriod, this.actList);
        this.timer.start();
    }

    protected void setupSmartPanels() {
        this.subpanels = new SmartJPanel[this.cols + 1][this.rows + 1];
        for (int i = 0; i < this.cols + 1; ++i) {
            for (int j = 0; j < this.rows + 1; ++j) {
                this.subpanels[i][j] = new SmartJPanel(j, i);
            }
        }
    }

    protected void updateLabels() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                int i;
                for (i = 1; i < MatrixPanel.this.rows + 1; ++i) {
                    ((JLabel)MatrixPanel.this.rowLabels[0][i]).setText(MatrixPanel.this.rowChoices[i - 1]);
                }
                for (i = 1; i < MatrixPanel.this.cols + 1; ++i) {
                    ((JLabel)MatrixPanel.this.colLabels[i][0]).setText(MatrixPanel.this.colChoices[i - 1]);
                }
                for (i = 1; i < MatrixPanel.this.cols + 1; ++i) {
                    for (int j = 1; j < MatrixPanel.this.rows + 1; ++j) {
                        if (MatrixPanel.this.showRows) {
                            ((JLabel)MatrixPanel.this.rowLabels[i][j]).setText(MatrixPanel.this.rowPayoffs[j - 1][i - 1] + " ");
                        }
                        if (!MatrixPanel.this.showCols) continue;
                        ((JLabel)MatrixPanel.this.colLabels[i][j]).setText(" " + MatrixPanel.this.colPayoffs[j - 1][i - 1]);
                    }
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                doUpdate.run();
            } else {
                SwingUtilities.invokeAndWait(doUpdate);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to update the labels of the Matrix Panel", (Throwable)e);
        }
    }

    public void close() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                MatrixPanel.this.removeAll();
                MatrixPanel.this.parent = null;
                MatrixPanel.this.timer.removeActionListener(MatrixPanel.this.actList);
                MatrixPanel.this.actList = null;
                MatrixPanel.this.timer = null;
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void setRowHighlight(Color c) {
        this.waitForFlickerEnd();
        this.rowHighlight = c;
    }

    public void setColHighlight(Color c) {
        this.waitForFlickerEnd();
        this.colHighlight = c;
    }

    public void setIntersectHighlight(Color c) {
        this.waitForFlickerEnd();
        this.intersectHighlight = c;
    }

    public void setRowBorder(Color c) {
        this.waitForFlickerEnd();
        this.rowBorder = c;
    }

    public void setColBorder(Color c) {
        this.waitForFlickerEnd();
        this.colBorder = c;
    }

    public void setIntersectBorder(Color c) {
        this.waitForFlickerEnd();
        this.intersectBorder = c;
    }

    public void setRowColor(Color c) {
        this.activeRowColor = c;
    }

    public void setColColor(Color c) {
        this.activeColColor = c;
    }

    public void setRowPayoffs(double[][] payoffs) {
        this.rowPayoffs = payoffs;
        this.updateLabels();
    }

    public void setColPayoffs(double[][] payoffs) {
        this.colPayoffs = payoffs;
        this.updateLabels();
    }

    public void setChoices(String[] choices) {
        this.setRowChoices(choices);
        this.setColChoices(choices);
    }

    public void setRowChoices(String[] choices) {
        this.rowChoices = choices;
        this.updateLabels();
    }

    public void setColChoices(String[] choices) {
        this.colChoices = choices;
        this.updateLabels();
    }

    public void setGrayColor(Color c) {
        this.grayColor = c;
    }

    public void setSingularColor(Color c) {
        this.singularColor = c;
    }

    public boolean isGrayedOut() {
        return this.grayedOut;
    }

    public void setFlickerPeriod(int flickerPeriod) {
        this.waitForFlickerEnd();
        this.flickerPeriod = flickerPeriod;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this.actList);
        }
        this.timer = new Timer(flickerPeriod, this.actList);
        this.timer.start();
    }

    public void setNumBlinks(int numBlinks) {
        this.waitForFlickerEnd();
        this.numBlinks = numBlinks;
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this.actList);
        }
        this.timer = new Timer(this.flickerPeriod, this.actList);
        this.timer.start();
    }

    public void setHeaderFont(Font headerFont) {
        this.headerFont = headerFont;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    public synchronized void setHighlighter(int highlighter) {
        this.waitForFlickerEnd();
        this.highlighter = highlighter;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Blinking Frame Test");
        double[][] payoffs = new double[][]{{10.0, 20.0, 30.0}, {40.0, 50.0, 60.0}, {70.0, 80.0, 90.0}};
        String[] choices = new String[]{"4", "8", "12"};
        MatrixPanel test = new MatrixPanel(null, payoffs, payoffs, choices, choices, false, true);
        MatrixPanel test2 = new MatrixPanel(null, payoffs, null, choices, choices, true, true);
        test2.setFlickerPeriod(30);
        f.getContentPane().add((Component)test2, "East");
        test.setSelectedRow(1);
        test.setSelectedRow(2);
        test.highlightColumn(0);
        test2.fireFlicker(-1, 2);
        test2.simulateClick(0);
        double[][] payoffs1 = new double[][]{{10.0, 20.0, 30.0, 40.0}, {40.0, 50.0, 60.0, 70.0}, {70.0, 80.0, 90.0, 100.0}};
        double[][] payoffs2 = new double[][]{{10.0, -20.0, 30.0, -40.0}, {-40.0, 50.0, -60.0, 70.0}, {70.0, -80.0, -90.0, 100.0}};
        String[] choices1 = new String[]{"4", "8", "12"};
        String[] choices2 = new String[]{"A", "B", "C", "D"};
        f.pack();
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public class SmartJPanel
    extends JPanel {
        private int row;
        private int col;
        private boolean drawRowBorder;
        private boolean drawColBorder;
        private boolean drawFullBorder;
        public Color borderColor;

        SmartJPanel(int r, int c) {
            this.row = r;
            this.col = c;
        }

        public void paint(Graphics gx) {
            super.paint(gx);
            Graphics2D g = (Graphics2D)gx;
            g.setColor(this.borderColor);
            g.setStroke(new BasicStroke(10.0f));
            if (this.drawRowBorder) {
                if (this.col == 0) {
                    g.drawLine(0, 0, 0, this.getHeight());
                }
                if (this.col == MatrixPanel.this.cols) {
                    g.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
                }
                g.drawLine(0, 0, this.getWidth(), 0);
                g.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
            }
            if (this.drawColBorder) {
                if (this.row == 0) {
                    g.drawLine(0, 0, this.getWidth(), 0);
                }
                if (this.row == MatrixPanel.this.rows) {
                    g.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
                }
                g.drawLine(0, 0, 0, this.getHeight());
                g.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
            }
            if (this.drawFullBorder) {
                g.drawLine(0, 0, this.getWidth(), 0);
                g.drawLine(0, 0, 0, this.getHeight());
                g.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
                g.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
            }
        }

        public void drawRowBorder(Color color) {
            if (color != null) {
                this.borderColor = color;
                this.drawRowBorder = true;
            } else {
                this.drawRowBorder = false;
                this.drawColBorder = false;
                this.drawFullBorder = false;
            }
        }

        public void drawColBorder(Color color) {
            if (color != null) {
                this.borderColor = color;
                this.drawColBorder = true;
            } else {
                this.drawRowBorder = false;
                this.drawColBorder = false;
                this.drawFullBorder = false;
            }
        }

        public void drawFullBorder(Color color) {
            if (color != null) {
                this.borderColor = color;
                this.drawFullBorder = true;
            } else {
                this.drawRowBorder = false;
                this.drawColBorder = false;
                this.drawFullBorder = false;
            }
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }
    }
}

