/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class InitGUI
extends JFrame
implements Runnable {
    private JPanel TitlePanel;
    private JLabel Title;
    private JPanel NamePanel;
    private JLabel NameLabel;
    private JTextField NameText;
    private JPanel HostPanel;
    private JLabel HostLabel;
    private JTextField HostText;
    private JPanel SubmitPanel;
    private JButton SubmitButton;
    private JPanel SubmitFiller;
    private JMenuBar MenuBar;
    private JMenu Options;
    private JMenuItem ExitMenuItem;
    private JCheckBoxMenuItem ReauthenticateBox;
    private JCheckBoxMenuItem TestingBox;
    private boolean submitted;
    private long seed;
    private String mode;
    private String name;
    private String host;
    private Mailbox box;
    private static Category log = Category.getInstance(InitGUI.class);
    private boolean itest;

    public InitGUI(Mailbox box, String name, String host, String mode, String seed_str, boolean integratedTest) {
        this.name = name;
        this.host = host;
        this.mode = mode;
        this.box = box;
        this.itest = integratedTest;
        this.submitted = false;
        if (seed_str != null) {
            try {
                this.seed = Long.parseLong(seed_str);
            }
            catch (Exception e) {
                log.warn((Object)"Invalid seed specified in configuration file, using no seed");
                this.seed = 0L;
            }
        } else {
            this.seed = 0L;
        }
        this.initComponents();
        this.centerOnScreen();
    }

    private void initComponents() {
        this.setTitle("Client Startup");
        this.TitlePanel = new JPanel();
        this.Title = new JLabel();
        this.NamePanel = new JPanel();
        this.NameLabel = new JLabel();
        this.NameText = new JTextField();
        this.HostPanel = new JPanel();
        this.HostLabel = new JLabel();
        this.HostText = new JTextField();
        this.SubmitPanel = new JPanel();
        this.SubmitButton = new JButton();
        this.SubmitFiller = new JPanel();
        this.MenuBar = new JMenuBar();
        this.Options = new JMenu();
        this.ExitMenuItem = new JMenuItem();
        this.ReauthenticateBox = new JCheckBoxMenuItem();
        this.TestingBox = new JCheckBoxMenuItem();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.Options.setText("Options");
        this.ExitMenuItem.setText("Exit");
        this.ExitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InitGUI.this.ExitMenuItemAction(evt);
            }
        });
        this.ReauthenticateBox.setText("Reauthenticate");
        this.TestingBox.setText("Testing Mode");
        this.TestingBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InitGUI.this.TestingAction(evt);
            }
        });
        this.Options.add(this.ReauthenticateBox);
        this.Options.add(this.TestingBox);
        this.Options.add(this.ExitMenuItem);
        this.MenuBar.add(this.Options);
        this.setJMenuBar(this.MenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InitGUI.this.exitForm(evt);
            }
        });
        this.Title.setText("Client Information");
        this.Title.setForeground(Color.black);
        this.Title.setHorizontalAlignment(0);
        this.Title.setFont(new Font("Book Antiqua", 1, 24));
        this.TitlePanel.add(this.Title);
        this.getContentPane().add(this.TitlePanel);
        this.NameLabel.setText("Name:");
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setFont(new Font("Dialog", 1, 14));
        this.NamePanel.add(this.NameLabel);
        this.NameText.setFont(new Font("Dialog", 0, 14));
        this.NameText.setPreferredSize(new Dimension(200, 21));
        this.NamePanel.add(this.NameText);
        this.getContentPane().add(this.NamePanel);
        this.HostLabel.setText("Host:");
        this.HostLabel.setForeground(Color.black);
        this.HostLabel.setFont(new Font("Dialog", 1, 14));
        this.HostLabel.setPreferredSize(new Dimension(43, 20));
        this.HostLabel.setMinimumSize(new Dimension(43, 20));
        this.HostLabel.setMaximumSize(new Dimension(43, 20));
        this.HostPanel.add(this.HostLabel);
        this.HostText.setFont(new Font("Dialog", 0, 14));
        this.HostText.setPreferredSize(new Dimension(200, 21));
        this.HostPanel.add(this.HostText);
        this.getContentPane().add(this.HostPanel);
        this.SubmitPanel.setLayout(new FlowLayout(2));
        this.SubmitButton.setText("Submit");
        this.SubmitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InitGUI.this.SubmitButtonAction(evt);
            }
        });
        this.SubmitPanel.add(this.SubmitButton);
        this.SubmitFiller.setPreferredSize(new Dimension(64, 10));
        this.SubmitPanel.add(this.SubmitFiller);
        this.getContentPane().add(this.SubmitPanel);
        this.pack();
    }

    private void ExitMenuItemAction(ActionEvent evt) {
        System.exit(0);
    }

    private void SubmitButtonAction(ActionEvent evt) {
        try {
            if (this.submitted) {
                return;
            }
            this.submitted = true;
            this.name = this.NameText.getText();
            this.host = this.HostText.getText();
            if (this.name == null || this.name.length() < 1) {
                JOptionPane.showMessageDialog(null, "You must enter a valid name to proceed", "Input Error", 0);
            } else if (this.host == null || this.host.length() < 1) {
                JOptionPane.showMessageDialog(null, "You must enter a valid host to proceed", "Input Error", 0);
            } else {
                this.box.deposit(this.name);
                this.box.deposit(this.host);
                if (this.ReauthenticateBox.isSelected()) {
                    this.box.deposit("Reauthenticate");
                } else {
                    this.box.deposit("Connect");
                }
                if (this.TestingBox.isSelected()) {
                    this.box.deposit("testing");
                    this.box.deposit(new Long(this.seed));
                } else {
                    this.box.deposit("normal");
                }
                this.setVisible(false);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the client information" + MSConstants.newline + e));
        }
    }

    private void TestingAction(ActionEvent evt) {
        if (this.TestingBox.isSelected()) {
            String seed_str = JOptionPane.showInputDialog(this, (Object)"If desired, enter a seed for the pseudorandom sequence");
            if (seed_str != null && seed_str.length() > 0) {
                try {
                    this.seed = Long.parseLong(seed_str);
                }
                catch (Exception e) {
                    JOptionPane.showConfirmDialog(this, "Please enter a valid number (of type long) for the seed, or no seed at all", "Seed Input Error", 0);
                    this.TestingAction(evt);
                }
            }
            if (seed_str == null || seed_str.length() < 1) {
                this.seed = 0L;
            }
            log.info((Object)("Client has enabled testing mode with seed " + this.seed));
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
    }

    public void run() {
        if (this.host != null) {
            this.HostText.setText(this.host);
            this.HostText.setEnabled(false);
        }
        if (this.name != null) {
            this.NameText.setText(this.name);
            this.NameText.setEnabled(false);
        }
        if (this.mode != null && this.mode.equals("testing")) {
            this.TestingBox.setSelected(true);
        }
        this.setVisible(true);
        if (!this.HostText.isEnabled() && !this.NameText.isEnabled()) {
            this.autoSubmit();
        }
    }

    private synchronized void autoSubmit() {
        try {
            if (!this.itest) {
                this.wait(5000L);
            }
            Runnable doUpdate = new Runnable(){

                public void run() {
                    InitGUI.this.SubmitButtonAction(null);
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

