/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class DicePanel
extends JPanel {
    Image activeImage;
    Image animation;
    Image d1;
    Image d2;
    Image d3;
    Image d4;
    Image d5;
    Image d6;
    public static final String FILESEP = "/";
    private static Category log = Category.getInstance(DicePanel.class);

    public DicePanel() {
        this.loadImages();
        this.startAnimation();
    }

    public DicePanel(int initValue) {
        this.loadImages();
        this.setValue(initValue);
    }

    private void loadImages() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        this.d1 = kit.getImage(this.getClass().getResource("images/DiceGray/d1.gif"));
        this.d2 = kit.getImage(this.getClass().getResource("images/DiceGray/d2.gif"));
        this.d3 = kit.getImage(this.getClass().getResource("images/DiceGray/d3.gif"));
        this.d4 = kit.getImage(this.getClass().getResource("images/DiceGray/d4.gif"));
        this.d5 = kit.getImage(this.getClass().getResource("images/DiceGray/d5.gif"));
        this.d6 = kit.getImage(this.getClass().getResource("images/DiceGray/d6.gif"));
        this.animation = kit.getImage(this.getClass().getResource("images/DiceGray/dice-gray.gif"));
        log.debug((Object)"Dice Panel images successfully loaded");
    }

    public void paint(Graphics g) {
        super.paint(g);
        int panelWidth = this.getWidth();
        int panelHeight = this.getHeight();
        int imageWidth = this.activeImage.getWidth(this);
        int imageHeight = this.activeImage.getHeight(this);
        if (this.activeImage != null) {
            g.drawImage(this.activeImage, (panelWidth - imageWidth) / 2, (panelHeight - imageHeight) / 2, this);
        }
    }

    public void startAnimation() {
        this.activeImage = this.animation;
        this.repaint();
    }

    public void setValue(int dieValue) {
        this.activeImage = dieValue == 1 ? this.d1 : (dieValue == 2 ? this.d2 : (dieValue == 3 ? this.d3 : (dieValue == 4 ? this.d4 : (dieValue == 5 ? this.d5 : (dieValue == 6 ? this.d6 : this.animation)))));
        this.repaint();
    }

    public static void main(String[] args) {
        DicePanel dice = new DicePanel();
        URL url = dice.getClass().getResource("images/DiceGray/d1.gif");
        System.out.println("show URL to d1: " + url);
    }
}

