/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ConnectingWaitingDialog
extends JDialog
implements ActionListener {
    private JPanel TitlePanel;
    private JPanel DataPanel;
    private JLabel NameLabel;
    private String name;
    private String operation;
    private Timer timer;
    private float topx1;
    private float topy1;
    private float topx2;
    private float topy2;
    private float bottomx1;
    private float bottomy1;
    private float bottomx2;
    private float bottomy2;
    private int vertx1;
    private int vertx2;
    private int vert2x1;
    private int vert2x2;
    private int panelHeight;
    private int panelLength;
    private Random rand;
    private boolean movingForward;
    private boolean movingForward2;
    private boolean itest;

    public ConnectingWaitingDialog(Frame parent, boolean modal, String name, boolean itest) {
        super(parent, modal);
        this.itest = itest;
        this.name = name;
        this.initComponents();
        this.NameLabel.setText(name);
        this.operation = "Connecting";
        this.rand = new Random();
        this.initPainter();
        this.setResizable(false);
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.NameLabel = new JLabel();
        this.DataPanel = new JPanel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectingWaitingDialog.this.closeDialog(evt);
            }
        });
        this.TitlePanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 36));
        this.NameLabel.setFont(new Font("Arial Black", 0, 18));
        this.NameLabel.setForeground(Color.black);
        this.NameLabel.setText("Client");
        this.TitlePanel.add(this.NameLabel);
        this.getContentPane().add(this.TitlePanel);
        this.getContentPane().add(this.DataPanel);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ConnectingWaitingDialog((Frame)new JFrame(), true, "Test Client", false).setVisible(true);
    }

    private void initPainter() {
        this.getContentPane().remove(this.DataPanel);
        this.topx1 = 0.0f;
        this.topx2 = 120.0f;
        this.bottomx1 = 150.0f;
        this.bottomx2 = 0.0f;
        this.timer = new Timer(10, this);
        this.timer.start();
        this.DataPanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2d = (Graphics2D)g;
                ConnectingWaitingDialog.this.panelLength = this.getSize().width;
                ConnectingWaitingDialog.this.panelHeight = this.getSize().height;
                g2d.setStroke(new BasicStroke(10.0f));
                GradientPaint topBarPaint = new GradientPaint(ConnectingWaitingDialog.this.topx1, ConnectingWaitingDialog.this.topy1, Color.black, ConnectingWaitingDialog.this.topx2, ConnectingWaitingDialog.this.topy2, Color.blue, true);
                g2d.setPaint(topBarPaint);
                g2d.drawLine(0, 0, ConnectingWaitingDialog.this.panelLength, 0);
                GradientPaint bottomBarPaint = new GradientPaint(ConnectingWaitingDialog.this.bottomx1, ConnectingWaitingDialog.this.bottomy1, Color.black, ConnectingWaitingDialog.this.bottomx2, ConnectingWaitingDialog.this.bottomy2, Color.blue, true);
                g2d.setPaint(bottomBarPaint);
                g2d.drawLine(0, ConnectingWaitingDialog.this.panelHeight, ConnectingWaitingDialog.this.panelLength, ConnectingWaitingDialog.this.panelHeight);
                GradientPaint verticalBarPaint = new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, ConnectingWaitingDialog.this.panelHeight, Color.lightGray, true);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setPaint(verticalBarPaint);
                g2d.drawLine(ConnectingWaitingDialog.this.vertx1, 6, ConnectingWaitingDialog.this.vertx2, ConnectingWaitingDialog.this.panelHeight - 6);
                g2d.drawLine(ConnectingWaitingDialog.this.vert2x1, 6, ConnectingWaitingDialog.this.vert2x2, ConnectingWaitingDialog.this.panelHeight - 6);
                g2d.setPaint(new GradientPaint(50.0f, 0.0f, Color.darkGray, 450.0f, 0.0f, Color.black));
                g2d.setFont(new Font("Arial Black", 0, 22));
                g2d.drawString(ConnectingWaitingDialog.this.operation, 162, 52);
            }
        };
        this.DataPanel.setMinimumSize(new Dimension(450, 100));
        this.DataPanel.setPreferredSize(new Dimension(450, 100));
        this.DataPanel.setMaximumSize(new Dimension(450, 100));
        this.getContentPane().add(this.DataPanel);
        this.pack();
        this.centerOnScreen();
        if (!this.itest) {
            this.setVisible(true);
        }
    }

    public void setConnecting() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ConnectingWaitingDialog.this.setVisible(true);
                ConnectingWaitingDialog.this.operation = "Connecting";
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.repaint();
    }

    public void setInitializing() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ConnectingWaitingDialog.this.setVisible(true);
                ConnectingWaitingDialog.this.operation = "Initializing";
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.repaint();
    }

    public void setInactive() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ConnectingWaitingDialog.this.setVisible(false);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void kill() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ConnectingWaitingDialog.this.setVisible(false);
                ConnectingWaitingDialog.this.timer.stop();
                ConnectingWaitingDialog.this.dispose();
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.topx1 += 2.0f;
        this.topy1 = 0.0f;
        this.topx2 += 2.0f;
        this.topy2 = 0.0f;
        this.bottomx1 += 1.0f;
        this.bottomy1 = this.panelHeight;
        this.bottomx2 += 1.0f;
        this.bottomy2 = this.panelHeight;
        int moveAmount = 11;
        int moveAmount2 = 6;
        if (this.vertx1 > this.panelLength || this.vertx2 > this.panelLength) {
            this.movingForward = false;
            this.vertx1 -= moveAmount;
            this.vertx2 -= moveAmount;
        } else if (this.vertx1 < 0 || this.vertx2 < 0) {
            this.movingForward = true;
            this.vertx1 += moveAmount;
            this.vertx2 += moveAmount;
        } else if (this.movingForward) {
            this.vertx1 += moveAmount;
            this.vertx2 += moveAmount;
        } else {
            this.vertx1 -= moveAmount;
            this.vertx2 -= moveAmount;
        }
        if (this.vert2x1 > this.panelLength || this.vert2x2 > this.panelLength) {
            this.movingForward2 = false;
            this.vert2x1 -= moveAmount2;
            this.vert2x2 -= moveAmount2;
        } else if (this.vert2x1 < 0 || this.vert2x2 < 0) {
            this.movingForward2 = true;
            this.vert2x1 += moveAmount2;
            this.vert2x2 += moveAmount2;
        } else if (this.movingForward2) {
            this.vert2x1 += moveAmount2;
            this.vert2x2 += moveAmount2;
        } else {
            this.vert2x1 -= moveAmount2;
            this.vert2x2 -= moveAmount2;
        }
        this.repaint();
    }
}

