/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.shared.network.ChatMessage;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.log4j.Category;

public class ClientMessagePanel
extends JPanel {
    private JPanel TitlePanel;
    private JLabel TitleLabel;
    private JScrollPane MessageScroller;
    private JTextPane MessageText;
    private DefaultStyledDocument doc;
    protected JTextField InputText;
    private JPanel BottomPanel;
    private JPanel ButtonPanel;
    private JButton SendButton;
    private JComboBox optionList;
    private String identifier;
    private ClientGUI cgui;
    private boolean chatEnabled;
    private boolean optionChat;
    private Vector chatOptions;
    private static Category log = Category.getInstance(ClientMessagePanel.class);

    public ClientMessagePanel(ClientGUI cgui, boolean chatEnabled) {
        this.chatEnabled = chatEnabled;
        this.cgui = cgui;
        this.initComponents();
        this.TitlePanel.setMaximumSize(new Dimension(30000, 40));
        this.TitleLabel.setFont(new Font("Book Antiqua", 1, 14));
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.MessageScroller = new JScrollPane();
        this.doc = new DefaultStyledDocument();
        this.MessageText = new JTextPane(this.doc);
        this.BottomPanel = new JPanel();
        this.ButtonPanel = new JPanel();
        this.InputText = new JTextField();
        this.SendButton = new JButton();
        this.setLayout(new BoxLayout(this, 1));
        if (this.chatEnabled) {
            this.TitleLabel.setText("Messaging");
        } else {
            this.TitleLabel.setText("Received Messages");
        }
        this.TitleLabel.setForeground(Color.black);
        this.TitlePanel.add(this.TitleLabel);
        this.add(this.TitlePanel);
        this.MessageScroller.setPreferredSize(new Dimension(350, 100));
        this.MessageScroller.setMinimumSize(new Dimension(350, 100));
        this.MessageScroller.setViewportView(this.MessageText);
        this.MessageText.setEditable(false);
        StyleContext context = StyleContext.getDefaultStyleContext();
        Style defaultStyle = context.getStyle("default");
        Style adminStyle = this.MessageText.addStyle("admin", defaultStyle);
        StyleConstants.setForeground(adminStyle, Color.blue);
        StyleConstants.setBackground(adminStyle, Color.white);
        StyleConstants.setBold(adminStyle, true);
        Style partnerStyle = this.MessageText.addStyle("partner", defaultStyle);
        StyleConstants.setBold(partnerStyle, true);
        StyleConstants.setForeground(partnerStyle, Color.black);
        Style selfStyle = this.MessageText.addStyle("self", defaultStyle);
        StyleConstants.setBold(selfStyle, true);
        StyleConstants.setForeground(selfStyle, new Color(151, 151, 151));
        this.add(this.MessageScroller);
        this.BottomPanel.setPreferredSize(new Dimension(350, 32));
        this.BottomPanel.setMinimumSize(new Dimension(350, 32));
        this.BottomPanel.setMaximumSize(new Dimension(20000, 32));
        this.BottomPanel.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.BottomPanel.setLayout(new BoxLayout(this.BottomPanel, 0));
        this.BottomPanel.setBackground(Color.white);
        this.InputText.setFont(new Font("Normal", 0, 20));
        this.InputText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String text = ClientMessagePanel.this.InputText.getText();
                    ClientMessagePanel.this.sendMessage();
                }
            }
        });
        this.BottomPanel.add(this.InputText);
        this.SendButton.setText("Send Message");
        this.SendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientMessagePanel.this.sendMessage();
            }
        });
        this.BottomPanel.add(this.SendButton);
        if (this.chatEnabled) {
            this.add(this.BottomPanel);
        }
    }

    public void newRoundAction() {
    }

    public void sentMessageAction(ChatMessage cmes) {
    }

    public void messageReceivedAction() {
    }

    protected void sendMessage() {
        ChatMessage cmes;
        if (this.optionChat) {
            cmes = new ChatMessage((String)this.optionList.getSelectedItem(), this.optionList.getSelectedIndex() - 1, this.cgui.getPartnerNum());
        } else {
            if (!this.validateMessage(this.InputText.getText().trim())) {
                return;
            }
            if (this.InputText.getText().trim().equalsIgnoreCase("")) {
                return;
            }
            cmes = new ChatMessage(this.InputText.getText(), this.cgui.getPartnerNum());
        }
        this.cgui.sendChatMessage(cmes);
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientMessagePanel.this.InputText.setText("");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.sentMessageAction(cmes);
    }

    public void addMessage(String message, String style) {
        try {
            final String mes = message;
            final String fullmessage = message + MSConstants.newline;
            final String sty = style;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    try {
                        ClientMessagePanel.this.doc.insertString(ClientMessagePanel.this.doc.getLength(), fullmessage, ClientMessagePanel.this.MessageText.getStyle(sty));
                        ClientMessagePanel.this.MessageScroller.getVerticalScrollBar().setValue(ClientMessagePanel.this.MessageText.getHeight());
                        log.debug((Object)("Message '" + mes + "' has been fully received by client"));
                    }
                    catch (Exception e) {
                        log.warn((Object)("Malfunction adding message to the client message panel" + MSConstants.newline + e));
                    }
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.warn((Object)("Malfunction when adding a message to the client message panel" + MSConstants.newline + e));
        }
    }

    public void clearText() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientMessagePanel.this.MessageText.setText("");
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void processAdminMessage(String message) {
        this.addMessage("Experimenter: " + message, "admin");
    }

    public void processMessage(ChatMessage cmes) {
        this.messageReceivedAction();
        String style = "partner";
        int source = cmes.getSourcePartnerNum();
        if (source == this.cgui.getPartnerNum()) {
            style = "self";
        }
        String text = (String)cmes.getMessage();
        this.addMessage(this.processIdentifier(source, cmes.getSourcePlayerNum()) + ": " + text, style);
    }

    public String processIdentifier(int source, int player) {
        try {
            int location = this.identifier.indexOf(47);
            if (location < 0) {
                String str = this.identifier.replaceAll("%partner%", "" + source);
                str = str.replaceAll("%partnerPlusOne%", "" + (source + 1));
                str = str.replaceAll("%client%", "" + player);
                str = str.replaceAll("%subject%", "" + (player + 1));
                return str;
            }
            if (source == this.cgui.getPartnerNum()) {
                return this.identifier.substring(0, location);
            }
            return this.identifier.substring(location + 1);
        }
        catch (Exception e) {
            log.warn((Object)"Error processing chat identifier, returning default identifier 'Subject'");
            return new String("Subject " + source);
        }
    }

    public String getText() {
        return this.MessageText.getText();
    }

    public void disableChatting() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (ClientMessagePanel.this.chatEnabled) {
                    ClientMessagePanel.this.chatEnabled = false;
                    ClientMessagePanel.this.TitleLabel.setText("Received Messages");
                    ClientMessagePanel.this.remove(ClientMessagePanel.this.BottomPanel);
                    ClientMessagePanel.this.revalidate();
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void enableChatting(String identifier) {
        if (!this.chatEnabled) {
            this.identifier = identifier != null ? identifier : "Subject";
            this.chatEnabled = true;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientMessagePanel.this.TitleLabel.setText("Messaging");
                    ClientMessagePanel.this.add(ClientMessagePanel.this.BottomPanel);
                    ClientMessagePanel.this.revalidate();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
    }

    public void enableOptionChat(String[] cOptions) {
        this.chatOptions = new Vector();
        this.chatOptions.add(" ");
        if (cOptions != null) {
            for (int i = 0; i < cOptions.length; ++i) {
                this.chatOptions.add(cOptions[i]);
            }
        }
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientMessagePanel.this.optionList = new JComboBox(ClientMessagePanel.this.chatOptions);
                ClientMessagePanel.this.BottomPanel.removeAll();
                ClientMessagePanel.this.BottomPanel.add(ClientMessagePanel.this.optionList);
                ClientMessagePanel.this.SendButton.setEnabled(false);
                ClientMessagePanel.this.BottomPanel.add(ClientMessagePanel.this.SendButton);
                ClientMessagePanel.this.optionList.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        JComboBox vlist = (JComboBox)evt.getSource();
                        String selected = (String)vlist.getSelectedItem();
                        if (selected.trim().length() == 0) {
                            ClientMessagePanel.this.SendButton.setEnabled(false);
                        } else if (ClientMessagePanel.this.optionChat) {
                            ClientMessagePanel.this.SendButton.setEnabled(true);
                        }
                    }
                });
            }
        };
        Runnable resetBox = new Runnable(){

            public void run() {
                ClientMessagePanel.this.optionList.setSelectedIndex(0);
                ClientMessagePanel.this.SendButton.setEnabled(false);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        SwingUtilities.invokeLater(resetBox);
        this.optionChat = true;
    }

    public void disableOptionChatting() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (ClientMessagePanel.this.optionChat) {
                    ClientMessagePanel.this.SendButton.setEnabled(false);
                    ClientMessagePanel.this.optionChat = false;
                    if (ClientMessagePanel.this.optionList != null) {
                        ClientMessagePanel.this.optionList.setSelectedIndex(0);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void enableOptionChatting() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientMessagePanel.this.optionChat = true;
                if (ClientMessagePanel.this.optionList != null) {
                    ClientMessagePanel.this.optionList.setSelectedIndex(0);
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public boolean isOptionChattingEnabled() {
        return this.optionChat;
    }

    public void enableFreeFormChat() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientMessagePanel.this.BottomPanel.removeAll();
                ClientMessagePanel.this.BottomPanel.add(ClientMessagePanel.this.InputText);
                ClientMessagePanel.this.BottomPanel.add(ClientMessagePanel.this.SendButton);
            }
        };
        if (this.optionChat) {
            SwingUtilities.invokeLater(doUpdate);
        }
        this.optionChat = false;
    }

    public void enableChatting() {
        this.enableChatting(null);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public JButton getSendButton() {
        return this.SendButton;
    }

    public JTextPane getMessageText() {
        return this.MessageText;
    }

    public JTextField getInputText() {
        return this.InputText;
    }

    public boolean validateMessage(String mes) {
        return true;
    }
}

