/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.client.control.Client;
import edu.caltech.ssel.multistage.client.interfaces.BarGraphPanel;
import edu.caltech.ssel.multistage.client.interfaces.ClientFinishedDialog;
import edu.caltech.ssel.multistage.client.interfaces.ClientMessagePanel;
import edu.caltech.ssel.multistage.client.interfaces.ClientWaitingPanel;
import edu.caltech.ssel.multistage.client.interfaces.MessageHandler;
import edu.caltech.ssel.multistage.client.interfaces.QuestionDialog;
import edu.caltech.ssel.multistage.client.interfaces.StatPanel;
import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.interfaces.BarGraphUpdate;
import edu.caltech.ssel.multistage.shared.interfaces.ClientHistoryPanel;
import edu.caltech.ssel.multistage.shared.interfaces.StatPanelUpdate;
import edu.caltech.ssel.multistage.shared.network.ChatMessage;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public abstract class ClientGUI
extends JFrame
implements MessageHandler {
    private static Category log = Category.getInstance(ClientGUI.class);
    private int reqType;
    private Mailbox clientOut;
    protected int partnerNum;
    protected ClientHistoryPanel clientHistory = new ClientHistoryPanel("Your History");
    protected ClientMessagePanel clientMessages = new ClientMessagePanel(this, false);
    protected ClientWaitingPanel clientStatus = new ClientWaitingPanel();
    protected ClientFinishedDialog clientFinished;
    protected int groupSize;
    protected boolean testingMode;
    protected Random rand;
    private boolean proceed;
    private boolean endGame;
    private String completionMessage;
    private String finishedPanelMatchLabel;
    private long moveDelay;
    private long confirmDelay;
    private Timer timer;
    private Information info;
    protected Information serverInfo;
    protected ClientData cdata;
    private Hashtable barGraphs = new Hashtable();
    private Hashtable statPanels = new Hashtable();
    private ClientCommunicator com;
    private boolean integratedTest;
    private boolean madeMove;
    private int maximize;
    private boolean close;
    protected boolean optionChat;
    protected String[][] chatOptions;
    protected boolean enableChat;
    protected String chatIdentifier;
    private boolean displayFinishedInfo;

    public ClientGUI() {
        this.clientFinished = new ClientFinishedDialog(this, false);
    }

    public void enableClientGUI() {
        this.timer = new Timer();
        this.testingMode = false;
        this.proceed = false;
        this.endGame = false;
    }

    public void disableClientGUI() {
        this.clientMessages.disableChatting();
    }

    public void setPartnerNum(int partnerNum) {
        this.partnerNum = partnerNum;
    }

    public int getPartnerNum() {
        return this.partnerNum;
    }

    public void setClientHistoryPanel(ClientHistoryPanel clientHistory) {
        this.clientHistory = clientHistory;
    }

    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
    }

    public void setCommunicator(ClientCommunicator com) {
        this.com = com;
    }

    public void setMaximization(int maximize_int) {
        this.maximize = maximize_int;
        Runnable doUpdate = new Runnable(){

            public void run() {
                if (ClientGUI.this.maximize == Client.MAXIMIZE_TRUE && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setExtendedState(6);
                    ClientGUI.this.setResizable(true);
                }
                if (ClientGUI.this.maximize == Client.MAXIMIZE_FALSE && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setExtendedState(0);
                }
                if (ClientGUI.this.maximize == Client.MAXIMIZE_FIXED && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setResizable(false);
                    ClientGUI.this.setExtendedState(6);
                    ClientGUI.this.removeWindowListeners();
                    ClientGUI.this.addWindowStateListener(new WindowAdapter(){

                        public void windowStateChanged(WindowEvent evt) {
                            if (ClientGUI.this.maximize == Client.MAXIMIZE_FIXED && evt.getNewState() != 6) {
                                ClientGUI.this.setExtendedState(6);
                            }
                        }
                    });
                }
                if (ClientGUI.this.maximize == Client.MAXIMIZE_FIXED_NORMAL && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setResizable(false);
                    ClientGUI.this.setExtendedState(0);
                    ClientGUI.this.removeWindowListeners();
                    ClientGUI.this.addWindowStateListener(new WindowAdapter(){

                        public void windowStateChanged(WindowEvent evt) {
                            if (ClientGUI.this.maximize == Client.MAXIMIZE_DISABLED && evt.getNewState() != 0) {
                                ClientGUI.this.setExtendedState(0);
                            }
                        }
                    });
                }
                if (ClientGUI.this.maximize == Client.MAXIMIZE_DISABLED && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setResizable(false);
                    ClientGUI.this.setExtendedState(0);
                    ClientGUI.this.removeWindowListeners();
                }
                if (ClientGUI.this.maximize == Client.MAXIMIZE_FALSE && ClientGUI.this.isVisible()) {
                    ClientGUI.this.setExtendedState(0);
                    ClientGUI.this.setResizable(true);
                    ClientGUI.this.removeWindowListeners();
                }
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void removeWindowListeners() {
        EventListener[] wlisteners = this.getListeners(WindowListener.class);
        if (wlisteners != null) {
            for (int i = 0; i < wlisteners.length; ++i) {
                this.removeWindowListener((WindowListener)wlisteners[i]);
            }
        }
    }

    public void setWindowCloseOperation(boolean close_op) {
        this.close = close_op;
        if (!this.close) {
            super.setDefaultCloseOperation(0);
        }
    }

    public void enableTesting(Random choiceGenerator, long moveDelay, long confirmDelay) {
        this.testingMode = true;
        this.moveDelay = moveDelay;
        this.confirmDelay = confirmDelay;
        this.rand = choiceGenerator;
    }

    public void setIntegratedTesting(boolean integratedTest) {
        this.integratedTest = integratedTest;
    }

    protected boolean addInfo(Object key, Object value) {
        try {
            this.info.addInfo(key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-side information" + MSConstants.newline + e), (Throwable)e);
            return false;
        }
    }

    protected boolean addBooleanInfo(Object key, boolean value) {
        try {
            this.info.addBooleanInfo(key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-side information" + MSConstants.newline + e), (Throwable)e);
            return false;
        }
    }

    protected boolean addFloatInfo(Object key, float value) {
        try {
            this.info.addFloatInfo(key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-side information" + MSConstants.newline + e), (Throwable)e);
            return false;
        }
    }

    protected boolean addIntInfo(Object key, int value) {
        try {
            this.info.addIntInfo(key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-side information" + MSConstants.newline + e), (Throwable)e);
            return false;
        }
    }

    protected boolean addStringInfo(Object key, String value) {
        try {
            this.info.addStringInfo(key, value);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to add client-side information" + MSConstants.newline + e), (Throwable)e);
            return false;
        }
    }

    protected boolean makeMove() {
        if (!this.testingMode) {
            return this.depositMove();
        }
        return false;
    }

    private boolean depositMove() {
        try {
            if (this.info == null) {
                this.info = new Information();
            }
            this.constructWaitingLayout(this.info);
            this.clientOut.deposit("move");
            this.clientOut.deposit(this.info);
            this.madeMove = true;
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to deposit move to client control" + MSConstants.newline + e), (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    private synchronized void makeRandomMove() {
        try {
            try {
                this.testingProcedures();
            }
            catch (Exception e) {
                log.error((Object)("Error when processing the testingProcedures" + MSConstants.newline + e), (Throwable)e);
            }
            TimerTask task = new TimerTask(){

                public void run() {
                    ClientGUI.this.depositMove();
                }
            };
            this.timer.schedule(task, this.moveDelay);
            log.debug((Object)"Client has made a testing mode random choice");
        }
        catch (Exception e) {
            log.error((Object)("Failed to generate a random move" + MSConstants.newline + e), (Throwable)e);
        }
    }

    public void sendChatMessage(ChatMessage cmes) {
        try {
            GameMessage mes = new GameMessage(cmes, 29, this.partnerNum);
            this.com.sendChat(mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a client chat message to the server" + MSConstants.newline + e), (Throwable)e);
        }
    }

    protected void sendMessage(Object obj) {
        try {
            GameMessage mes = new GameMessage(obj, 22, this.partnerNum);
            this.com.sendMessage(mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a client asynchronous message to the server" + MSConstants.newline + e), (Throwable)e);
        }
    }

    protected void sendMessage(Object obj, int type) {
        try {
            GameMessage mes = new GameMessage(obj, type, this.partnerNum);
            this.com.sendMessage(mes);
        }
        catch (Exception e) {
            log.error((Object)("Failed to send a client asynchronous message to the server" + MSConstants.newline + e), (Throwable)e);
        }
    }

    protected void send(Object obj, int type) {
        this.sendMessage(obj, type);
    }

    protected void send(Object obj) {
        this.sendMessage(obj);
    }

    public void setClientOutput(Mailbox clientOut) {
        this.clientOut = clientOut;
    }

    public void createLayout(int reqType, Information info, ClientData clientData) {
        try {
            this.reqType = reqType;
            this.madeMove = false;
            this.info = new Information();
            this.serverInfo = info;
            this.cdata = clientData;
            this.clientMessages.newRoundAction();
            this.updateHistoryPanels(clientData);
            this.updateMetaPayoffInfo();
            if (reqType == 1 || reqType == 4) {
                log.info((Object)"Client has received a standard game request, constructing game-specific layout");
                this.constructLayout(info, clientData);
            }
            if (this.testingMode && (reqType == 1 || reqType == 4)) {
                log.info((Object)"Client is preparing to make a testing mode random choice");
                this.makeRandomMove();
            }
            if (reqType == 2) {
                log.info((Object)"Client has recieved an update-only request, GUI will not be reconstructed");
                this.abortRound();
            }
            if (reqType == 3) {
                this.setEndGameReady();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to create history panels or construct layout for client" + MSConstants.newline + e), (Throwable)e);
        }
    }

    private void abortRound() {
        try {
            this.clientOut.deposit("abort");
            this.constructWaitingLayout(this.info);
        }
        catch (Exception e) {
            log.error((Object)("Client GUI failed to abort round" + MSConstants.newline + e), (Throwable)e);
        }
    }

    private synchronized void setEndGameReady() {
        this.endGame = true;
        this.notifyAll();
    }

    private synchronized void endGame() {
        try {
            while (!this.endGame) {
                this.wait();
            }
            log.debug((Object)"End game received, history windows updated, proceed message for next match sent from CGUI");
            this.proceed = false;
            if (!this.integratedTest && this.displayFinishedInfo) {
                this.clientFinished.activate(this.cdata.getLastMatchPayoffExchanged(), this.cdata.getTotalPayoffExchanged(), this.finishedPanelMatchLabel, this.completionMessage, this.cdata.isPracticeLastMatch());
            }
            TimerTask task = new TimerTask(){

                public void run() {
                    Runnable doUpdate = new Runnable(){

                        public void run() {
                            try {
                                ClientGUI.this.clientFinished.setVisible(false);
                                ClientGUI.this.clientFinished.dispose();
                            }
                            catch (NullPointerException e) {
                                log.info((Object)"ClientFinishedDialog manually closed by user");
                            }
                        }
                    };
                    SwingUtilities.invokeLater(doUpdate);
                    ClientGUI.this.proceed();
                }
            };
            if (!this.displayFinishedInfo) {
                this.proceed();
            } else if (this.testingMode && this.confirmDelay >= 0L) {
                this.timer.schedule(task, this.confirmDelay);
            }
            while (!this.proceed) {
                this.wait();
            }
            log.debug((Object)"Client has proceeded after closure of ClientFinishedDialog");
            this.clientOut.deposit("proceed");
            log.debug((Object)"Client has deposited 'proceed' message in client internal mailbox");
        }
        catch (Exception e) {
            log.error((Object)("Failed to end the game over the GUI interface" + MSConstants.newline + e), (Throwable)e);
            e.printStackTrace();
            try {
                this.clientOut.deposit("proceed");
            }
            catch (Exception ex) {
                log.error((Object)("Failed to send safety proceed message to client controller" + MSConstants.newline + ex));
            }
        }
    }

    public synchronized void proceed() {
        try {
            log.debug((Object)"Client has pressed the continue button on the Match Finished Dialog");
            this.proceed = true;
            this.notifyAll();
            log.debug((Object)"Client has notified waiting threads to proceed");
        }
        catch (Exception e) {
            log.error((Object)"Failed to notify threads to proceed to next match -- Match Finished Dialog closed", (Throwable)e);
        }
    }

    public void updateMessagingPanel(boolean enableChat, String chatIdentifier, boolean optionChat, String[][] chatOptions) {
        this.enableChat = enableChat;
        this.chatIdentifier = chatIdentifier;
        this.optionChat = optionChat;
        this.chatOptions = chatOptions;
        if (enableChat) {
            this.clientMessages.enableChatting(chatIdentifier);
            if (optionChat) {
                this.clientMessages.enableOptionChat(chatOptions[this.partnerNum]);
            } else {
                this.clientMessages.enableFreeFormChat();
            }
        } else {
            this.clientMessages.disableChatting();
        }
    }

    public void updateHistoryPanels(ClientData clientData) {
        try {
            this.clientHistory.rebuild(clientData);
            log.debug((Object)"Constructed client history panel");
        }
        catch (Exception e) {
            log.error((Object)("Failed to construct the history panel " + MSConstants.newline + e), (Throwable)e);
        }
    }

    public void processMessage(MessagePacket mes) {
        try {
            log.debug((Object)("ClientGUI is processing message of type " + mes.getType()));
            if (mes.getType() == 23 && !this.madeMove && this.reqType != 3) {
                System.out.println(" >>> " + this.partnerNum + " received dummy req " + " madeMove " + this.madeMove + " reqType " + this.reqType);
                this.depositMove();
            }
            if (mes.getType() == 26) {
                this.endGame();
                this.updateMetaPayoffInfo();
            }
            if (mes.getType() == 27) {
                this.abortRound();
            }
            if (mes.getType() == 29) {
                this.clientMessages.processMessage((ChatMessage)mes.getObject());
            }
            if (mes.getType() == 3) {
                this.clientStatus.setMessage(mes.getMessage());
            }
            if (mes.getType() == 2) {
                this.clientMessages.processAdminMessage(mes.getMessage());
            }
            if (mes.getType() == 4) {
                this.completionMessage = mes.getMessage();
            }
            if (mes.getType() == 20) {
                this.displayMessage((Object[])mes.getObject());
            }
            if (mes.getType() == 25) {
                this.displayQuestionDialog((Object[])mes.getObject());
            }
            if (mes.getType() == 28) {
                this.alterHistoryLabels((Vector)mes.getObject());
            }
            if (mes.getType() == 7) {
                this.updateBarGraph((BarGraphUpdate)mes.getObject());
            }
            if (mes.getType() == 8) {
                this.updateStatPanel((StatPanelUpdate)mes.getObject());
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process message received from server" + MSConstants.newline + e), (Throwable)e);
        }
    }

    public void displayMessage(Object[] info) {
        this.displayMessage((String)info[0], info[1], (String)info[2]);
    }

    public void displayMessage(String title, Object message, String buttonText) {
        try {
            Object[] option = new Object[]{buttonText};
            if (!this.testingMode) {
                JOptionPane.showOptionDialog(this, message, title, 0, -1, null, option, null);
            }
            this.sendMessage(null, 24);
        }
        catch (Exception e) {
            log.error((Object)("Failed to close the round info dialog" + MSConstants.newline + e), (Throwable)e);
        }
    }

    public void displayQuestionDialog(Object[] qPacket) {
        try {
            String titleText = (String)qPacket[0];
            String submitText = (String)qPacket[1];
            int timeLimit = (Integer)qPacket[2];
            Vector questions = (Vector)qPacket[3];
            QuestionDialog qd = new QuestionDialog(this, true, this.testingMode, timeLimit, titleText, submitText);
            qd.addQuestions(questions);
            qd.display();
            Vector answers = qd.getQuestions();
            this.sendMessage(answers, 34);
        }
        catch (Exception e) {
            log.error((Object)("Failed to open/close the question dialog box" + MSConstants.newline + e), (Throwable)e);
        }
    }

    protected void alterHistoryLabels(String matchStr, String totalStr, String matchTotalStr, String practiceMatchStr, String normalMatchStr) {
        if (matchStr.length() > 0) {
            this.clientHistory.setMatchStr(matchStr);
            this.finishedPanelMatchLabel = matchStr;
        }
        if (totalStr.length() > 0) {
            this.clientHistory.setTotalStr(totalStr);
        }
        if (matchTotalStr.length() > 0) {
            this.clientHistory.setMatchTotalStr(matchTotalStr);
        }
        if (practiceMatchStr.length() > 0) {
            this.clientHistory.setPracticeMatchStr(practiceMatchStr);
        }
        if (normalMatchStr.length() > 0) {
            this.clientHistory.setNormalMatchStr(normalMatchStr);
        }
    }

    private void alterHistoryLabels(Vector transmit) {
        this.alterHistoryLabels((String)transmit.get(0), (String)transmit.get(1), (String)transmit.get(2), (String)transmit.get(3), (String)transmit.get(4));
    }

    public void updateMetaPayoffInfo() {
    }

    protected void updateHistory(int roundNum, String columnName, String value) {
        this.cdata.addColumnData(this.cdata.getCurrentMatch(), roundNum, columnName, value, null);
        this.clientHistory.rebuild(this.cdata);
    }

    protected void updateHistory(String columnName, String value) {
        this.cdata.addColumnData(this.cdata.getCurrentMatch(), this.cdata.getCurrentRound(), columnName, value, null);
        this.clientHistory.rebuild(this.cdata);
    }

    public void centerOnScreen() {
        Runnable doUpdate = new Runnable(){

            public void run() {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension window = ClientGUI.this.getSize();
                int iCenterX = screen.width / 2;
                int iCenterY = screen.height / 2;
                ClientGUI.this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    protected Dimension relativeSize(float widthMultiple, float heightMultiple) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)((float)screen.width * widthMultiple);
        int height = (int)((float)screen.height * heightMultiple);
        Dimension dim = new Dimension(width, height);
        return dim;
    }

    public ClientMessagePanel getMessagePanel() {
        return this.clientMessages;
    }

    public ClientHistoryPanel getClientHistoryPanel() {
        return this.clientHistory;
    }

    public abstract void initialize();

    protected abstract void constructLayout(Information var1, ClientData var2);

    protected abstract void constructWaitingLayout(Information var1);

    public abstract void testingProcedures();

    public abstract void respond(Object var1);

    public abstract void close();

    public abstract void reauthenticate();

    protected String parseString(String orig) {
        try {
            String[] splitString;
            if (orig == null) {
                log.warn((Object)"Attempted to parse a NULL string on client-side");
                return "";
            }
            String finalStr = orig;
            while ((splitString = finalStr.split("%", 3)).length > 2) {
                Object match;
                String prefix = splitString[0];
                String prm = splitString[1];
                String suffix = splitString[2];
                String replacement = null;
                Hashtable varMap = null;
                if (prm.equalsIgnoreCase("id")) {
                    replacement = "" + (this.cdata.getId() + 1);
                }
                if (prm.equalsIgnoreCase("groupSize")) {
                    replacement = "" + this.groupSize;
                }
                if (prm.equalsIgnoreCase("partnerNum")) {
                    replacement = "" + this.partnerNum;
                }
                if (this.serverInfo != null) {
                    varMap = this.serverInfo.getTable();
                }
                if (varMap != null && (match = varMap.get(prm)) != null) {
                    replacement = "" + match;
                }
                if (replacement == null) {
                    replacement = "_temp_" + prm + "_temp_";
                }
                if (prefix.endsWith("\\")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                    replacement = "_temp_" + prm + "%";
                }
                finalStr = prefix + replacement + suffix;
            }
            finalStr = finalStr.replaceAll("_temp_", "%");
            log.debug((Object)("Parsed string '" + orig + "' on client-side into string '" + finalStr + "'"));
            return finalStr;
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse the string " + orig + " for variable substitutions. Returning un-parsed string" + MSConstants.newline + e));
            e.printStackTrace();
            return orig;
        }
    }

    protected StatPanel createStatPanel(String name) {
        StatPanel sPanel = new StatPanel();
        this.statPanels.put(name, sPanel);
        return sPanel;
    }

    protected void updateStatPanel(String name, String[] rowLabels, String[] colLabels, String[][] data) {
        StatPanel sPanel = (StatPanel)this.statPanels.get(name);
        if (sPanel == null) {
            log.warn((Object)"Attempting to update a NULL stat panel! Update aborted");
            return;
        }
        sPanel.setData(data);
        sPanel.setRowLabels(rowLabels);
        sPanel.setColumnLabels(colLabels);
        sPanel.updateStatData();
    }

    protected void updateStatPanel(StatPanelUpdate update) {
        this.updateStatPanel(update.name, update.rowLabels, update.colLabels, update.data);
    }

    protected BarGraphPanel createBarGraph(String name) {
        BarGraphPanel bgraph = new BarGraphPanel();
        this.barGraphs.put(name, bgraph);
        return bgraph;
    }

    protected void updateBarGraph(String name, String title, String caption, String[] labels, float[] values, float ymaximum, int formatType) {
        BarGraphPanel bgraph = (BarGraphPanel)this.barGraphs.get(name);
        if (bgraph == null) {
            log.warn((Object)"Attempting to update a NULL bar graph! Update aborted");
            return;
        }
        bgraph.setTitle(title);
        bgraph.setCaption(caption);
        bgraph.setLabels(labels);
        bgraph.setValues(values);
        bgraph.setMaximum(ymaximum);
        bgraph.setFormatType(formatType);
    }

    protected void updateBarGraph(BarGraphUpdate update) {
        this.updateBarGraph(update.name, update.title, update.caption, update.labels, update.values, update.ymaximum, update.formatType);
    }

    public void destroy() {
        try {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientGUI.this.removeAll();
                    EventListener[] list = ClientGUI.this.getListeners(WindowListener.class);
                    for (int i = 0; i < list.length; ++i) {
                        WindowListener l = (WindowListener)list[i];
                        ClientGUI.this.removeWindowListener(l);
                    }
                    ClientGUI.this.clientFinished = null;
                    ClientGUI.this.clientHistory = null;
                    ClientGUI.this.statPanels = null;
                    ClientGUI.this.barGraphs = null;
                    ClientGUI.this.clientMessages = null;
                    ClientGUI.this.close();
                    ClientGUI.this.dispose();
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)("Failed to destroy the Client GUI" + MSConstants.newline + e), (Throwable)e);
        }
    }

    public void exit() {
        if (this.close) {
            System.exit(0);
        }
    }

    protected void finalize() {
        log.info((Object)"The ClientGUI for a previous match has been destroyed and freed from memory");
    }

    public void setVisible() {
        if (!this.integratedTest) {
            super.setVisible(true);
            this.setMaximization(this.maximize);
        }
    }

    public void setVisible(boolean visible) {
        if (!this.integratedTest) {
            super.setVisible(visible);
            if (visible) {
                this.setMaximization(this.maximize);
            }
        }
    }

    public void pack() {
        if (this.getExtendedState() == 6) {
            super.pack();
            this.setExtendedState(6);
        } else {
            super.pack();
        }
    }

    protected void minPack() {
        if (this.maximize == Client.MAXIMIZE_FIXED) {
            this.validate();
            this.repaint();
            return;
        }
        super.pack();
    }

    public void setDefaultCloseOperation(int operation) {
    }

    public void setDisplayFinishedInfo(boolean displayFinishedInfo) {
        this.displayFinishedInfo = displayFinishedInfo;
    }

    public long getConfirmDelay() {
        return this.confirmDelay;
    }
}

