/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ClientFinishedDialog
extends JDialog {
    private JPanel LabelPanel;
    private JLabel TitleLabel;
    private JLabel MatchPayoffLabel;
    private JLabel TotalPayoffLabel;
    private JScrollPane TestScroller;
    private JTextArea InfoText;
    private JPanel ButtonPanel;
    private JButton OKButton;
    private String matchPayoffStr = "Match Payoff:";
    private ClientGUI parent;

    public ClientFinishedDialog(ClientGUI parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.centerOnScreen();
    }

    public void activate(float matchPayoff, float totalPayoff, String matchLabel, String completionMessage, boolean practice) {
        if (matchLabel != null) {
            String txt = null;
            txt = practice ? "Practice " + matchLabel + " Complete" : matchLabel + " Complete";
            final String text = txt;
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientFinishedDialog.this.TitleLabel.setText(text);
                    ClientFinishedDialog.this.TitleLabel.setForeground(new Color(16, 120, 11));
                    ClientFinishedDialog.this.TitleLabel.setFont(new Font("Arial Black", 0, 16));
                }
            };
            SwingUtilities.invokeLater(doUpdate);
            this.matchPayoffStr = matchLabel + " Payoff:";
        } else if (practice) {
            Runnable doUpdate = new Runnable(){

                public void run() {
                    ClientFinishedDialog.this.TitleLabel.setText("Practice Match Complete");
                    ClientFinishedDialog.this.TitleLabel.setForeground(new Color(16, 120, 11));
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }
        this.showPayoff(matchPayoff, totalPayoff);
        final String cmes = completionMessage;
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientFinishedDialog.this.InfoText.setEditable(false);
                ClientFinishedDialog.this.InfoText.append(cmes);
                ClientFinishedDialog.this.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    private void initComponents() {
        this.LabelPanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.MatchPayoffLabel = new JLabel();
        this.TotalPayoffLabel = new JLabel();
        this.TestScroller = new JScrollPane();
        this.InfoText = new JTextArea();
        this.ButtonPanel = new JPanel();
        this.OKButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ClientFinishedDialog.this.closeDialog(evt);
            }
        });
        this.LabelPanel.setLayout(new GridLayout(3, 0));
        this.TitleLabel.setText("Match Complete");
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setHorizontalAlignment(0);
        this.TitleLabel.setFont(new Font("Arial Black", 0, 18));
        this.LabelPanel.add(this.TitleLabel);
        this.MatchPayoffLabel.setText("Match Payoff:");
        this.MatchPayoffLabel.setForeground(new Color(146, 34, 39));
        this.MatchPayoffLabel.setHorizontalAlignment(0);
        this.MatchPayoffLabel.setFont(new Font("Arial Black", 0, 14));
        this.LabelPanel.add(this.MatchPayoffLabel);
        this.TotalPayoffLabel.setText("Total Payoff:");
        this.TotalPayoffLabel.setForeground(new Color(151, 36, 49));
        this.TotalPayoffLabel.setHorizontalAlignment(0);
        this.TotalPayoffLabel.setFont(new Font("Arial Black", 0, 14));
        this.LabelPanel.add(this.TotalPayoffLabel);
        this.getContentPane().add(this.LabelPanel);
        this.TestScroller.setPreferredSize(new Dimension(250, 200));
        this.TestScroller.setMinimumSize(new Dimension(250, 200));
        this.TestScroller.setMaximumSize(new Dimension(250, 200));
        this.InfoText.setBackground(new Color(204, 204, 204));
        this.TestScroller.setViewportView(this.InfoText);
        this.getContentPane().add(this.TestScroller);
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientFinishedDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.ButtonPanel.add(this.OKButton);
        this.getContentPane().add(this.ButtonPanel);
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.parent.proceed();
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.parent.proceed();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
    }

    public void showPayoff(float mPayoff, float tPayoff) {
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        formatter.setMinimumFractionDigits(2);
        DecimalFormat dformatter = (DecimalFormat)formatter;
        dformatter.setNegativePrefix(" -" + formatter.getCurrency().getSymbol());
        dformatter.setNegativeSuffix("");
        final String strTotalPayoff = dformatter.format(tPayoff);
        final String strMatchPayoff = dformatter.format(mPayoff);
        Runnable doUpdate = new Runnable(){

            public void run() {
                ClientFinishedDialog.this.MatchPayoffLabel.setText(ClientFinishedDialog.this.matchPayoffStr + strMatchPayoff);
                ClientFinishedDialog.this.TotalPayoffLabel.setText("Total Payoff: " + strTotalPayoff);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
    }

    public void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        int iCenterX = screen.width / 2;
        int iCenterY = screen.height / 2;
        this.setLocation(iCenterX - window.width / 2, iCenterY - window.height / 2);
    }
}

