/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.interfaces;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class BarGraphPanel
extends JPanel {
    private JPanel TitlePanel;
    private JPanel CaptionPanel;
    private JLabel TitleLabel;
    private JPanel DataPanel;
    private JLabel CaptionLabel;
    private String[] xLabels;
    private float[] values;
    private float ymax;
    private int formatType;

    public BarGraphPanel() {
        this.initComponents();
        this.initDataPanel();
        this.setBorder(new LineBorder(Color.black));
        this.formatType = 2;
    }

    private void initComponents() {
        this.TitlePanel = new JPanel();
        this.TitleLabel = new JLabel();
        this.DataPanel = new JPanel();
        this.CaptionPanel = new JPanel();
        this.CaptionLabel = new JLabel();
        this.setLayout(new BoxLayout(this, 1));
        this.TitlePanel.setMaximumSize(new Dimension(32000, 32));
        this.TitleLabel.setFont(new Font("Arial Black", 0, 15));
        this.TitleLabel.setForeground(Color.black);
        this.TitleLabel.setText("History Bar Graph");
        this.TitleLabel.setMaximumSize(new Dimension(32760, 22));
        this.TitlePanel.add(this.TitleLabel);
        this.add(this.TitlePanel);
        this.DataPanel.setPreferredSize(new Dimension(400, 250));
        this.add(this.DataPanel);
        this.CaptionPanel.setMaximumSize(new Dimension(32000, 31));
        this.CaptionLabel.setFont(new Font("Arial Black", 0, 14));
        this.CaptionLabel.setForeground(Color.black);
        this.CaptionLabel.setText("Graph Values");
        this.CaptionPanel.add(this.CaptionLabel);
        this.add(this.CaptionPanel);
    }

    private void initDataPanel() {
        this.ymax = 100.0f;
        this.DataPanel = new JPanel(){

            public void paint(Graphics g) {
                super.paint(g);
                if (BarGraphPanel.this.values == null || BarGraphPanel.this.xLabels == null || BarGraphPanel.this.values.length < 1 || BarGraphPanel.this.xLabels.length < 1) {
                    return;
                }
                int offset = 46;
                Graphics2D g2d = (Graphics2D)g;
                int panelLength = this.getSize().width - offset;
                int panelHeight = this.getSize().height - 15;
                int numBars = Math.min(BarGraphPanel.this.xLabels.length, BarGraphPanel.this.values.length);
                double barTotal = panelLength / numBars;
                double barGap = 0.1 * barTotal;
                double barWidth = 0.8 * barTotal;
                if (barTotal > 40.0) {
                    barGap = (barTotal - 32.0) / 2.0;
                    barWidth = 32.0;
                }
                double valueHeight = ((double)panelHeight - 20.0) / (double)BarGraphPanel.this.ymax;
                double[] barHeight = new double[numBars];
                for (int i = 0; i < numBars; ++i) {
                    barHeight[i] = (double)BarGraphPanel.this.values[i] * valueHeight;
                }
                g2d.setPaint(Color.blue);
                Vector<Color> colors = new Vector<Color>();
                colors.add(Color.blue);
                colors.add(Color.red);
                colors.add(Color.green);
                int colorIndex = 0;
                for (int i = 0; i < numBars; ++i) {
                    if (++colorIndex >= colors.size()) {
                        colorIndex = 0;
                    }
                    GradientPaint paint = new GradientPaint((float)((double)i * barTotal + barGap + (double)offset), (float)((double)panelHeight - barHeight[i]), (Color)colors.get(colorIndex), (float)((double)i * barTotal + barGap + barWidth), panelHeight, Color.black, true);
                    g2d.setPaint(paint);
                    Rectangle bar = new Rectangle((int)((double)i * barTotal + barGap + (double)offset), (int)((double)panelHeight - barHeight[i]), (int)barWidth, (int)barHeight[i]);
                    g2d.fill(bar);
                    g2d.setPaint(Color.black);
                    g2d.setFont(new Font("Arial Black", 0, 12));
                    g2d.drawString(BarGraphPanel.this.xLabels[i], (int)((double)i * barTotal + barTotal / 2.0 - 3.0 + (double)offset), panelHeight + 10);
                }
                g2d.setPaint(Color.black);
                g2d.drawLine(offset, panelHeight, panelLength + offset - 7, panelHeight);
                g2d.drawLine(offset, panelHeight, offset, 0);
                float inc = BarGraphPanel.this.ymax / 5.0f;
                NumberFormat formatter = BarGraphPanel.this.getFormatter();
                for (int i = 1; i < 6; ++i) {
                    float label = inc * (float)i;
                    float yposition = (float)((double)panelHeight - valueHeight * (double)label);
                    g2d.setPaint(Color.blue);
                    g2d.setFont(new Font("Arial", 0, 12));
                    g2d.drawString(formatter.format(label), 8.0f, yposition + 5.0f);
                    g2d.setPaint(Color.red);
                    g2d.drawLine(offset, (int)yposition, panelLength + offset - 7, (int)yposition);
                }
            }
        };
        this.remove(1);
        this.add((Component)this.DataPanel, 1);
    }

    public void setLabels(String[] xLabels) {
        this.xLabels = xLabels;
        this.repaint();
    }

    public void setValues(float[] values) {
        this.values = values;
        this.repaint();
    }

    public void setMaximum(float ymax) {
        this.ymax = ymax;
        this.repaint();
    }

    public void setTitle(String title) {
        final String t = title;
        Runnable doUpdate = new Runnable(){

            public void run() {
                BarGraphPanel.this.TitleLabel.setText(t);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.repaint();
    }

    public void setCaption(String caption) {
        final String cap = caption;
        Runnable doUpdate = new Runnable(){

            public void run() {
                BarGraphPanel.this.CaptionLabel.setText(cap);
            }
        };
        SwingUtilities.invokeLater(doUpdate);
        this.repaint();
    }

    public void setFormatType(int type) {
        this.formatType = type;
    }

    private NumberFormat getFormatter() {
        if (this.formatType == 0) {
            return new DecimalFormat("#####\u00a2");
        }
        if (this.formatType == 1) {
            return NumberFormat.getCurrencyInstance();
        }
        return new DecimalFormat("#########.##");
    }
}

