/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.control;

import edu.caltech.ssel.multistage.client.control.Client;
import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.shared.network.GameMessage;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.util.Vector;
import org.apache.log4j.Category;

public class MessageReceiver
implements Runnable {
    private static Category log = Category.getInstance(MessageReceiver.class);
    private ClientCommunicator com;
    private ClientGUI cgui;
    private boolean die;
    private boolean hold;
    private Client client;
    private Vector heldMessages;

    public MessageReceiver(ClientCommunicator com, Client client) {
        this.client = client;
        this.com = com;
        this.die = false;
        this.hold = false;
        this.heldMessages = new Vector();
    }

    public void run() {
        log.info((Object)"Client Message receiver has been initialized");
        while (!this.die) {
            try {
                MessagePacket mes = this.com.getMessage();
                log.debug((Object)("MessageReceiver has received a message of type " + mes.getType()));
                if (mes.getType() == 33) {
                    log.debug((Object)"Client message receiver has shut down");
                    break;
                }
                if (mes.getSource() == -1) {
                    this.client.processMessage(mes);
                } else if (this.hold || this.cgui == null) {
                    this.heldMessages.add(mes);
                    log.warn((Object)("A message of type " + mes.getType() + " has been held in the MessageReceiver: will be dumped at beginning of next match"));
                } else if (mes.getSource() == -2) {
                    this.cgui.processMessage(mes);
                } else if (mes.getSource() == -3 && mes.getObject() != null) {
                    this.cgui.respond(mes.getObject());
                } else {
                    this.cgui.respond(mes.getMessage());
                }
            }
            catch (Exception e) {
                log.error((Object)("Client message receiver has malfunctioned" + MSConstants.newline + e));
                e.printStackTrace();
            }
            Thread.yield();
        }
    }

    public void holdMessages() {
        this.hold = true;
    }

    public void flushMessages() {
        this.hold = false;
        for (int i = 0; i < this.heldMessages.size(); ++i) {
            MessagePacket mes = (MessagePacket)this.heldMessages.get(i);
            if (mes.getSource() != -2) continue;
            this.cgui.processMessage(mes);
        }
        this.heldMessages = new Vector();
    }

    public void close() {
        try {
            this.com.sendInternalMessage(new GameMessage(null, 33, -1));
            this.die = true;
        }
        catch (Exception e) {
            log.error((Object)"Failed to close down the client-side Message Receiver", (Throwable)e);
        }
    }

    public void setClientGui(ClientGUI cgui) {
        this.cgui = cgui;
    }
}

