/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.control;

import edu.caltech.ssel.multistage.client.control.ChatReceiver;
import edu.caltech.ssel.multistage.client.control.MessageReceiver;
import edu.caltech.ssel.multistage.client.control.NameBank;
import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.client.interfaces.InitGUI;
import edu.caltech.ssel.multistage.client.interfaces.QuestionDialog;
import edu.caltech.ssel.multistage.client.network.ClientAuthenticator;
import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.client.network.MailClientAuthenticator;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.ClientUpdate;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.interfaces.ClientHistoryPanel;
import edu.caltech.ssel.multistage.shared.interfaces.WaitingDialog;
import edu.caltech.ssel.multistage.shared.network.GameRequest;
import edu.caltech.ssel.multistage.shared.network.GameResponse;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.Mailbox;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import edu.caltech.ssel.multistage.shared.network.QueuedMailbox;
import edu.caltech.ssel.multistage.shared.network.RequestPacket;
import edu.caltech.ssel.multistage.shared.network.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Category;

public class Client
implements MSConstants,
Runnable {
    private static Category log = Category.getInstance(Client.class);
    private ClientAuthenticator auth;
    private ClientCommunicator com;
    private boolean reauthenticating;
    protected String host;
    protected String name;
    private int id;
    protected ClientGUI clientGui;
    private String gameType;
    protected int partnerNum;
    protected int groupSize;
    private Mailbox clientIn;
    private MessageReceiver mReceiver;
    private ChatReceiver cReceiver;
    public boolean testingMode;
    public Random choiceGenerator;
    private String mode;
    private String seed;
    private String naming;
    private long moveDelay;
    private long confirmDelay;
    private ClientData cdata;
    private WaitingDialog connectFrame;
    private boolean integratedTest;
    private boolean closeWindow;
    private int maximize;
    private boolean readyForExit;
    private String serializePath;
    private static String sep = System.getProperty("file.separator");
    public static int MAXIMIZE_FIXED = 0;
    public static int MAXIMIZE_TRUE = 1;
    public static int MAXIMIZE_FALSE = 2;
    public static int MAXIMIZE_DISABLED = 3;
    public static int MAXIMIZE_FIXED_NORMAL = 4;
    public static int INPUT_STATE = 0;
    public static int OUTPUT_STATE = 1;
    public static int SHUTDOWN_STATE = 2;

    public Client(String name, String host) {
        this.name = name;
        this.host = host;
        this.moveDelay = 0L;
        this.confirmDelay = 0L;
    }

    public Client(boolean integratedTest, int seed) {
        this.integratedTest = integratedTest;
        this.host = "localhost";
        this.mode = "testing";
        this.naming = "random";
        this.seed = "" + seed;
        this.moveDelay = 0L;
        this.confirmDelay = 0L;
        this.maximize = MAXIMIZE_FALSE;
        this.closeWindow = true;
    }

    public Client() {
        this.readProperties();
    }

    private void readProperties() {
        block22: {
            try {
                String resource = "mult-client.properties";
                URL multiConfig = ClassLoader.getSystemResource(resource);
                this.moveDelay = 0L;
                this.confirmDelay = 0L;
                this.maximize = MAXIMIZE_FALSE;
                Random rand = new Random();
                if (multiConfig == null) {
                    log.warn((Object)"Could not find multistage.properties file, using default configuration");
                    break block22;
                }
                Properties props = new Properties();
                props.load(multiConfig.openStream());
                log.info((Object)"Loaded multistage.properties file, reading configuration information");
                String host = props.getProperty("defaultHost");
                String mode = props.getProperty("defaultMode");
                String seed = props.getProperty("defaultSeed");
                String naming = props.getProperty("naming");
                String moveDelayStr = props.getProperty("moveDelay");
                String confirmDelayStr = props.getProperty("confirmDelay");
                String maximizeStr = props.getProperty("maximize");
                String closeStr = props.getProperty("allowClose");
                String serializePath = props.getProperty("serializePath");
                if (host != null) {
                    this.host = host;
                }
                if (mode != null) {
                    this.mode = mode;
                }
                if (seed != null) {
                    this.seed = seed;
                }
                if (naming != null) {
                    this.naming = naming;
                }
                if (serializePath != null) {
                    this.serializePath = serializePath;
                }
                if (moveDelayStr != null && moveDelayStr.length() > 0) {
                    try {
                        this.moveDelay = Long.parseLong(moveDelayStr);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to parse move delay number" + MSConstants.newline + e));
                    }
                }
                if (confirmDelayStr != null && confirmDelayStr.length() > 0) {
                    try {
                        if (confirmDelayStr.equals("random")) {
                            this.confirmDelay = rand.nextInt(4000);
                            log.debug((Object)("Client will be using a randomly generated confirm delay of " + this.confirmDelay + " seconds"));
                        } else {
                            this.confirmDelay = Long.parseLong(confirmDelayStr);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to parse confirm delay number" + MSConstants.newline + e));
                    }
                }
                if (maximizeStr != null && maximizeStr.length() > 0) {
                    if (maximizeStr.equalsIgnoreCase("fixed")) {
                        this.maximize = MAXIMIZE_FIXED;
                    }
                    if (maximizeStr.equalsIgnoreCase("true")) {
                        this.maximize = MAXIMIZE_TRUE;
                    }
                    if (maximizeStr.equalsIgnoreCase("false")) {
                        this.maximize = MAXIMIZE_FALSE;
                    }
                    if (maximizeStr.equalsIgnoreCase("disabled")) {
                        this.maximize = MAXIMIZE_DISABLED;
                    }
                    if (maximizeStr.equalsIgnoreCase("fixed_normal")) {
                        this.maximize = MAXIMIZE_FIXED_NORMAL;
                    }
                }
                this.closeWindow = closeStr == null || !closeStr.equalsIgnoreCase("false");
            }
            catch (Exception e) {
                log.fatal((Object)("Failed to instantiate a client through reading the configuration file (if one existed)" + MSConstants.newline + e), (Throwable)e);
            }
        }
    }

    public void run() {
        log.debug((Object)"Client initialized -- getting name and host information...");
        this.getClientInfo();
        this.auth = new MailClientAuthenticator(this.host, this.name);
        if (this.reauthenticating) {
            boolean reconnected = this.auth.reconnect();
            if (!reconnected) {
                this.auth.close();
            } else {
                this.com = this.auth.getCommunicator();
                this.initialize();
                this.runStateMachine();
            }
        } else if (this.auth.connect()) {
            this.com = this.auth.getCommunicator();
            this.initialize();
            this.runStateMachine();
        } else {
            this.connectFrame.setCountdown("Connection rejected, closing in:", 5);
            this.connectFrame.setInactive();
        }
    }

    private void getClientInfo() {
        try {
            QueuedMailbox initBox = new QueuedMailbox(2);
            if (this.naming != null && this.naming.equals("random")) {
                NameBank names = new NameBank();
                this.name = names.getRandomName();
            }
            if (this.naming != null && this.naming.equals("username")) {
                this.name = System.getProperty("user.name");
            }
            InitGUI init = new InitGUI(initBox, this.name, this.host, this.mode, this.seed, this.integratedTest);
            Thread guiInit = new Thread(init);
            guiInit.start();
            log.debug((Object)"Client receiving host and name from InitGUI");
            this.name = (String)initBox.receive();
            this.host = (String)initBox.receive();
            String connectionType = (String)initBox.receive();
            String mode = (String)initBox.receive();
            this.connectFrame = new WaitingDialog(null, false, this.name, false, this.integratedTest);
            this.connectFrame.setActive("Please Wait", "Connecting to Server");
            if (connectionType.equals("Reauthenticate")) {
                this.reauthenticating = true;
            } else if (connectionType.equals("Connect")) {
                this.reauthenticating = false;
            }
            if (mode.equals("normal")) {
                this.testingMode = false;
            } else if (mode.equals("testing")) {
                this.testingMode = true;
                long seed = (Long)initBox.receive();
                if (seed != 0L) {
                    log.debug((Object)("Client is using seed " + seed + " for testing mode"));
                    this.choiceGenerator = new Random(seed);
                } else {
                    this.choiceGenerator = new Random();
                }
            }
            log.info((Object)("Client has received name: " + this.name + " and host: " + this.host + " and is trying to " + connectionType + " in " + mode + " mode"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to receive client host and name from InitGUI" + newline + e), (Throwable)e);
        }
    }

    private void initialize() {
        try {
            this.connectFrame.setActive("Please Wait", "Synchronizing with Server");
            this.mReceiver = new MessageReceiver(this.com, this);
            RequestPacket initReq = this.getRequest();
            this.connectFrame.setInactive();
            if (initReq.getType() == 6) {
                log.debug((Object)"Client has received a matching-questions request");
                this.processMatchingQuestions(initReq.getSystemInfo());
                this.initialize();
            } else if (initReq.getType() == 0) {
                log.debug((Object)"Client has received first init-game request");
                this.connectFrame.kill();
                this.initGame(initReq.getSystemInfo());
            } else {
                log.warn((Object)"Client has received an aberrant request - retrying initialization");
                this.initialize();
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize the client and receive first init or matching requests" + newline + e), (Throwable)e);
        }
    }

    private void initGame(Information sysInfo) {
        try {
            this.id = sysInfo.getIntInfo("id");
            if (this.reauthenticating) {
                this.deserializeData();
            }
            this.clientGui = this.getGui(sysInfo);
            this.clientGui.initialize();
            this.clientIn = new QueuedMailbox(2);
            this.clientGui.setClientOutput(this.clientIn);
            log.info((Object)("Client " + this.name + " has finished GUI initialization"));
            this.mReceiver.setClientGui(this.clientGui);
            Thread messageThread = new Thread(this.mReceiver);
            messageThread.start();
            this.cReceiver = new ChatReceiver(this.com, this.clientGui);
            Thread chatThread = new Thread(this.cReceiver);
            chatThread.start();
            this.initHistoryPanel(sysInfo);
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize client " + this.name + " for client GUI communication" + newline + e), (Throwable)e);
        }
    }

    private void nextMatch(Information sysInfo) {
        try {
            ClientHistoryPanel clientHistory = this.clientGui.getClientHistoryPanel();
            String messageText = this.clientGui.getMessagePanel().getText();
            this.clientGui = this.getGui(sysInfo);
            this.clientGui.setClientHistoryPanel(clientHistory);
            this.clientGui.initialize();
            this.clientIn = new QueuedMailbox(2);
            this.clientGui.setClientOutput(this.clientIn);
            this.cReceiver.setClientGui(this.clientGui);
            this.mReceiver.setClientGui(this.clientGui);
            this.mReceiver.flushMessages();
            this.initHistoryPanel(sysInfo);
            log.info((Object)("Client " + this.name + " has finished GUI initialization for next match"));
        }
        catch (Exception e) {
            log.error((Object)("Client " + this.name + " has failed to initialize a new GUI for the next match" + MSConstants.newline + e), (Throwable)e);
        }
    }

    private void initHistoryPanel(Information sysInfo) {
        try {
            ClientHistoryPanel clientHistory = this.clientGui.getClientHistoryPanel();
            if (sysInfo.getStringInfo("defaultView").equals("full")) {
                clientHistory.setCollapseMatches(true);
            }
            clientHistory.setHistoryNumber(sysInfo.getIntInfo("historyNumber"));
            clientHistory.setViewSwitchable(sysInfo.getBooleanInfo("viewSwitchable"));
            clientHistory.setShowTotalPayoff(sysInfo.getBooleanInfo("showTotalPayoff"));
        }
        catch (Exception e) {
            log.error((Object)("Client " + this.name + " failed to initialize the history panel" + MSConstants.newline + e), (Throwable)e);
        }
    }

    private ClientGUI getGui(Information sysInfo) {
        try {
            ClientGUI cgui;
            String packageName = sysInfo.getStringInfo("packageName");
            String localGameType = sysInfo.getStringInfo("gameType");
            this.partnerNum = sysInfo.getIntInfo("partnerNum");
            this.groupSize = sysInfo.getIntInfo("groupSize");
            boolean preserve = sysInfo.getBooleanInfo("preserve");
            log.debug((Object)("Client " + this.name + " has received game type " + localGameType + " and partner number " + this.partnerNum + " with group size " + this.groupSize));
            if (this.clientGui != null && this.gameType != null && localGameType.equals(this.gameType) && preserve) {
                cgui = this.clientGui;
                log.info((Object)"Reusing ClientGUI from last match");
            } else {
                log.debug((Object)("sysInfo.getStringInfo(\"clientClassname\")==" + sysInfo.getStringInfo("clientClassname")));
                cgui = (ClientGUI)Class.forName(sysInfo.getStringInfo("clientClassname")).newInstance();
                if (this.clientGui != null) {
                    this.clientGui.setVisible(false);
                    this.clientGui.destroy();
                    log.debug((Object)"Previous ClientGUI has been saved and disposed");
                }
            }
            this.gameType = localGameType;
            cgui.enableClientGUI();
            cgui.setPartnerNum(this.partnerNum);
            cgui.setGroupSize(this.groupSize);
            cgui.setCommunicator(this.com);
            cgui.setMaximization(this.maximize);
            cgui.setWindowCloseOperation(this.closeWindow);
            cgui.updateMessagingPanel(sysInfo.getBooleanInfo("enableChat"), sysInfo.getStringInfo("chatIdentifier"), sysInfo.getBooleanInfo("optionChat"), (String[][])sysInfo.getInfo("chatOptions"));
            cgui.setDisplayFinishedInfo(sysInfo.getBooleanInfo("displayFinishedInfo"));
            if (this.testingMode) {
                cgui.enableTesting(this.choiceGenerator, this.moveDelay, this.confirmDelay);
            }
            cgui.setIntegratedTesting(this.integratedTest);
            return cgui;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find appropriate GUI for the client" + newline + e));
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)("Could not find appropriate GUI for the client - check capitalization of game type" + newline + e));
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize the client GUI" + newline + e));
            e.printStackTrace();
        }
        return null;
    }

    private void runStateMachine() {
        int state = INPUT_STATE;
        while (true) {
            if (state == INPUT_STATE) {
                log.debug((Object)"Client is entering input state -- waiting for message from server");
                state = this.input();
                continue;
            }
            if (state == OUTPUT_STATE) {
                log.debug((Object)"Client is entering output state -- waiting for action from client");
                state = this.output();
                continue;
            }
            if (state == SHUTDOWN_STATE) break;
        }
        log.debug((Object)"Client is entering shutdown state -- exiting system");
    }

    private int input() {
        try {
            RequestPacket req = this.getRequest();
            Information sysInfo = req.getSystemInfo();
            int type = req.getType();
            if (type == 0) {
                log.debug((Object)"Client has received a new initialization request");
                this.nextMatch(sysInfo);
                return INPUT_STATE;
            }
            if (type == 4) {
                this.cdata = (ClientData)sysInfo.getInfo("clientData");
                this.serializeData();
                if (!this.name.equals(this.cdata.getName())) {
                    log.warn((Object)("Naming mismatch!: Client " + this.name + " now has id " + this.cdata.getId() + " and partner num " + this.cdata.getPartnerNum() + " and name " + this.cdata.getName()));
                }
            } else if (type == 1 || type == 2 || type == 3) {
                this.updateClientData((ClientUpdate)sysInfo.getInfo("clientUpdate"));
            }
            if (type != 7) {
                log.debug((Object)("Processing (non-disconnect) request of type: " + type));
                this.flushClientBox();
                this.clientGui.createLayout(req.getType(), req.getGameInfo(), this.cdata);
                if (this.reauthenticating) {
                    this.clientGui.reauthenticate();
                    this.reauthenticating = false;
                }
                return OUTPUT_STATE;
            }
            log.info((Object)"Received a DISCONNECT_INTERNAL_REQUEST -- abandoning main client thread");
            this.disconnect();
            return SHUTDOWN_STATE;
        }
        catch (Exception e) {
            log.error((Object)"Failed to respond to a request in the main client control", (Throwable)e);
            return SHUTDOWN_STATE;
        }
    }

    private int output() {
        try {
            String clientAction = (String)this.clientIn.receive();
            log.debug((Object)("Client internal mailbox has received instruction: " + clientAction));
            if (clientAction.equals("move")) {
                Information info = (Information)this.clientIn.receive();
                log.debug((Object)("Client " + this.name + " has made a move"));
                GameResponse res = new GameResponse(0);
                res.setInformation(info);
                this.sendResponse(res);
                this.serializeData();
                return INPUT_STATE;
            }
            if (clientAction.equals("abort")) {
                return INPUT_STATE;
            }
            if (clientAction.equals("proceed")) {
                log.debug((Object)"Client is sending a CONFIRM_FINISHED_CHOICE response to server");
                this.sendResponse(new GameResponse(1));
                this.mReceiver.holdMessages();
                this.clientGui.disableClientGUI();
                return INPUT_STATE;
            }
            if (clientAction.equals("disconnect")) {
                log.info((Object)"Received a disconnect message in the internal client mailbox -- abandoning main client thread");
                this.disconnect();
                return SHUTDOWN_STATE;
            }
            log.error((Object)"Received unknown message in client internal mailbox -- waiting for new message");
            return OUTPUT_STATE;
        }
        catch (Exception e) {
            log.error((Object)("Failed to receive a move from the client GUI and send a response" + newline), (Throwable)e);
            return SHUTDOWN_STATE;
        }
    }

    public void processMessage(MessagePacket mes) {
        final int type = mes.getType();
        Runnable process = new Runnable(){

            public void run() {
                if (type == 30) {
                    Client.this.kill();
                }
                if (type == 31) {
                    Client.this.resetPreAuth();
                }
                if (type == 32) {
                    Client.this.resetPostAuth();
                }
            }
        };
        Thread thr = new Thread(process);
        thr.start();
    }

    public void resetPreAuth() {
        try {
            log.info((Object)"Client has received a pre_auth reset request -- returning to primitive state");
            this.shutdown();
            this.readProperties();
            this.run();
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset client to a pre-authentication state", (Throwable)e);
        }
    }

    public void resetPostAuth() {
        try {
            log.info((Object)"Client has received a post-auth reset request -- returning to first input state");
        }
        catch (Exception e) {
            log.error((Object)"Failed to reset client to a post-authentication state", (Throwable)e);
        }
    }

    public void kill() {
        try {
            log.info((Object)"Client has received kill request -- shutting down");
            this.shutdown();
            log.info((Object)"Client has finished shutdown procedures -- initiating full system exit");
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)"Failed to kill client", (Throwable)e);
        }
    }

    private synchronized void shutdown() {
        try {
            this.readyForExit = false;
            this.com.sendInternalRequest(new GameRequest(7));
            this.clientIn.deposit("disconnect");
            while (!this.readyForExit) {
                this.wait();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to shut down client", (Throwable)e);
        }
    }

    private synchronized void disconnect() {
        this.clientGui.destroy();
        this.com.close();
        this.auth.close();
        this.mReceiver.close();
        this.cReceiver.close();
        this.auth = null;
        this.com = null;
        this.reauthenticating = false;
        this.host = null;
        this.name = null;
        this.id = 0;
        this.clientGui = null;
        this.gameType = null;
        this.partnerNum = 0;
        this.groupSize = 0;
        this.clientIn = null;
        this.mReceiver = null;
        this.cReceiver = null;
        this.testingMode = false;
        this.choiceGenerator = null;
        this.readyForExit = true;
        this.notifyAll();
    }

    private void serializeData() {
        try {
            if (this.cdata == null || this.serializePath == null) {
                return;
            }
            File directory = new File(this.serializePath + sep + "client-" + this.id);
            directory.mkdirs();
            File file = new File(this.serializePath + sep + "client-" + this.id + sep + "cdata.msd");
            file.createNewFile();
            FileOutputStream outStream = new FileOutputStream(file);
            ObjectOutputStream objStream = new ObjectOutputStream(outStream);
            objStream.writeObject(this.cdata);
            objStream.close();
            outStream.close();
            log.debug((Object)("Successfully serialized client data to path: " + this.serializePath + sep + "client-" + this.id + sep + "cdata.msd"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to serialize the client data to path: " + this.serializePath + sep + "client-" + this.id + sep + "cdata.msd"), (Throwable)e);
        }
    }

    private void deserializeData() {
        try {
            if (this.serializePath == null) {
                return;
            }
            String sep = System.getProperty("file.separator");
            File file = new File(this.serializePath + sep + "client-" + this.id + sep + "cdata.msd");
            FileInputStream inStream = new FileInputStream(file);
            ObjectInputStream objStream = new ObjectInputStream(inStream);
            this.cdata = (ClientData)objStream.readObject();
            objStream.close();
            inStream.close();
            log.info((Object)("Successfully de-serialized client data from path: " + this.serializePath + sep + "client-" + this.id + sep + "cdata.msd"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to de-serialize the client data from path: " + this.serializePath + sep + "client-" + this.id + sep + "cdata.msd"), (Throwable)e);
        }
    }

    private void updateClientData(ClientUpdate cupdate) {
        try {
            if (cupdate == null) {
                log.warn((Object)"Client received a null update object -- skipping ClientData update");
                return;
            }
            if (cupdate.isMatchUpdate()) {
                this.cdata = cupdate.updateMatchData(this.cdata);
            }
            this.cdata = cupdate.updateRoundData(this.cdata);
        }
        catch (Exception e) {
            log.error((Object)"Failed to update the client and partner data objects", (Throwable)e);
        }
    }

    private void processMatchingQuestions(Information sysInfo) {
        try {
            Vector questions = (Vector)sysInfo.getInfo("questions");
            QuestionDialog qd = new QuestionDialog(null, true, this.testingMode);
            qd.setConfirmDelay(this.confirmDelay);
            qd.addQuestions(questions);
            qd.setTitle(this.name);
            qd.display();
            Information response = new Information();
            Vector answers = qd.getQuestions();
            response.addInfo("answers", answers);
            GameResponse res = new GameResponse(0);
            res.setInformation(response);
            this.sendResponse(res);
        }
        catch (Exception e) {
            log.error((Object)"Failed to process and respond to matching questions", (Throwable)e);
        }
    }

    public RequestPacket getRequest() {
        RequestPacket req = this.com.getRequest();
        return req;
    }

    public void sendResponse(Response res) {
        this.com.sendResponse(res);
    }

    private void flushClientBox() {
        if (this.clientIn == null) {
            return;
        }
        boolean foundDisconnect = false;
        try {
            Object rec;
            log.debug((Object)"Flushing the client internal mailbox...");
            while ((rec = this.clientIn.receiveIfPossible()) != null) {
                try {
                    String instr = (String)rec;
                    if (!instr.equals("disconnect")) {
                        log.warn((Object)("Double-move prevention (fail-safe): Flushed an aberrant instruction '" + instr + "' from the client internal mailbox"));
                        continue;
                    }
                    foundDisconnect = true;
                }
                catch (ClassCastException e) {
                    log.warn((Object)"Double-move prevention (fail-safe): Flushed an extraneous information object from the client internal mailbox");
                }
            }
            if (foundDisconnect) {
                log.fatal((Object)"Found a 'disconnect' instruction while flushing client internal mailbox -- re-inserting");
                this.clientIn.deposit("disconnect");
            }
            log.debug((Object)"Flush of client internal mailbox complete");
        }
        catch (Exception e) {
            log.error((Object)"Failed to flush the client internal mailbox", (Throwable)e);
        }
    }
}

