/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.client.control;

import edu.caltech.ssel.multistage.client.interfaces.MessageHandler;
import edu.caltech.ssel.multistage.client.network.ClientCommunicator;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.util.Vector;
import org.apache.log4j.Category;

public class ChatReceiver
implements Runnable {
    private static Category log = Category.getInstance(ChatReceiver.class);
    private ClientCommunicator com;
    private MessageHandler cgui;
    private boolean die;
    private Vector heldMessages;

    public ChatReceiver(ClientCommunicator com, MessageHandler cgui) {
        this.com = com;
        this.cgui = cgui;
        this.die = false;
    }

    public void run() {
        log.info((Object)"Client Chat receiver has been initialized");
        while (!this.die) {
            try {
                MessagePacket mes = this.com.getChat();
                this.cgui.processMessage(mes);
            }
            catch (Exception e) {
                log.error((Object)("Client chat receiver has malfunctioned" + MSConstants.newline + e));
                e.printStackTrace();
            }
            Thread.yield();
        }
    }

    public void close() {
        this.die = true;
    }

    public void setClientGui(MessageHandler cgui) {
        this.cgui = cgui;
    }
}

