/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.webbrowser;

import edu.caltechUcla.sselCassel.webbrowser.ExitListener;
import edu.caltechUcla.sselCassel.webbrowser.WindowUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Browser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JButton homeButton;
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public static void main(String[] args) {
        if (args.length == 0) {
            new Browser("http://www.yahoo.com");
        } else {
            new Browser(args[0]);
        }
    }

    public Browser(String initialURL) {
        super("Simple Swing Browser");
        this.initialURL = initialURL;
        this.addWindowListener(new ExitListener());
        WindowUtilities.setNativeLookAndFeel();
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.lightGray);
        this.homeButton = new JButton("HOME");
        this.homeButton.addActionListener(this);
        JLabel urlLabel = new JLabel("URL:");
        this.urlField = new JTextField(30);
        this.urlField.setText(initialURL);
        this.urlField.addActionListener(this);
        topPanel.add(this.homeButton);
        topPanel.add(urlLabel);
        topPanel.add(this.urlField);
        this.getContentPane().add((Component)topPanel, "North");
        try {
            this.htmlPane = new JEditorPane(initialURL);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (IOException ioe) {
            this.warnUser("Can't build HTML pane for " + initialURL + ": " + ioe);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = screenSize.width * 8 / 10;
        int height = screenSize.height * 8 / 10;
        this.setBounds(width / 8, height / 8, width, height);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        String url = event.getSource() == this.urlField ? this.urlField.getText() : this.initialURL;
        try {
            this.htmlPane.setPage(new URL(url));
            this.urlField.setText(url);
        }
        catch (IOException ioe) {
            this.warnUser("Can't follow link to " + url + ": " + ioe);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
                this.urlField.setText(event.getURL().toExternalForm());
            }
            catch (IOException ioe) {
                this.warnUser("Can't follow link to " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

