/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Weibull
extends Variate {
    private final double scale;
    private final double shape_recip;
    private final double[] params = new double[3];

    public Weibull(double scale, double shape, long i) throws BadParameterException {
        super(i);
        if (scale <= 0.0 || shape <= 0.0) {
            throw new BadParameterException("Weibull argument error: arguments are less than zero");
        }
        this.scale = scale;
        this.shape_recip = 1.0 / shape;
        this.params[0] = scale;
        this.params[1] = shape;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return this.scale * Math.pow(-Math.log(super.gen()), this.shape_recip);
    }
}

