/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Uniform2
extends Variate {
    private final double min;
    private final double range;
    private final double[] params = new double[3];

    public Uniform2(double min, double max, long i) throws BadParameterException {
        super(i);
        if (max < min) {
            throw new BadParameterException("Uniform2 argument error: Max value is less than min value");
        }
        this.min = min;
        this.range = max - min;
        this.params[0] = min;
        this.params[1] = max;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return this.min + this.range * super.gen();
    }

    public static void main(String[] args) {
        try {
            Uniform2 rand = new Uniform2(0.0, 100.0, 23243435L);
            int i = 0;
            while (i < 100) {
                System.out.println("Show uniform variable distribution from 0 to 100--  " + i + " : " + rand.gen());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

