/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Uniform
extends Variate {
    private final double min;
    private final double range;
    private final double[] params = new double[3];

    public Uniform(double mean, double hwidth, long i) throws BadParameterException {
        super(i);
        if (hwidth < 0.0) {
            throw new BadParameterException("Uniform argument error: half width must be nonnegative");
        }
        this.min = mean - hwidth;
        this.range = 2.0 * hwidth;
        this.params[0] = mean;
        this.params[1] = hwidth;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return this.min + this.range * super.gen();
    }
}

