/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.Variate;

public class Triangular
extends Variate {
    private final double min;
    private final double max;
    private final double range;
    private final double left;
    private final double right;
    private final double[] params = new double[3];

    public Triangular(double min, double max, long i) {
        super(i);
        this.min = min;
        this.max = max;
        double mode = (min + max) / 2.0;
        this.range = max - min;
        this.left = mode - min;
        this.right = max - mode;
        this.params[0] = min;
        this.params[1] = max;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double r = super.gen();
        if (r <= this.left / this.range) {
            return this.min + Math.sqrt(this.left * this.range * r);
        }
        return this.max - Math.sqrt(this.right * this.range * (1.0 - r));
    }
}

