/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.ChiSquare;
import edu.caltechUcla.sselCassel.variate.Normal;
import edu.caltechUcla.sselCassel.variate.Variate;

public class StudentT
extends Variate {
    private final int n;
    private final Normal normal;
    private final ChiSquare chi;
    private final double[] params = new double[2];

    public StudentT(int n, long i) throws BadParameterException {
        super(i);
        this.n = n;
        this.normal = new Normal(0.0, 1.0, i);
        this.chi = new ChiSquare(n, i);
        this.params[0] = n;
        this.params[1] = i;
    }

    public StudentT(double n, long i) throws BadParameterException {
        this((int)n, i);
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return this.normal.gen() / Math.sqrt(this.chi.gen() / (double)this.n);
    }
}

