/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.Variate;

public class Poisson
extends Variate {
    private static final int MAX_TIMES = 100000;
    private final double cutoff;
    private final double[] params = new double[2];

    public Poisson(double mu, long i) {
        super(i);
        this.cutoff = Math.exp(-mu);
        this.params[0] = mu;
        this.params[1] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        int n = 0;
        double r = 1.0;
        while ((r *= super.gen()) >= this.cutoff) {
            if (n++ > 100000) break;
        }
        return n;
    }

    static {
        MAX_TIMES = 100000;
    }
}

