/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Normal
extends Variate {
    private final double mu;
    private final double sigma;
    private double save;
    private boolean computed;
    private final double[] params = new double[3];

    public Normal(double mu, double sigma, long i) throws BadParameterException {
        super(i);
        if (sigma < 0.0) {
            throw new BadParameterException("Normal distribution error: sigma can't be negative! " + sigma);
        }
        this.computed = true;
        this.mu = mu;
        this.sigma = sigma;
        this.params[0] = mu;
        this.params[1] = sigma;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double b;
        double a;
        double w;
        boolean bl = this.computed = !this.computed;
        if (this.computed) {
            return this.save * this.sigma + this.mu;
        }
        while ((w = (a = 2.0 * super.gen() - 1.0) * a + (b = 2.0 * super.gen() - 1.0) * b) > 1.0) {
        }
        double temp = Math.sqrt(-2.0 * Math.log(w) / w);
        this.save = b * temp;
        return a * temp * this.sigma + this.mu;
    }
}

