/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Geometric;
import edu.caltechUcla.sselCassel.variate.Variate;

public class NegativeBinomial
extends Variate {
    private final int n;
    private final Geometric geom;
    private final double[] params = new double[3];

    public NegativeBinomial(double p, int n, long i) throws BadParameterException {
        super(i);
        if (p <= 0.0 || p >= 1.0) {
            throw new BadParameterException("Probability must in (0, 1)");
        }
        this.n = n;
        this.geom = new Geometric(p, i);
        this.params[0] = p;
        this.params[1] = n;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double sum = 0.0;
        int j = 0;
        while (j < this.n) {
            sum += this.geom.gen();
            ++j;
        }
        return sum;
    }
}

