/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

public class LCGRandom {
    public static final int MAX_STREAMS = 10;
    private static final long MULTIPIER = 16807L;
    private static final long MODULUS = Integer.MAX_VALUE;
    private static final double SCALER = 4.656612875245797E-10;
    private static final long[] SEED;
    private int stream;
    private final double[] params = new double[1];

    public LCGRandom(int stream) {
        this.stream = stream;
        this.params[0] = stream;
    }

    public void incrStream() {
        ++this.stream;
        this.params[0] = this.stream;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        long z = SEED[this.stream];
        LCGRandom.SEED[this.stream] = z = 16807L * z % Integer.MAX_VALUE;
        return (double)z * 4.656612875245797E-10;
    }

    public long igen() {
        long z = SEED[this.stream];
        LCGRandom.SEED[this.stream] = z = 16807L * z % Integer.MAX_VALUE;
        return z;
    }

    static {
        MAX_STREAMS = 10;
        MULTIPIER = 16807L;
        MODULUS = Integer.MAX_VALUE;
        SCALER = 4.656612875245797E-10;
        SEED = new long[]{428956419L, 1954324947L, 1145661099L, 1835732737L, 794161987L, 1329531353L, 200496737L, 633816299L, 1410143363L, 1282538739L};
    }
}

