/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class HyperGeometric
extends Variate {
    private final int n;
    private int m;
    private double g;
    private double c;
    private final double[] params = new double[4];

    public HyperGeometric(int m, int n, double p, long i) throws BadParameterException {
        super(i);
        if (m < n) {
            throw new BadParameterException("HyperGeometric argument error: population size is less than the number to be drawn");
        }
        this.m = m;
        this.n = n;
        this.g = p * (double)m;
        this.c = (double)m - this.g;
        this.params[0] = m;
        this.params[1] = n;
        this.params[2] = p;
        this.params[3] = i;
    }

    public HyperGeometric(double m, double n, double p, long i) throws BadParameterException {
        this((int)m, (int)n, p, i);
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        int k = 0;
        int j = 0;
        while (j < this.n) {
            if (super.gen() <= this.g / (double)this.m) {
                ++k;
                this.g -= 1.0;
            } else {
                this.c -= 1.0;
            }
            --this.m;
            ++j;
        }
        return k;
    }
}

