/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class HyperExponential
extends Variate {
    private final double mu;
    private final double p;
    private final double[] params = new double[3];

    public HyperExponential(double mu, double sigma, long i) throws BadParameterException {
        super(i);
        if (sigma <= 0.0) {
            throw new BadParameterException("Hyperexponential argument error: standard deviation is less than zero");
        }
        this.mu = mu;
        double cv2 = sigma / mu;
        cv2 *= cv2;
        this.p = 0.5 * (1.0 - Math.sqrt((cv2 - 1.0) / (cv2 + 1.0)));
        this.params[0] = mu;
        this.params[1] = sigma;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double z = super.gen() > this.p ? this.mu / (1.0 - this.p) : this.mu / this.p;
        return -0.5 * z * Math.log(super.gen());
    }
}

