/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Erlang;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Gamma
extends Variate {
    private final double beta;
    private final double alpha;
    private final int a;
    private final double b;
    private final Erlang e1;
    private final Erlang e2;
    private final double[] params = new double[3];

    public Gamma(double beta, double alpha, long i) throws BadParameterException {
        super(i);
        if (beta < 0.0 || alpha < 0.0) {
            throw new BadParameterException("Auguments must be greater than zero");
        }
        this.beta = beta;
        this.alpha = alpha;
        this.a = (int)alpha;
        this.b = alpha - (double)this.a;
        this.e1 = new Erlang(beta, this.a, i);
        this.e2 = new Erlang(beta, this.a + 1, i);
        this.params[0] = alpha;
        this.params[1] = beta;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double x = 0.0;
        double y = 0.0;
        if (this.alpha < 1.0) {
            while ((x = Math.pow(super.gen(), 1.0 / this.alpha)) + (y = Math.pow(super.gen(), 1.0 / (1.0 - this.alpha))) > 1.0) {
            }
            return x / (x + y) * -Math.log(super.gen()) * this.beta;
        }
        if (this.alpha < 5.0) {
            double prod;
            do {
                x = this.alpha / (double)this.a;
                prod = 1.0;
                int i = 0;
                while (i < this.a) {
                    prod *= super.gen();
                    ++i;
                }
            } while (super.gen() > Math.pow((x *= -Math.log(prod)) / this.alpha, this.b) * Math.exp(-this.b * x / (this.alpha - 1.0)));
            return x * this.beta;
        }
        if (super.gen() >= this.b) {
            return this.e1.gen();
        }
        return this.e2.gen();
    }
}

