/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Exponential
extends Variate {
    private double mu;
    private final double[] params = new double[2];

    public Exponential(double mu, long i) throws BadParameterException {
        super(i);
        if (mu < 0.0) {
            throw new BadParameterException("Exponential argument error: mean is less than zero");
        }
        this.mu = mu;
        this.params[0] = mu;
        this.params[1] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return -this.mu * Math.log(super.gen());
    }
}

