/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Erlang
extends Variate {
    private final double mu;
    private final int k;
    private final double[] params = new double[3];

    public Erlang(double mu, int k, long i) throws BadParameterException {
        super(i);
        if (mu < 0.0) {
            throw new BadParameterException("Erlang argument error: mean is less than zero");
        }
        this.mu = mu;
        this.k = k;
        this.params[0] = mu;
        this.params[1] = k;
        this.params[2] = i;
    }

    public Erlang(double mu, double k, long i) throws BadParameterException {
        this(mu, (int)k, i);
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double product = 1.0;
        int j = 0;
        while (j < this.k) {
            product *= super.gen();
            ++j;
        }
        return -this.mu * Math.log(product);
    }
}

