/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Cauchy
extends Variate {
    private final double mu;
    private final double sigma;
    private final double[] params = new double[3];

    public Cauchy(double mu, double sigma, long i) throws BadParameterException {
        super(i);
        if (sigma <= 0.0) {
            throw new BadParameterException("Cauchy argument error: standard deviation is less than zero");
        }
        this.mu = mu;
        this.sigma = sigma;
        this.params[0] = mu;
        this.params[1] = sigma;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        return this.sigma * Math.tan(Math.PI * (super.gen() - 0.5)) + this.mu;
    }
}

