/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Binomial
extends Variate {
    private final int n;
    private final double p;
    private final double[] params = new double[3];

    public Binomial(int n, double p, long i) throws BadParameterException {
        super(i);
        if (p <= 0.0 || p >= 1.0) {
            throw new BadParameterException("Binomial argument error: Probability values is not in (0, 1)");
        }
        this.n = n;
        this.p = p;
        this.params[0] = n;
        this.params[1] = p;
        this.params[2] = i;
    }

    public Binomial(double n, double p, long i) throws BadParameterException {
        this((int)n, p, i);
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        int count = 0;
        int j = 0;
        while (j < this.n) {
            if (super.gen() <= this.p) {
                ++count;
            }
            ++j;
        }
        return count;
    }
}

