/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.variate;

import edu.caltechUcla.sselCassel.variate.BadParameterException;
import edu.caltechUcla.sselCassel.variate.Gamma;
import edu.caltechUcla.sselCassel.variate.Variate;

public class Beta
extends Variate {
    private final Gamma gamma1;
    private final Gamma gamma2;
    private final double[] params = new double[3];

    public Beta(double alpha, double beta, long i) throws BadParameterException {
        super(i);
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new BadParameterException("Beta argument error: arguments are less than zero");
        }
        this.gamma1 = new Gamma(1.0, alpha, i);
        this.gamma2 = new Gamma(1.0, beta, i);
        this.params[0] = alpha;
        this.params[1] = beta;
        this.params[2] = i;
    }

    public double[] getParameters() {
        return this.params;
    }

    public double gen() {
        double g1 = this.gamma1.gen();
        double g2 = this.gamma2.gen();
        return g1 / (g1 + g2);
    }
}

