/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.util.test;

import edu.caltechUcla.sselCassel.util.EmailManager;
import junit.framework.Assert;
import junit.framework.TestCase;

public class EmailManagerTest
extends TestCase {
    private static final String FROM = "test1@adam.cassel.ucla.edu";
    private static final String BADFROM = "test1#adam.cassel.ucla@edu";
    private static String[] okToList;
    private static String[] badToList;
    private static String[] okCCList;
    private int status;
    private EmailManager emailMgr;

    public EmailManagerTest(String title) {
        super(title);
    }

    protected void setUp() {
        this.emailMgr = EmailManager.getEmailManager();
    }

    public void testEmailSend_EmptyFrom() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(null, okToList, okCCList, "Empty sender", "hello world.");
        Assert.assertEquals((int)this.status, (int)-1);
    }

    public void testEmailSend_BadFrom() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(BADFROM, okToList, okCCList, "Bad formed sender", "hello world.");
        Assert.assertEquals((int)this.status, (int)-6);
    }

    public void testEmailSend_EmptyToList() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(FROM, null, okCCList, "Empty toList", "hello world.");
        Assert.assertEquals((int)this.status, (int)-3);
    }

    public void testEmailSend_EmptyMsg() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(FROM, okToList, okCCList, "Empty msg body", null);
        Assert.assertEquals((int)this.status, (int)-4);
    }

    public void testEmailSend_OK() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(FROM, okToList, okCCList, "Hello", "hello world.");
        Assert.assertEquals((int)this.status, (int)0);
    }

    public void testEmailSend_BadToList() throws Exception {
        Assert.assertNotNull((Object)this.emailMgr);
        this.status = this.emailMgr.sendEmail(FROM, badToList, okCCList, "Bad toList", "hello world.");
        Assert.assertEquals((String)"EmailManager test-- tolist including bad addr.", (int)this.status, (int)0);
    }

    static {
        FROM = FROM;
        BADFROM = BADFROM;
        okToList = new String[]{"test2@adam.cassel.ucla.edu", "test3@adam.cassel.ucla.edu"};
        badToList = new String[]{"test2@adam.cassel.ucla.edu", "test2#adam.cassel.ucla@edu"};
        okCCList = new String[]{FROM};
    }
}

