/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.util;

import edu.caltechUcla.sselCassel.util.Constants;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Category;

public class EmailManager {
    public static final int OK = 0;
    public static final int EMPTY_FROM = -1;
    public static final int BAD_FROM = -2;
    public static final int EMPTY_TOLIST = -3;
    public static final int EMPTY_MSG = -4;
    public static final int FAILED_CREATE_MSG = -5;
    public static final int FAILED_SEND_MSG = -6;
    public static final String SMTPHOST = "adam.cassel.ucla.edu";
    private static Category log;
    private static String smtpHost;
    private static EmailManager emailMgr;
    private static Properties props;
    private static int status;
    static /* synthetic */ Class class$edu$caltechUcla$sselCassel$util$EmailManager;

    private EmailManager(String smtphost) {
        smtpHost = smtphost != null ? smtphost : SMTPHOST;
        log.info((Object)("Setting smtphost to: " + smtpHost));
        props = new Properties();
        props.put("mail.smtp.host", smtpHost);
        if (log.isDebugEnabled()) {
            props.put("mail.debug", new Boolean(true));
        }
        status = 0;
    }

    public static EmailManager getEmailManager(String smtphost) {
        return emailMgr == null ? (emailMgr = new EmailManager(smtphost)) : emailMgr;
    }

    public static EmailManager getEmailManager() {
        return emailMgr == null ? (emailMgr = new EmailManager(null)) : emailMgr;
    }

    public int sendEmail(String from, String[] tolist, String[] cclist, String subject, String msgText) {
        Address[] toList = this.getInternetAddressList(tolist);
        Address[] ccList = this.getInternetAddressList(cclist);
        return this.sendEmail(from, toList, ccList, subject, msgText);
    }

    public int sendEmail(String from, Address[] toList, Address[] ccList, String subject, String msgText) {
        block17: {
            if (from == null) {
                log.error((Object)"Empty 'from' field when try to send email.");
                return -1;
            }
            InternetAddress f = null;
            try {
                f = new InternetAddress(from);
            }
            catch (AddressException e) {
                log.error((Object)("Illegal *from* address: " + from + Constants.LINESEP + (Object)((Object)e)));
                return -2;
            }
            if (toList == null) {
                log.error((Object)"Empty 'to' list when try to send email.");
                return -3;
            }
            if (msgText == null) {
                log.error((Object)"Empty 'msg' body when try to send email.");
                return -4;
            }
            try {
                Session session = Session.getInstance((Properties)props);
                session.setDebug(log.isDebugEnabled());
                MimeMessage msg = new MimeMessage(session);
                msg.setFrom((Address)f);
                msg.setText(msgText);
                msg.setSentDate(new Date());
                msg.setSubject(subject);
                int size = toList.length;
                int i = 0;
                while (i < size) {
                    try {
                        msg.setRecipient(Message.RecipientType.TO, toList[i]);
                        Transport.send((Message)msg);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Email regarding: " + subject + " was sent to-- " + toList[i]));
                        }
                    }
                    catch (MessagingException e) {
                        log.error((Object)("Failed to send email with subject-- " + subject + " to-- " + toList[i] + "\t" + (Object)((Object)e)));
                    }
                    ++i;
                }
                if (ccList == null) break block17;
                size = ccList.length;
                int i2 = 0;
                while (i2 < size) {
                    try {
                        msg.setRecipient(Message.RecipientType.CC, ccList[i2]);
                        Transport.send((Message)msg);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Email regarding: " + subject + " was CC to-- " + ccList[i2]));
                        }
                    }
                    catch (MessagingException e) {
                        log.error((Object)("failed to send email with subject-- " + subject + " CC to-- " + ccList[i2] + "\t" + (Object)((Object)e)));
                    }
                    ++i2;
                }
            }
            catch (IllegalWriteException e) {
                log.error((Object)("Failed to create the email msg regarding--  " + subject + "\t" + (Object)((Object)e)));
                return -5;
            }
            catch (SendFailedException e) {
                log.error((Object)("Failed to send the email. " + (Object)((Object)e)));
                return -6;
            }
            catch (MessagingException e) {
                log.error((Object)("Failed to send the email. " + (Object)((Object)e)));
                return -6;
            }
        }
        return 0;
    }

    public Address[] getInternetAddressList(String[] list) {
        InternetAddress a;
        if (list == null) {
            return null;
        }
        ArrayList<InternetAddress> addrlist = new ArrayList<InternetAddress>();
        int i = 0;
        while (i < list.length) {
            try {
                a = new InternetAddress(list[i]);
                addrlist.add(a);
            }
            catch (AddressException e) {
                log.error((Object)("Illegal email address encounter: " + list[i] + Constants.LINESEP + (Object)((Object)e)));
            }
            ++i;
        }
        a = new Address[1];
        return addrlist.toArray((T[])a);
    }

    public int ping() {
        return status;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        OK = 0;
        EMPTY_FROM = -1;
        BAD_FROM = -2;
        EMPTY_TOLIST = -3;
        EMPTY_MSG = -4;
        FAILED_CREATE_MSG = -5;
        FAILED_SEND_MSG = -6;
        SMTPHOST = SMTPHOST;
        log = Category.getInstance((Class)(class$edu$caltechUcla$sselCassel$util$EmailManager == null ? (class$edu$caltechUcla$sselCassel$util$EmailManager = EmailManager.class$("edu.caltechUcla.sselCassel.util.EmailManager")) : class$edu$caltechUcla$sselCassel$util$EmailManager));
        smtpHost = null;
        status = -1;
    }
}

