/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Category;

public class CasselProps {
    public static final String DEFAULT_PROP_FILENAME = "cassel.properties";
    private static String propertyFileName;
    private static String propHome;
    private static Properties properties;
    private static Category log;
    private static CasselProps casselProps;
    static /* synthetic */ Class class$edu$caltechUcla$sselCassel$util$CasselProps;

    private CasselProps(String propertyFileName) {
        properties = new Properties();
        CasselProps.propertyFileName = propertyFileName == null ? DEFAULT_PROP_FILENAME : propertyFileName;
        InputStream in = this.loadPropertyStream(propertyFileName);
        if (in == null && (propHome = System.getProperty("propHome")) != null) {
            propertyFileName = propHome + File.separator + propertyFileName;
            in = this.loadPropertyStream(propertyFileName);
        }
        if (in == null) {
            log.fatal((Object)("Could not get resource file: " + propertyFileName));
            return;
        }
        try {
            properties.load(in);
        }
        catch (IOException e) {
            log.error((Object)("Could not load properties file: " + propertyFileName + ": " + e));
            return;
        }
    }

    private InputStream loadPropertyStream(String propFileName) {
        InputStream in = null;
        try {
            in = new FileInputStream(propFileName);
        }
        catch (FileNotFoundException e) {
            log.info((Object)(propFileName + " file not found, by directly loading the file."));
        }
        if (in == null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            in = classLoader.getResourceAsStream(propFileName);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(propFileName);
        }
        return in;
    }

    public static CasselProps getCasselProps(String propertyFileName) {
        return casselProps == null ? (casselProps = new CasselProps(propertyFileName)) : casselProps;
    }

    public Properties getProperties() {
        return (Properties)properties.clone();
    }

    public String getProperty(String name) {
        String property = properties.getProperty(name);
        return property == null ? null : property.trim();
    }

    public String getProperty(String name, String defaultValue) {
        String property = properties.getProperty(name, defaultValue);
        return property == null ? null : property.trim();
    }

    public void setProperty(String name, String newValue) {
        if (name == null || newValue == null) {
            return;
        }
        properties.setProperty(name, newValue);
    }

    public void updateProperties() throws IOException {
        FileOutputStream out = new FileOutputStream(propertyFileName);
        properties.store(out, "Updated properties for " + propertyFileName + " : " + new Date(System.currentTimeMillis()).toString());
    }

    public static void main(String[] args) {
        CasselProps cp = CasselProps.getCasselProps("casselWeb.properties");
        System.out.println("Administrator Email: " + cp.getProperty("adminEmail"));
        System.out.println("Database Server URL: " + cp.getProperty("dbServer"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_PROP_FILENAME = DEFAULT_PROP_FILENAME;
        propertyFileName = null;
        propHome = null;
        properties = null;
        log = Category.getInstance((Class)(class$edu$caltechUcla$sselCassel$util$CasselProps == null ? (class$edu$caltechUcla$sselCassel$util$CasselProps = CasselProps.class$("edu.caltechUcla.sselCassel.util.CasselProps")) : class$edu$caltechUcla$sselCassel$util$CasselProps));
    }
}

