/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.nio.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;

public class NonBlockingServer {
    private static final int PORT = 8030;
    private static Category log;
    private static final String QUIT_SERVER = "quit";
    private static final String SHUTDOWN = "shutdown";
    private Selector selector = null;
    private ServerSocketChannel selectableChannel = null;
    private int keysAdded = 0;
    private int port = 8030;
    static final int BUFSIZE = 8;
    static /* synthetic */ Class class$edu$caltechUcla$sselCassel$nio$server$NonBlockingServer;

    public NonBlockingServer() {
    }

    public NonBlockingServer(int port) {
        this.port = port;
    }

    public void initialize() throws IOException {
        this.selector = SelectorProvider.provider().openSelector();
        this.selectableChannel = ServerSocketChannel.open();
        this.selectableChannel.configureBlocking(false);
        InetAddress lh = InetAddress.getLocalHost();
        InetSocketAddress isa = new InetSocketAddress(lh, this.port);
        this.selectableChannel.socket().bind(isa);
    }

    public void finalize() throws IOException {
        this.selectableChannel.close();
        this.selector.close();
    }

    public void acceptConnections() throws IOException, InterruptedException {
        SelectionKey acceptKey = this.selectableChannel.register(this.selector, 16);
        log.debug((Object)"Acceptor loop...");
        while ((this.keysAdded = acceptKey.selector().select()) > 0) {
            log.debug((Object)("Selector returned " + this.keysAdded + " ready for IO operations"));
            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
            Iterator<SelectionKey> i = readyKeys.iterator();
            while (i.hasNext()) {
                SelectableChannel nextReady;
                SelectionKey key = i.next();
                i.remove();
                if (key.isAcceptable()) {
                    nextReady = (ServerSocketChannel)key.channel();
                    log.debug((Object)("Processing selection key read=" + key.isReadable() + " write=" + key.isWritable() + " accept=" + key.isAcceptable()));
                    SocketChannel channel = ((ServerSocketChannel)nextReady).accept();
                    channel.configureBlocking(false);
                    SelectionKey readKey = channel.register(this.selector, 5);
                    readKey.attach(new ChannelCallback(channel));
                    continue;
                }
                if (key.isReadable()) {
                    nextReady = key.channel();
                    log.debug((Object)("Processing selection key read=" + key.isReadable() + " write=" + key.isWritable() + " accept=" + key.isAcceptable()));
                    this.readMessage((ChannelCallback)key.attachment());
                    continue;
                }
                if (!key.isWritable()) continue;
                ChannelCallback callback = (ChannelCallback)key.attachment();
                String message = "What is your name? ";
                ByteBuffer buf = ByteBuffer.wrap(message.getBytes());
                int nbytes = callback.getChannel().write(buf);
            }
        }
        log.debug((Object)"End acceptor loop...");
    }

    public void writeMessage(SocketChannel channel, String message) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(message.getBytes());
        int nbytes = channel.write(buf);
        log.debug((Object)("Wrote " + nbytes + " to channel."));
    }

    public String decode(ByteBuffer byteBuffer) throws CharacterCodingException {
        Charset charset = Charset.forName("us-ascii");
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = decoder.decode(byteBuffer);
        String result = charBuffer.toString();
        return result;
    }

    public void readMessage(ChannelCallback callback) throws IOException, InterruptedException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        int nbytes = callback.getChannel().read(byteBuffer);
        byteBuffer.flip();
        String result = this.decode(byteBuffer);
        log.debug((Object)result);
        if (result.indexOf(QUIT_SERVER) >= 0) {
            callback.getChannel().close();
        } else {
            if (result.indexOf(SHUTDOWN) >= 0) {
                callback.getChannel().close();
                throw new InterruptedException();
            }
            callback.append(result.toString());
            if (result.indexOf("\n") >= 0) {
                callback.execute();
            }
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        NonBlockingServer nbServer = new NonBlockingServer();
        try {
            nbServer.initialize();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            nbServer.acceptConnections();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)e);
        }
        catch (InterruptedException e) {
            log.info((Object)"Exiting normally...");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PORT = 8030;
        log = Category.getInstance((String)(class$edu$caltechUcla$sselCassel$nio$server$NonBlockingServer == null ? (class$edu$caltechUcla$sselCassel$nio$server$NonBlockingServer = NonBlockingServer.class$("edu.caltechUcla.sselCassel.nio.server.NonBlockingServer")) : class$edu$caltechUcla$sselCassel$nio$server$NonBlockingServer).getName());
        QUIT_SERVER = QUIT_SERVER;
        SHUTDOWN = SHUTDOWN;
        BUFSIZE = 8;
    }

    public class ChannelCallback {
        private SocketChannel channel;
        private StringBuffer buffer;

        public ChannelCallback(SocketChannel channel) {
            this.channel = channel;
            this.buffer = new StringBuffer();
        }

        public void execute() throws IOException {
            log.debug((Object)this.buffer.toString());
            NonBlockingServer.this.writeMessage(this.channel, this.buffer.toString());
            this.buffer = new StringBuffer();
        }

        public SocketChannel getChannel() {
            return this.channel;
        }

        public void append(String values) {
            this.buffer.append(values);
        }
    }
}

