/*
 * Decompiled with CFR 0.152.
 */
package edu.caltechUcla.sselCassel.jdbc;

import com.javaexchange.dbConnectionBroker.DbConnectionBroker;
import edu.caltechUcla.sselCassel.util.Constants;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Category;

public class SQLManager {
    public static final int BAD_CONN_ID = -2;
    private static Category log;
    private static final int SHUTDOWNTIME = 50;
    private static String dbDriver;
    private static String dbServer;
    private static String dbLogin;
    private static String dbPassword;
    private static int minConns;
    private static int maxConns;
    private static double maxConnTime;
    private static String dbLogFile;
    private static DbConnectionBroker dbBroker;
    private static Properties properties;
    private static int status;
    private static SQLManager sqlMgr;
    static /* synthetic */ Class class$edu$caltechUcla$sselCassel$jdbc$SQLManager;

    private SQLManager(Properties props) {
        SQLManager.loadProperties(props);
        if (dbBroker == null) {
            try {
                dbBroker = new DbConnectionBroker(dbDriver, dbServer, dbLogin, dbPassword, minConns, maxConns, dbLogFile, maxConnTime);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Establishing a data connection pool, with the following parameters-- " + Constants.LINESEP + "\tdb driver: " + dbDriver + Constants.LINESEP + "\tdb server: " + dbServer + Constants.LINESEP + "\tdb login: " + dbLogin));
                }
                status = 0;
            }
            catch (IOException e) {
                log.error((Object)("Failed to instantiate a db broker: " + e));
            }
        }
    }

    public static SQLManager getSQLManager(Properties props) {
        return sqlMgr == null ? (sqlMgr = new SQLManager(props)) : sqlMgr;
    }

    public static SQLManager getSQLManager() {
        return sqlMgr == null ? (sqlMgr = new SQLManager(null)) : sqlMgr;
    }

    private static void loadProperties(Properties props) {
        int c;
        if (props == null) {
            log.info((Object)"Using default values to configure SQLManager.");
            return;
        }
        String value = props.getProperty("dbDriver");
        if (value != null) {
            dbDriver = value;
        }
        if ((value = props.getProperty("dbServer")) != null) {
            dbServer = value;
        }
        if ((value = props.getProperty("dbLogin")) != null) {
            dbLogin = value;
        }
        if ((value = props.getProperty("dbPassword")) != null) {
            dbPassword = value;
        }
        if ((value = props.getProperty("dbLogFile")) != null) {
            dbLogFile = value;
        }
        if ((value = props.getProperty("minConns")) != null) {
            c = -1;
            try {
                c = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (c > 0) {
                minConns = c;
            }
        }
        if ((value = props.getProperty("maxConns")) != null) {
            c = -1;
            try {
                c = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (c > 0) {
                maxConns = c;
            }
        }
        properties = new Properties();
        properties.setProperty("dbDriver", dbDriver);
        properties.setProperty("dbServer", dbServer);
        properties.setProperty("dbLogin", dbLogin);
        properties.setProperty("dbPassword", dbPassword);
        properties.setProperty("dbLogFile", dbLogFile);
        properties.setProperty("minConns", Integer.toString(minConns));
        properties.setProperty("maxConns", Integer.toString(maxConns));
    }

    public Connection getConnection() {
        if (status == 0) {
            return dbBroker.getConnection();
        }
        return null;
    }

    public void cleanup() throws SQLException {
        if (status == 0) {
            dbBroker.destroy(50);
        }
    }

    public String freeConnection(Connection conn) {
        if (status == 0) {
            return dbBroker.freeConnection(conn);
        }
        return "Failed to free connection object: " + conn.toString() + " to the pool, as the SQLManager is not available!";
    }

    public int getConnectionId(Connection conn) {
        if (status == 0) {
            return dbBroker.idOfConnection(conn);
        }
        return -2;
    }

    public void destroy() throws SQLException {
        this.cleanup();
    }

    public Properties getProperties() {
        return properties;
    }

    public int ping() {
        return status;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        properties.setProperty("dbDriver", "org.gjt.mm.mysql.Driver");
        properties.setProperty("dbServer", "jdbc:mysql://localhost:3306/test");
        properties.setProperty("dbLogin", "test");
        properties.setProperty("dbPassword", "vanilla");
        properties.setProperty("dbLogFile", "db.log");
        properties.setProperty("minConns", Integer.toString(2));
        properties.setProperty("maxConns", Integer.toString(5));
        SQLManager sm = SQLManager.getSQLManager(properties);
        int max = 100;
        System.out.println("*** Sequential test *** ");
        long b = System.currentTimeMillis();
        try {
            int i = 0;
            while (i < max) {
                Connection conn = sm.getConnection();
                System.out.println("Obtain connection: " + sm.getConnectionId(conn));
                PreparedStatement ps = conn.prepareStatement("select now()");
                ResultSet rs = ps.executeQuery();
                rs.next();
                System.out.println(i + ": show time query result-- " + rs.getString(1));
                rs.close();
                ps.close();
                System.out.println(sm.freeConnection(conn));
                ++i;
            }
            sm.destroy();
            System.out.println("Time used: " + (System.currentTimeMillis() - b) + " to finish " + max + " number of queries");
            System.out.println("*** End of Sequential test ***");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BAD_CONN_ID = -2;
        log = Category.getInstance((Class)(class$edu$caltechUcla$sselCassel$jdbc$SQLManager == null ? (class$edu$caltechUcla$sselCassel$jdbc$SQLManager = SQLManager.class$("edu.caltechUcla.sselCassel.jdbc.SQLManager")) : class$edu$caltechUcla$sselCassel$jdbc$SQLManager));
        SHUTDOWNTIME = 50;
        dbDriver = "org.gjt.mm.mysql.Driver";
        dbServer = "jdbc:mysql://localhost:3306/test";
        dbLogin = "test";
        dbPassword = "vanilla";
        minConns = 2;
        maxConns = 20;
        maxConnTime = 1.0;
        dbLogFile = "db.log";
        dbBroker = null;
        properties = null;
        status = -1;
    }
}

