/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.army;

import edu.caltech.ssel.multistage.plugins.army.ArmyGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPanel
extends JPanel {
    private int startX;
    private int startY;
    private int otherStartX;
    private int otherStartY;
    private int numRows;
    private int numCols;
    private int clickNum;
    private int sequenceNum;
    private Hashtable<String, Integer> clickSequences;
    private String ownSymbol;
    private String otherSymbol;
    private String combinedSymbol;
    protected boolean mousePressed = false;
    protected boolean allowMouseInput;
    protected PathBox currentBox;
    protected PathBox previousBox;
    private ArmyGUI armyGui;

    public PathPanel(int nx, int ny, int sx, int sy, int osx, int osy, String ownS, String otherS, ArmyGUI gui) {
        this.setBackground(Color.WHITE);
        this.numRows = nx;
        this.numCols = ny;
        this.startX = sx;
        this.startY = sy;
        this.otherStartX = osx;
        this.otherStartY = osy;
        this.ownSymbol = ownS;
        this.otherSymbol = otherS;
        this.armyGui = gui;
        this.combinedSymbol = "<html>" + this.removeHtmls(this.ownSymbol) + this.removeHtmls(this.otherSymbol) + "</html>";
        this.clickNum = 0;
        this.clickSequences = new Hashtable();
        this.allowMouseInput = true;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int boxSize = (int)((double)screen.height * 0.85 / (double)(this.numRows * 2));
        PathBox[][] grid = new PathBox[this.numRows][this.numCols];
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[i].length; ++j) {
                if (this.startX == this.otherStartX && this.startY == this.otherStartY && i == this.startX && j == this.startY) {
                    grid[i][j] = new PathBox(i, j, this.combinedSymbol, this);
                    grid[i][j].previousSymbol = this.otherSymbol;
                } else {
                    grid[i][j] = i == this.otherStartX && j == this.otherStartY ? new PathBox(i, j, this.otherSymbol, this) : (i == this.startX && j == this.startY ? new PathBox(i, j, this.ownSymbol, this) : new PathBox(i, j, "", this));
                }
                grid[i][j].setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                grid[i][j].setPreferredSize(new Dimension(boxSize, boxSize));
                if (i == this.startX && j == this.startY) {
                    System.out.println("setting row " + i + ", col " + j + " to: " + this.ownSymbol);
                    this.currentBox = grid[i][j];
                } else if (i == this.otherStartX && j == this.otherStartY) {
                    System.out.println("setting row " + i + ", col " + j + " to: " + this.otherSymbol);
                }
                c.gridy = i + 1;
                c.gridx = j;
                this.add((Component)grid[i][j], c);
            }
        }
        this.validate();
        this.repaint();
    }

    private String removeHtmls(String s) {
        return s.replaceAll("<html>", "").replaceAll("</html>", "");
    }

    public void setAllowMouseInput(boolean b) {
        this.allowMouseInput = b;
    }

    public void setStartX(int s) {
        this.startX = s;
    }

    public void setStartY(int s) {
        this.startY = s;
    }

    public void setOtherStartX(int s) {
        this.otherStartX = s;
    }

    public void setOtherStartY(int s) {
        this.otherStartY = s;
    }

    public void setOwnSymbol(String s) {
        this.ownSymbol = s;
    }

    public void setOtherSymbol(String s) {
        this.otherSymbol = s;
    }

    public int getCurrentCol() {
        return this.currentBox.col;
    }

    public int getCurrentRow() {
        return this.currentBox.row;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.allowMouseInput = false;
    }

    public void reportStart(int r, int c) {
        this.sequenceNum = 0;
        this.armyGui.enableOkButton(true);
        this.clickSequences.put("click." + this.clickNum + ".row." + this.sequenceNum, r);
        this.clickSequences.put("click." + this.clickNum + ".col." + this.sequenceNum, c);
    }

    public void reportStop(int r, int c) {
        ++this.clickNum;
    }

    public void reportMove(int r, int c) {
        ++this.sequenceNum;
        this.clickSequences.put("click." + this.clickNum + ".row." + this.sequenceNum, r);
        this.clickSequences.put("click." + this.clickNum + ".col." + this.sequenceNum, c);
    }

    public Hashtable<String, Integer> getClickSequences() {
        return this.clickSequences;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        PathPanel pp = new PathPanel(8, 8, 5, 6, 5, 6, "<html><font color=\"red\">&#x25CF;</font></html>", "<html><font color=\"green\">&#x25CF;</font></html>", null);
        frame.add(pp);
        frame.setVisible(true);
    }

    protected class PathBox
    extends JLabel {
        private int row;
        private int col;
        private String symbol;
        private String previousSymbol;
        private PathPanel reportTo;

        public PathBox(int r, int c, String symb, PathPanel report) {
            super(symb, 0);
            this.reportTo = report;
            this.setFont(new Font("Arial", 1, 48));
            this.row = r;
            this.col = c;
            this.setText(symb);
            final PathBox box = this;
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (PathPanel.this.allowMouseInput && PathPanel.this.currentBox.equals(box)) {
                        PathPanel.this.mousePressed = true;
                        System.out.println(box.toString() + ", mouse pressed=true");
                        PathBox.this.reportTo.reportStart(PathBox.this.row, PathBox.this.col);
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (PathPanel.this.mousePressed && PathPanel.this.allowMouseInput) {
                        PathPanel.this.mousePressed = false;
                        System.out.println(box.toString() + ", mouse pressed=false");
                        PathBox.this.reportTo.reportStop(PathBox.this.row, PathBox.this.col);
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    if (PathPanel.this.allowMouseInput && PathPanel.this.mousePressed && PathBox.this.areAdjacent(box, PathPanel.this.currentBox)) {
                        System.out.println("changing to square: " + box.toString());
                        PathPanel.this.previousBox = PathPanel.this.currentBox;
                        PathPanel.this.previousBox.setText(PathPanel.this.previousBox.previousSymbol);
                        PathPanel.this.currentBox = box;
                        if (box.getText() != null && box.getText().equalsIgnoreCase(PathPanel.this.otherSymbol)) {
                            PathBox.this.previousSymbol = PathPanel.this.otherSymbol;
                            String combinedText = "<html>" + PathPanel.this.removeHtmls(PathPanel.this.ownSymbol) + PathPanel.this.removeHtmls(PathPanel.this.otherSymbol) + "</html>";
                            box.setText(combinedText);
                        } else {
                            box.setText(PathPanel.this.ownSymbol);
                        }
                        box.repaint();
                        PathBox.this.reportTo.reportMove(PathBox.this.row, PathBox.this.col);
                    }
                }

                public void mouseExited(MouseEvent e) {
                    if (PathPanel.this.mousePressed && PathPanel.this.allowMouseInput) {
                        System.out.println(box.toString() + ", mouseExited called...");
                    }
                }
            });
        }

        public String toString() {
            return "(" + this.row + "," + this.col + ") : " + this.getText();
        }

        public void setSymbol(String symb) {
            this.symbol = symb;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public boolean areAdjacent(PathBox a, PathBox b) {
            boolean adjacent = false;
            if (Math.abs(a.getRow() - b.getRow()) == 1 && a.getCol() == b.getCol()) {
                adjacent = true;
            } else if (Math.abs(a.getCol() - b.getCol()) == 1 && a.getRow() == b.getRow()) {
                adjacent = true;
            }
            System.out.println("a=" + a + ", b=" + b + (adjacent ? " ARE" : " ARE NOT") + " adjacent.");
            return adjacent;
        }
    }
}

