/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.army;

import edu.caltech.ssel.multistage.client.interfaces.ClientGUI;
import edu.caltech.ssel.multistage.plugins.army.PathPanel;
import edu.caltech.ssel.multistage.shared.data.ClientData;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import edu.caltech.ssel.multistage.shared.network.MessagePacket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class ArmyGUI
extends ClientGUI {
    private JPanel HistoryPanel;
    private String[] playerNames;
    private String[] playerSymbols;
    private JButton okButton;
    private int[] finalRows;
    private int[] finalCols;
    private int[][] startingPositions;
    private int numRows;
    private int numCols;
    private int index;
    private JPanel contentPanel;
    private JPanel buttonPanel;
    private String type;
    private String okButtonLabel;
    private String mountainsImage;
    private String treesImage;
    private String playerText;
    private String waitText;
    private String updateText;
    private String finalText;
    private String chooseText1;
    private String chooseText2;
    private String chooseText3;
    private String chooseTextTotal;
    private String treesIcon;
    private String mountainsIcon;
    private String updateText1;
    private String updateText2;
    private String updateText3;
    private String updateTextTotal;
    public static Category log = Logger.getLogger(ArmyGUI.class);

    private void initComponents() {
        this.HistoryPanel = new JPanel();
        this.HistoryPanel.setLayout(new BoxLayout(this.HistoryPanel, 1));
        this.HistoryPanel.add((Component)this.clientHistory);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(Color.WHITE);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.contentPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ArmyGUI.this.exitForm(evt);
            }
        });
    }

    public void initialize() {
        this.initComponents();
        this.rand = new Random();
        this.setVisible(false);
    }

    private void exitForm(WindowEvent evt) {
        this.exit();
    }

    public static void main(String[] args) {
    }

    protected void constructLayout(Information info, ClientData clientData) {
        try {
            this.type = info.getStringInfo((Object)"type");
            if (this.type.equalsIgnoreCase("choose")) {
                this.startingPositions = (int[][])info.getInfo((Object)"startingPositions");
                this.playerNames = (String[])info.getInfo((Object)"playerNames");
                this.numRows = info.getIntInfo((Object)"numRows");
                this.numCols = info.getIntInfo((Object)"numCols");
                this.chooseText1 = info.getStringInfo((Object)"chooseText1");
                this.chooseText2 = info.getStringInfo((Object)"chooseText2");
                this.chooseText3 = info.getStringInfo((Object)"chooseText3");
                this.chooseTextTotal = info.getStringInfo((Object)"chooseTextTotal");
                this.treesIcon = info.getStringInfo((Object)"treesIcon");
                this.mountainsIcon = info.getStringInfo((Object)"mountainsIcon");
                this.okButtonLabel = info.getStringInfo((Object)"okButtonLabel");
                this.index = info.getIntInfo((Object)"index");
                this.treesImage = info.getStringInfo((Object)"treesImage");
                this.mountainsImage = info.getStringInfo((Object)"mountainsImage");
                this.playerText = info.getStringInfo((Object)"playerText");
                this.playerSymbols = (String[])info.getInfo((Object)"playerSymbols");
                this.waitText = info.getStringInfo((Object)"waitText");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ArmyGUI.this.constructArmyLayout();
                    }
                });
            } else if (this.type.equalsIgnoreCase("update")) {
                this.playerNames = (String[])info.getInfo((Object)"playerNames");
                this.numRows = info.getIntInfo((Object)"numRows");
                this.numCols = info.getIntInfo((Object)"numCols");
                this.index = info.getIntInfo((Object)"index");
                this.treesImage = info.getStringInfo((Object)"treesImage");
                this.mountainsImage = info.getStringInfo((Object)"mountainsImage");
                this.playerText = info.getStringInfo((Object)"playerText");
                this.playerSymbols = (String[])info.getInfo((Object)"playerSymbols");
                this.finalRows = (int[])info.getInfo((Object)"finalRows");
                this.finalCols = (int[])info.getInfo((Object)"finalCols");
                this.updateText1 = info.getStringInfo((Object)"updateText1");
                this.updateText2 = info.getStringInfo((Object)"updateText2");
                this.updateText3 = info.getStringInfo((Object)"updateText3");
                this.updateTextTotal = info.getStringInfo((Object)"updateTextTotal");
                this.treesIcon = info.getStringInfo((Object)"treesIcon");
                this.mountainsIcon = info.getStringInfo((Object)"mountainsIcon");
                this.finalText = info.getStringInfo((Object)"finalText");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ArmyGUI.this.constructUpdateLayout();
                    }
                });
                this.makeMove();
            }
            Runnable doUpdate = new Runnable(){

                public void run() {
                    if (!ArmyGUI.this.isVisible()) {
                        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                        ArmyGUI.this.setSize(screen);
                        int iCenterX = screen.width / 2;
                        int iCenterY = screen.height / 2;
                        ArmyGUI.this.setLocation(iCenterX - screen.width / 2, iCenterY - screen.height / 2);
                    }
                    ArmyGUI.this.setVisible(true);
                }
            };
            SwingUtilities.invokeAndWait(doUpdate);
        }
        catch (Exception e) {
            log.error((Object)"Failed to construct game layout");
            e.printStackTrace();
        }
    }

    private void constructArmyLayout() {
        long startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 16);
        JLabel player = new JLabel(this.parseString(this.playerText), 0);
        player.setFont(new Font("Arial", 1, 32));
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 10, 0);
        this.contentPanel.add((Component)player, c);
        JPanel middle = new JPanel();
        middle.setBackground(Color.WHITE);
        middle.setLayout(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        JLabel mountains = new JLabel();
        mountains.setIcon(new ImageIcon(this.mountainsImage));
        mountains.setFont(labelFont);
        mc.gridy = 0;
        mc.gridx = 0;
        mc.gridwidth = 1;
        mc.anchor = 22;
        middle.add((Component)mountains, mc);
        int otherIndex = (this.index + 1) % 2;
        System.out.println("ownSymbol = " + this.playerSymbols[this.index] + ", otherSymbol=" + this.playerSymbols[otherIndex]);
        final PathPanel pp = new PathPanel(this.numRows, this.numCols, this.startingPositions[this.index][0], this.startingPositions[this.index][1], -1, -1, this.playerSymbols[this.index], this.playerSymbols[otherIndex], this);
        mc.gridx = 1;
        mc.anchor = 10;
        mc.gridwidth = 1;
        middle.add((Component)pp, mc);
        JLabel forest = new JLabel();
        forest.setIcon(new ImageIcon(this.treesImage));
        forest.setFont(labelFont);
        mc.gridx = 1;
        mc.gridy = 1;
        middle.add((Component)forest, mc);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        this.contentPanel.add((Component)middle, c);
        this.okButton = new JButton(this.parseString(this.okButtonLabel));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArmyGUI.this.addIntInfo("currentRow", pp.getCurrentRow());
                ArmyGUI.this.addIntInfo("currentCol", pp.getCurrentCol());
                ArmyGUI.this.addInfo("clickSequences", pp.getClickSequences());
                ArmyGUI.this.makeMove();
                ArmyGUI.this.okButton.setEnabled(false);
                pp.setAllowMouseInput(false);
                ArmyGUI.this.constructWaitLayout();
            }
        });
        this.okButton.setEnabled(false);
        this.okButton.setFocusable(false);
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.contentPanel.add((Component)this.okButton, c);
        JPanel bottom = new JPanel();
        bottom.setBackground(Color.WHITE);
        JLabel one = new JLabel(this.parseString(this.chooseText1), 0);
        one.setFont(labelFont);
        JLabel miniTree = new JLabel();
        miniTree.setIcon(new ImageIcon(this.treesIcon));
        JLabel two = new JLabel(this.parseString(this.chooseText2), 0);
        two.setFont(labelFont);
        JLabel miniMount = new JLabel();
        miniMount.setIcon(new ImageIcon(this.mountainsIcon));
        JLabel three = new JLabel(this.parseString(this.chooseText3), 0);
        three.setFont(labelFont);
        bottom.add(one);
        bottom.add(Box.createHorizontalStrut(10));
        bottom.add(miniTree);
        bottom.add(two);
        bottom.add(Box.createHorizontalStrut(10));
        bottom.add(miniMount);
        bottom.add(three);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        this.contentPanel.add((Component)bottom, c);
        JLabel total = new JLabel(this.parseString(this.chooseTextTotal), 0);
        total.setFont(labelFont);
        c.gridy = 4;
        this.contentPanel.add((Component)total, c);
        this.validate();
        this.repaint();
    }

    protected void enableOkButton(boolean enable) {
        this.okButton.setEnabled(enable);
    }

    private void constructUpdateLayout() {
        long startTime = System.currentTimeMillis();
        this.contentPanel.removeAll();
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Font labelFont = new Font("Arial", 1, 16);
        JLabel player = new JLabel(this.parseString(this.playerText), 0);
        player.setFont(new Font("Arial", 1, 32));
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 10, 0);
        this.contentPanel.add((Component)player, c);
        JPanel middle = new JPanel();
        middle.setBackground(Color.WHITE);
        middle.setLayout(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        JLabel mountains = new JLabel();
        mountains.setIcon(new ImageIcon(this.mountainsImage));
        mountains.setFont(labelFont);
        mc.gridy = 0;
        mc.gridx = 0;
        mc.gridwidth = 1;
        mc.anchor = 22;
        middle.add((Component)mountains, mc);
        int otherIndex = (this.index + 1) % 2;
        System.out.println("ownSymbol = " + this.playerSymbols[this.index] + ", otherSymbol=" + this.playerSymbols[otherIndex]);
        PathPanel pp = new PathPanel(this.numRows, this.numCols, this.finalRows[this.index], this.finalCols[this.index], this.finalRows[otherIndex], this.finalCols[otherIndex], this.playerSymbols[this.index], this.playerSymbols[otherIndex], this);
        pp.setEnabled(false);
        mc.gridx = 1;
        mc.anchor = 10;
        mc.gridwidth = 1;
        pp.setEnabled(false);
        middle.add((Component)pp, mc);
        JLabel forest = new JLabel();
        forest.setIcon(new ImageIcon(this.treesImage));
        forest.setFont(labelFont);
        mc.gridx = 1;
        mc.gridy = 1;
        middle.add((Component)forest, mc);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        this.contentPanel.add((Component)middle, c);
        JPanel bottom = new JPanel();
        bottom.setBackground(Color.WHITE);
        JLabel one = new JLabel(this.parseString(this.updateText1), 0);
        one.setFont(labelFont);
        JLabel miniTree = new JLabel();
        miniTree.setIcon(new ImageIcon(this.treesIcon));
        JLabel two = new JLabel(this.parseString(this.updateText2), 0);
        two.setFont(labelFont);
        JLabel miniMount = new JLabel();
        miniMount.setIcon(new ImageIcon(this.mountainsIcon));
        JLabel three = new JLabel(this.parseString(this.updateText3), 0);
        three.setFont(labelFont);
        bottom.add(one);
        bottom.add(Box.createHorizontalStrut(10));
        bottom.add(miniTree);
        bottom.add(two);
        bottom.add(Box.createHorizontalStrut(10));
        bottom.add(miniMount);
        bottom.add(three);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        this.contentPanel.add((Component)bottom, c);
        JLabel total = new JLabel(this.parseString(this.updateTextTotal), 0);
        total.setFont(labelFont);
        c.gridy = 4;
        this.contentPanel.add((Component)total, c);
        JLabel finalLabel = new JLabel(this.parseString(this.finalText), 0);
        finalLabel.setFont(labelFont);
        c.insets = new Insets(15, 0, 0, 0);
        c.gridy = 5;
        this.contentPanel.add((Component)finalLabel, c);
        this.validate();
        this.repaint();
    }

    private void constructWaitLayout() {
        this.contentPanel.removeAll();
        JLabel wait = new JLabel(this.parseString(this.waitText), 0);
        wait.setFont(new Font("Arial", 1, 16));
        this.contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.contentPanel.add((Component)wait, c);
        this.validate();
        this.repaint();
    }

    public void processMessage(MessagePacket mes) {
        try {
            if (mes.getType() == 5) {
                Information information = (Information)mes.getObject();
            } else {
                super.processMessage(mes);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to process a game-specific message in the compromise gui" + MSConstants.newline + e));
        }
    }

    public void testingProcedures() {
        int numChoices = 2;
        int move = this.rand.nextInt(numChoices);
        long time = new Long(this.rand.nextInt(5000));
        this.addInfo("move", "" + move);
        this.addInfo("time", "" + time);
    }

    public void respond(Object obj) {
    }

    public void close() {
    }

    public void reauthenticate() {
    }

    protected void constructWaitingLayout(Information info) {
    }
}

