/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.army;

import edu.caltech.ssel.multistage.server.control.AbortRoundException;
import edu.caltech.ssel.multistage.server.control.MessageProcessor;
import edu.caltech.ssel.multistage.server.control.ServerControl;
import edu.caltech.ssel.multistage.shared.data.Information;
import edu.caltech.ssel.multistage.shared.network.MSConstants;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class ArmyControl
extends ServerControl {
    private String[] playerNames;
    private String[] playerSymbols;
    private int[][] startingPositions;
    private float x;
    private float y;
    private float z;
    private int numRows;
    private int numCols;
    private String chooseText;
    private String okButtonLabel;
    private String treesImage;
    private String mountainsImage;
    private String playerText;
    private String payoffComparison;
    private String waitText;
    private String finalText;
    private String chooseTextTotal;
    private String treesIcon;
    private String mountainsIcon;
    private String updateTextTotal;
    private String[] chooseText1;
    private String[] chooseText2;
    private String[] chooseText3;
    private String[] updateText1;
    private String[] updateText2;
    private String[] updateText3;
    private boolean showFinalScreen;
    public static Category log = Logger.getLogger(ArmyControl.class);

    public void initialize() {
        try {
            int i;
            this.playerNames = new String[groupSize];
            this.playerSymbols = new String[groupSize];
            for (i = 0; i < groupSize; ++i) {
                this.playerNames[i] = this.testedStringProperty("player." + i);
                this.playerSymbols[i] = this.testedStringProperty("player." + i + ".symbol");
            }
            this.startingPositions = new int[groupSize][2];
            for (i = 0; i < groupSize; ++i) {
                String sp = this.getStringProperty("player." + i + ".startingPosition");
                String[] split = sp.split(",");
                this.startingPositions[i][0] = Integer.parseInt(split[0].trim());
                this.startingPositions[i][1] = Integer.parseInt(split[1].trim());
                System.out.println("player " + i + ": " + this.startingPositions[i][0] + "," + this.startingPositions[i][1]);
            }
            this.numRows = this.getIntProperty("numRows", 8);
            this.numCols = this.getIntProperty("numCols", 8);
            this.x = this.getFloatProperty("x");
            this.y = this.getFloatProperty("y");
            this.z = this.getFloatProperty("z");
            this.payoffComparison = this.getStringProperty("payoffComparison", "any");
            this.showFinalScreen = this.getBooleanProperty("showFinalScreen", false);
            this.chooseText1 = new String[groupSize];
            this.chooseText2 = new String[groupSize];
            this.chooseText3 = new String[groupSize];
            this.updateText1 = new String[groupSize];
            this.updateText2 = new String[groupSize];
            this.updateText3 = new String[groupSize];
            for (i = 0; i < groupSize; ++i) {
                this.chooseText1[i] = this.testedStringProperty("gui.chooseText1." + i);
                this.chooseText2[i] = this.testedStringProperty("gui.chooseText2." + i);
                this.chooseText3[i] = this.testedStringProperty("gui.chooseText3." + i);
                this.updateText1[i] = this.testedStringProperty("gui.updateText1." + i);
                this.updateText2[i] = this.testedStringProperty("gui.updateText2." + i);
                this.updateText3[i] = this.testedStringProperty("gui.updateText3." + i);
            }
            this.treesIcon = this.testedStringProperty("treesIcon");
            this.mountainsIcon = this.testedStringProperty("mountainsIcon");
            this.chooseTextTotal = this.testedStringProperty("gui.chooseTextTotal");
            this.updateTextTotal = this.testedStringProperty("gui.updateTextTotal");
            this.okButtonLabel = this.testedStringProperty("gui.okButtonLabel");
            this.treesImage = this.testedStringProperty("treesImage");
            this.mountainsImage = this.testedStringProperty("mountainsImage");
            this.playerText = this.testedStringProperty("gui.playerText");
            this.waitText = this.testedStringProperty("gui.waitText");
            this.finalText = this.testedStringProperty("gui.finalText");
        }
        catch (Exception e) {
            log.error((Object)("Failed to initialize Army controller" + MSConstants.newline + e));
            e.printStackTrace();
        }
    }

    public void runSequence() throws AbortRoundException {
        try {
            int i;
            this.initHistoryTable();
            if (this.getStringProperty("askQuestions") != null && this.getStringProperty("askQuestions").equalsIgnoreCase("true")) {
                Vector[][] questions = this.constructQuestions();
                this.questionSubjectsPostMatch(questions);
            }
            DecimalFormat df = new DecimalFormat("0");
            Information[] info = new Information[groupSize];
            for (int i2 = 0; i2 < info.length; ++i2) {
                info[i2] = new Information();
                info[i2].addStringInfo((Object)"type", "choose");
                info[i2].addInfo((Object)"playerNames", (Object)this.playerNames);
                info[i2].addInfo((Object)"playerSymbols", (Object)this.playerSymbols);
                info[i2].addInfo((Object)"startingPositions", (Object)this.startingPositions);
                info[i2].addIntInfo((Object)"numRows", this.numRows);
                info[i2].addIntInfo((Object)"numCols", this.numCols);
                info[i2].addStringInfo((Object)"chooseText1", this.chooseText1[i2]);
                info[i2].addStringInfo((Object)"chooseText2", this.chooseText2[i2]);
                info[i2].addStringInfo((Object)"chooseText3", this.chooseText3[i2]);
                info[i2].addStringInfo((Object)"chooseTextTotal", this.chooseTextTotal);
                info[i2].addStringInfo((Object)"treesIcon", this.treesIcon);
                info[i2].addStringInfo((Object)"mountainsIcon", this.mountainsIcon);
                info[i2].addIntInfo((Object)"index", i2);
                info[i2].addStringInfo((Object)"ownName", this.removeHtmls(this.playerNames[i2]));
                info[i2].addStringInfo((Object)"otherName", this.removeHtmls(this.playerNames[(i2 + 1) % 2]));
                info[i2].addStringInfo((Object)"okButtonLabel", this.okButtonLabel);
                info[i2].addStringInfo((Object)"treesImage", this.treesImage);
                info[i2].addStringInfo((Object)"mountainsImage", this.mountainsImage);
                info[i2].addStringInfo((Object)"playerText", this.playerText);
                info[i2].addStringInfo((Object)"waitText", this.waitText);
                info[i2].addStringInfo((Object)"x", df.format(this.x));
                info[i2].addStringInfo((Object)"y", df.format(this.y));
                info[i2].addStringInfo((Object)"z", df.format(this.z));
                if (i2 == 0) {
                    info[i2].addStringInfo((Object)"total", df.format(this.x + this.z));
                    continue;
                }
                info[i2].addStringInfo((Object)"total", df.format(this.x + this.y));
            }
            Information[] results = this.askAllPlayers(info);
            float[] payoffs = new float[groupSize];
            int[] finalRows = new int[groupSize];
            int[] finalCols = new int[groupSize];
            Hashtable[] clickSequences = new Hashtable[groupSize];
            for (int i3 = 0; i3 < groupSize; ++i3) {
                finalRows[i3] = results[i3].getIntInfo((Object)"currentRow");
                finalCols[i3] = results[i3].getIntInfo((Object)"currentCol");
                this.addOutput(i3, "paidRow", String.valueOf(finalRows[i3]));
                this.addOutput(i3, "paidCol", String.valueOf(finalCols[i3]));
                clickSequences[i3] = (Hashtable)results[i3].getInfo((Object)"clickSequences");
                payoffs[i3] = this.x;
            }
            float[] treeWinnings = new float[groupSize];
            float[] mountainWinnings = new float[groupSize];
            for (i = 0; i < groupSize; ++i) {
                treeWinnings[i] = 0.0f;
                mountainWinnings[i] = 0.0f;
            }
            if (this.payoffComparison.equalsIgnoreCase("any")) {
                System.out.println("finalCols[0]==" + finalCols[0] + ", finalCols[1]==" + finalCols[1]);
                System.out.println("finalRows[0]==" + finalRows[0] + ", finalRows[1]==" + finalRows[1]);
                if (finalCols[0] <= finalCols[1]) {
                    payoffs[0] = payoffs[0] + this.z;
                    mountainWinnings[0] = mountainWinnings[0] + this.z;
                } else if (finalCols[1] < finalCols[0]) {
                    payoffs[1] = payoffs[1] + this.z;
                    mountainWinnings[1] = mountainWinnings[1] + this.z;
                }
                if (finalRows[0] > finalRows[1]) {
                    payoffs[0] = payoffs[0] + this.y;
                    treeWinnings[0] = treeWinnings[0] + this.y;
                } else if (finalRows[1] >= finalRows[0]) {
                    payoffs[1] = payoffs[1] + this.y;
                    treeWinnings[1] = treeWinnings[1] + this.y;
                }
            } else {
                int threshold = Integer.parseInt(this.payoffComparison.trim());
                if (finalRows[0] - finalRows[1] == threshold) {
                    payoffs[0] = payoffs[0] + this.y;
                    treeWinnings[0] = treeWinnings[0] + this.y;
                } else if (finalRows[1] - finalRows[0] == threshold) {
                    payoffs[1] = payoffs[1] + this.y;
                    treeWinnings[1] = treeWinnings[1] + this.y;
                }
                if (finalCols[1] - finalCols[0] == threshold) {
                    payoffs[0] = payoffs[0] + this.z;
                    mountainWinnings[0] = mountainWinnings[0] + this.z;
                } else if (finalCols[0] - finalCols[1] == threshold) {
                    payoffs[1] = payoffs[1] + this.z;
                    mountainWinnings[1] = mountainWinnings[1] + this.z;
                }
            }
            for (i = 0; i < groupSize; ++i) {
                this.addOutput(i, "subjectName", this.clientData[i].getName());
                this.addOutput(i, "playerName", this.removeHtmls(this.playerNames[i]));
            }
            this.addPayoffs(payoffs);
            for (i = 0; i < groupSize; ++i) {
                this.addOutput(i, "startingRow", String.valueOf(this.startingPositions[i][0]));
                this.addOutput(i, "startingColumn", String.valueOf(this.startingPositions[i][0]));
            }
            for (i = 0; i < groupSize; ++i) {
                int numClicks = 0;
                while (clickSequences[i].keySet().contains("click." + numClicks + ".row.0")) {
                    ++numClicks;
                }
                for (int n = 0; n < numClicks; ++n) {
                    int numSquares = 0;
                    while (clickSequences[i].keySet().contains("click." + n + ".row." + numSquares)) {
                        ++numSquares;
                    }
                    System.out.println("adding output: click." + n + ".row." + (numSquares - 1) + ": " + String.valueOf(clickSequences[i].get("click." + n + ".row." + (numSquares - 1))));
                    this.addOutput(i, "click." + n + ".finalRow", String.valueOf(clickSequences[i].get("click." + n + ".row." + (numSquares - 1))));
                    this.addOutput(i, "click." + n + ".finalCol", String.valueOf(clickSequences[i].get("click." + n + ".col." + (numSquares - 1))));
                }
            }
            Information[] update = new Information[groupSize];
            for (int i4 = 0; i4 < groupSize; ++i4) {
                update[i4] = new Information();
                update[i4].addStringInfo((Object)"type", "update");
                update[i4].addInfo((Object)"playerNames", (Object)this.playerNames);
                update[i4].addInfo((Object)"playerSymbols", (Object)this.playerSymbols);
                update[i4].addIntInfo((Object)"numRows", this.numRows);
                update[i4].addIntInfo((Object)"numCols", this.numCols);
                update[i4].addIntInfo((Object)"index", i4);
                update[i4].addStringInfo((Object)"ownName", this.removeHtmls(this.playerNames[i4]));
                update[i4].addStringInfo((Object)"otherName", this.removeHtmls(this.playerNames[(i4 + 1) % 2]));
                update[i4].addInfo((Object)"finalRows", (Object)finalRows);
                update[i4].addInfo((Object)"finalCols", (Object)finalCols);
                update[i4].addStringInfo((Object)"treesImage", this.treesImage);
                update[i4].addStringInfo((Object)"mountainsImage", this.mountainsImage);
                update[i4].addStringInfo((Object)"playerText", this.playerText);
                update[i4].addStringInfo((Object)"payoff", df.format(payoffs[i4]));
                update[i4].addStringInfo((Object)"x", df.format(this.x));
                update[i4].addStringInfo((Object)"y", df.format(this.y));
                update[i4].addStringInfo((Object)"z", df.format(this.z));
                if (this.showFinalScreen && this.isLastRound()) {
                    update[i4].addStringInfo((Object)"finalText", this.finalText);
                    update[i4].addStringInfo((Object)"totalPay", df.format(this.clientData[i4].getTotalPayoff()));
                } else {
                    update[i4].addStringInfo((Object)"finalText", "");
                }
                update[i4].addStringInfo((Object)"treesWinnings", df.format(treeWinnings[i4]));
                update[i4].addStringInfo((Object)"mountainsWinnings", df.format(mountainWinnings[i4]));
                update[i4].addStringInfo((Object)"updateText1", this.updateText1[i4]);
                update[i4].addStringInfo((Object)"updateText2", this.updateText2[i4]);
                update[i4].addStringInfo((Object)"updateText3", this.updateText3[i4]);
                update[i4].addStringInfo((Object)"updateTextTotal", this.updateTextTotal);
                update[i4].addStringInfo((Object)"treesIcon", this.treesIcon);
                update[i4].addStringInfo((Object)"mountainsIcon", this.mountainsIcon);
            }
            this.askAllPlayers(update);
        }
        catch (AbortRoundException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to run the Army main game sequence" + newline + e));
            e.printStackTrace();
            throw new AbortRoundException();
        }
    }

    private String removeHtmls(String s) {
        return s.replaceAll("<html>", "").replaceAll("</html>", "");
    }

    private void initHistoryTable() {
        for (int i = 0; i < groupSize; ++i) {
        }
    }

    protected Information[] processRound(MessageProcessor proc) throws AbortRoundException {
        return null;
    }

    private String testedStringProperty(String keyword) {
        String defaultVal = "#$%UNCOMMON DEFAULT VALUE!%$#";
        String val = this.getStringProperty(keyword, "#$%UNCOMMON DEFAULT VALUE!%$#");
        if (val.equalsIgnoreCase("#$%UNCOMMON DEFAULT VALUE!%$#")) {
            log.error((Object)(keyword + "incorrectly read from properties file.  Using default value '" + keyword + "'"));
            System.out.println(keyword + "incorrectly read from properties file.  Using default value '" + keyword + "'");
            val = keyword;
        }
        return val;
    }
}

