/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import edu.caltech.ssel.multistage.plugins.hide.HideGUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HintPanel
extends JPanel {
    private int spotDiameter;
    private int closestCircle;
    private int offsetX;
    private int offsetY;
    private float[] positions;
    private int numCircles;
    private int chosenCircle = -1;
    private boolean init;
    private boolean enabled;
    private boolean drawTokens;
    private boolean drawNumber;
    private HideGUI hgui;
    private static final int BORDER = 75;
    private DecimalFormat df = new DecimalFormat("0");

    public HintPanel(float[] positionPayoffs, HideGUI gui) {
        this.hgui = gui;
        this.positions = new float[positionPayoffs.length];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = positionPayoffs[i];
        }
        this.numCircles = this.positions.length;
        this.enabled = true;
        this.init = true;
        this.drawTokens = false;
        this.drawNumber = true;
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (HintPanel.this.enabled) {
                    for (int i = 0; i < HintPanel.this.numCircles; ++i) {
                        if (!(HintPanel.this.positions[i] > 0.0f) || !HintPanel.this.circleContainsPoint(i, e.getPoint())) continue;
                        HintPanel.this.chosenCircle = i;
                        HintPanel.this.hgui.hintNotify(true);
                        HintPanel.this.repaint();
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                if (HintPanel.this.enabled) {
                    // empty if block
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (HintPanel.this.enabled) {
                    // empty if block
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.validate();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintChildren(g);
        Dimension size = this.getPreferredSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(g2.getBackground());
        g2.fillRect(0, 0, size.width, size.height);
        g2.setColor(Color.BLACK);
        int centerX = size.width / 2;
        int centerY = (size.height - 75) / 2;
        this.spotDiameter = size.width / 4;
        int distFromCenter = size.width / 2 - this.spotDiameter / 2 - 10;
        int[] xCenters = new int[this.numCircles];
        int[] yCenters = new int[this.numCircles];
        g2.setFont(new Font("Arial", 1, 24));
        FontMetrics fm = g2.getFontMetrics();
        for (int i = 0; i < this.numCircles; ++i) {
            int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)i / 9.0));
            int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)i / 9.0));
            xCenters[i] = centerX + x;
            yCenters[i] = centerY + y;
            Stroke originalStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(4.0f));
            if (this.positions[i] > 0.0f) {
                if (i == this.chosenCircle) {
                    g2.setColor(Color.BLUE);
                } else {
                    g2.setColor(Color.BLACK);
                }
                g2.drawOval(xCenters[i] - this.spotDiameter / 2, yCenters[i] - this.spotDiameter / 2, this.spotDiameter, this.spotDiameter);
                Rectangle2D stringBounds = fm.getStringBounds(this.df.format(this.positions[i]), g);
                if (this.drawTokens) {
                    this.drawTokens(g2, xCenters[i], yCenters[i] + this.spotDiameter / 2, (int)this.positions[i]);
                }
                if (this.drawNumber) {
                    g2.drawString(this.df.format(this.positions[i]), xCenters[i] - fm.stringWidth(this.df.format(this.positions[i])) / 2, (int)((double)(yCenters[i] + this.spotDiameter / 2) + stringBounds.getHeight() / 2.0 + (double)(fm.getAscent() / 2)));
                }
            }
            g2.setStroke(originalStroke);
        }
    }

    public void setDrawTokens(boolean b) {
        this.drawTokens = b;
        this.drawNumber = !b;
    }

    private void drawTokens(Graphics2D g2, int x, int y, int numTokens) {
        int tokenWidth = 15;
        int numSide = 4;
        int lhs = x - tokenWidth * numSide / 2;
        Stroke originalStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < numTokens / numSide + 1; ++i) {
            for (int j = 0; j < numSide && i * numSide + j < numTokens; ++j) {
                g2.setColor(Color.YELLOW);
                g2.fillOval(lhs + j * tokenWidth, y + i * tokenWidth + 10, tokenWidth, tokenWidth);
                g2.setColor(Color.BLACK);
                g2.drawOval(lhs + j * tokenWidth, y + i * tokenWidth + 10, tokenWidth, tokenWidth);
            }
        }
        g2.setStroke(originalStroke);
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.enabled = e;
    }

    private float polarToX(float r, float theta) {
        return r * (float)Math.cos(theta);
    }

    private float polarToY(float r, float theta) {
        return r * (float)Math.sin(theta);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        float[] values = new float[]{11.0f, 1.0f, 2.0f, 3.0f, 2.0f, 6.0f, 4.0f, 12.0f};
        HintPanel hp = new HintPanel(values, null);
        hp.setDrawTokens(true);
        hp.setPreferredSize(new Dimension(800, 920));
        frame.add(hp);
        frame.setSize(new Dimension(830, 950));
        frame.setVisible(true);
    }

    public int getHidingSpot() {
        return this.chosenCircle;
    }

    public void setHidingSpot(int hs) {
        this.chosenCircle = hs;
    }

    private boolean circleContainsPoint(int circleNum, Point p) {
        int y;
        int yCenter;
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int xCenter = centerX + x;
        return Point.distance(p.x, p.y, xCenter, yCenter = centerY + (y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0)))) <= (double)(this.spotDiameter / 2);
    }

    private int getCircleX(int circleNum) {
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        return centerX + x;
    }

    private int getCircleY(int circleNum) {
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        return centerY + y;
    }
}

