/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.ssel.multistage.plugins.hide;

import edu.caltech.ssel.multistage.plugins.hide.HideGUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HidePanel
extends JPanel {
    private int spotDiameter;
    private int closestCircle;
    private int presentX;
    private int presentY;
    private int presentSize;
    private int offsetX;
    private int offsetY;
    private float[] positions;
    private int numCircles;
    private int chosenCircle = -1;
    private Image present;
    private boolean presentDragging;
    private boolean init;
    private boolean enabled;
    private boolean drawTokens;
    private boolean drawNumber;
    private HideGUI hgui;
    private static final int BORDER = 75;
    private DecimalFormat df = new DecimalFormat("0");

    public HidePanel(String imageLocation, float[] positionPayoffs, HideGUI gui) {
        this.hgui = gui;
        this.positions = new float[positionPayoffs.length];
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = positionPayoffs[i];
        }
        this.numCircles = this.positions.length;
        this.enabled = true;
        this.init = true;
        this.drawTokens = false;
        this.drawNumber = true;
        try {
            this.present = ImageIO.read(new File(imageLocation));
        }
        catch (IOException ex) {
            System.out.println("can't read file at location: " + imageLocation);
            Logger.getLogger(HidePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (HidePanel.this.enabled) {
                    HidePanel.this.offsetX = e.getPoint().x - HidePanel.this.presentX;
                    HidePanel.this.offsetY = e.getPoint().y - HidePanel.this.presentY;
                    if (e.getPoint().x >= HidePanel.this.presentX && e.getPoint().x <= HidePanel.this.presentX + HidePanel.this.present.getWidth(null) && e.getPoint().y >= HidePanel.this.presentY && e.getPoint().y <= HidePanel.this.presentY + HidePanel.this.present.getHeight(null)) {
                        HidePanel.this.chosenCircle = -1;
                        HidePanel.this.hgui.hideNotify(false);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (HidePanel.this.enabled) {
                    HidePanel.this.presentDragging = false;
                    Point position = e.getPoint();
                    for (int i = 0; i < HidePanel.this.positions.length; ++i) {
                        if (!(HidePanel.this.positions[i] > 0.0f) || !HidePanel.this.circleContainsPoint(i, position)) continue;
                        HidePanel.this.chosenCircle = i;
                        HidePanel.this.presentX = HidePanel.this.getCircleX(HidePanel.this.chosenCircle) - HidePanel.this.present.getWidth(null) / 2;
                        HidePanel.this.presentY = HidePanel.this.getCircleY(HidePanel.this.chosenCircle) - HidePanel.this.present.getHeight(null) / 2;
                        HidePanel.this.repaint();
                        HidePanel.this.hgui.hideNotify(true);
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
            }
        });
        this.validate();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintChildren(g);
        Dimension size = this.getPreferredSize();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setColor(g2.getBackground());
        g2.fillRect(0, 0, size.width, size.height);
        g2.setColor(Color.BLACK);
        int centerX = size.width / 2;
        int centerY = (size.height - 75) / 2;
        if (this.init) {
            this.presentX = centerX - this.present.getWidth(null) / 2;
            this.presentY = centerY - this.present.getHeight(null) / 2;
            this.init = false;
        }
        this.spotDiameter = size.width / 4;
        this.presentSize = this.spotDiameter / 2;
        int distFromCenter = size.width / 2 - this.spotDiameter / 2 - 10;
        int[] xCenters = new int[this.numCircles];
        int[] yCenters = new int[this.numCircles];
        g2.setFont(new Font("Arial", 1, 48));
        FontMetrics fm = g2.getFontMetrics();
        for (int i = 0; i < this.numCircles; ++i) {
            int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)i / 9.0));
            int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)i / 9.0));
            xCenters[i] = centerX + x;
            yCenters[i] = centerY + y;
            Stroke originalStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(4.0f));
            if (this.positions[i] > 0.0f) {
                g2.drawOval(xCenters[i] - this.spotDiameter / 2, yCenters[i] - this.spotDiameter / 2, this.spotDiameter, this.spotDiameter);
                Rectangle2D stringBounds = fm.getStringBounds(this.df.format(this.positions[i]), g);
                if (this.drawTokens) {
                    this.drawTokens(g2, xCenters[i], yCenters[i] + this.spotDiameter / 2, (int)this.positions[i]);
                }
                if (this.drawNumber) {
                    g2.drawString(this.df.format(this.positions[i]), xCenters[i] - fm.stringWidth(this.df.format(this.positions[i])) / 2, (int)((double)(yCenters[i] + this.spotDiameter / 2) + stringBounds.getHeight() / 2.0 + (double)(fm.getAscent() / 2)));
                }
            }
            g2.setStroke(originalStroke);
        }
        if (this.presentDragging || this.chosenCircle < 0) {
            this.drawPresent(g2, this.presentX, this.presentY);
        } else {
            this.drawPresent(g2, xCenters[this.chosenCircle] - this.present.getWidth(null) / 2, yCenters[this.chosenCircle] - this.present.getHeight(null) / 2);
        }
    }

    public void setDrawTokens(boolean b) {
        this.drawTokens = b;
        this.drawNumber = !b;
    }

    private void drawTokens(Graphics2D g2, int x, int y, int numTokens) {
        int tokenWidth = 15;
        int numSide = 4;
        int lhs = x - tokenWidth * numSide / 2;
        Stroke originalStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < numTokens / numSide + 1; ++i) {
            for (int j = 0; j < numSide && i * numSide + j < numTokens; ++j) {
                g2.setColor(Color.YELLOW);
                g2.fillOval(lhs + j * tokenWidth, y + i * tokenWidth + 10, tokenWidth, tokenWidth);
                g2.setColor(Color.BLACK);
                g2.drawOval(lhs + j * tokenWidth, y + i * tokenWidth + 10, tokenWidth, tokenWidth);
            }
        }
        g2.setStroke(originalStroke);
    }

    private void drawPresent(Graphics2D g2, int x, int y) {
        g2.setColor(Color.BLUE);
        g2.drawImage(this.present, x, y, null);
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.enabled = e;
    }

    private float polarToX(float r, float theta) {
        return r * (float)Math.cos(theta);
    }

    private float polarToY(float r, float theta) {
        return r * (float)Math.sin(theta);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        float[] values = new float[]{21.0f, 1.0f, 15.0f, 31.0f, 2.0f, 6.0f, 4.0f, 1.0f, 2.0f};
        HidePanel hp = new HidePanel("C:\\present.jpg", values, null);
        hp.setDrawTokens(true);
        hp.setPreferredSize(new Dimension(800, 920));
        frame.add(hp);
        frame.setSize(new Dimension(830, 950));
        frame.setVisible(true);
    }

    public int getHidingSpot() {
        return this.chosenCircle;
    }

    public void setHidingSpot(int hs) {
        this.chosenCircle = hs;
    }

    private boolean circleContainsPoint(int circleNum, Point p) {
        int y;
        int yCenter;
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int xCenter = centerX + x;
        return Point.distance(p.x, p.y, xCenter, yCenter = centerY + (y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0)))) <= (double)(this.spotDiameter / 2);
    }

    private int getCircleX(int circleNum) {
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        return centerX + x;
    }

    private int getCircleY(int circleNum) {
        Dimension size = this.getPreferredSize();
        int distFromCenter = size.width / 2 - this.spotDiameter / 2;
        int centerX = size.width / 2;
        int centerY = size.width / 2;
        int x = (int)this.polarToX(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        int y = (int)this.polarToY(distFromCenter, (float)(Math.PI * 2 * (double)circleNum / 9.0));
        return centerY + y;
    }
}

